/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.network;

import com.talhanation.recruits.CommandEvents;
import com.talhanation.recruits.world.RecruitsGroup;
import de.maxhenkel.recruits.corelib.net.Message;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.network.NetworkEvent;

public class MessageSaveFormationFollowMovement
implements Message<MessageSaveFormationFollowMovement> {
    private UUID player_uuid;
    private CompoundTag groups;
    private int formation;

    public MessageSaveFormationFollowMovement() {
    }

    public MessageSaveFormationFollowMovement(UUID player_uuid, List<UUID> groups, int formation) {
        this.player_uuid = player_uuid;
        this.groups = RecruitsGroup.uuidListToNbt(groups);
        this.formation = formation;
    }

    @Override
    public Dist getExecutingSide() {
        return Dist.DEDICATED_SERVER;
    }

    @Override
    public void executeServerSide(NetworkEvent.Context context) {
        CommandEvents.saveFormation((Player)context.getSender(), this.formation);
        CommandEvents.saveUUIDList((Player)context.getSender(), "ActiveGroups", RecruitsGroup.uuidListFromNbt(this.groups));
    }

    @Override
    public MessageSaveFormationFollowMovement fromBytes(FriendlyByteBuf buf) {
        this.player_uuid = buf.m_130259_();
        this.groups = buf.m_130260_();
        this.formation = buf.readInt();
        return this;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130077_(this.player_uuid);
        buf.m_130079_(this.groups);
        buf.writeInt(this.formation);
    }
}

