/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.network;

import com.talhanation.recruits.CommandEvents;
import com.talhanation.recruits.entities.AbstractRecruitEntity;
import de.maxhenkel.recruits.corelib.net.Message;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.network.NetworkEvent;

public class MessageShields
implements Message<MessageShields> {
    private UUID player;
    private UUID group;
    private boolean should;

    public MessageShields() {
    }

    public MessageShields(UUID player, UUID group, boolean shields) {
        this.player = player;
        this.group = group;
        this.should = shields;
    }

    @Override
    public Dist getExecutingSide() {
        return Dist.DEDICATED_SERVER;
    }

    @Override
    public void executeServerSide(NetworkEvent.Context context) {
        ServerPlayer player = Objects.requireNonNull(context.getSender());
        player.m_20193_().m_6443_(AbstractRecruitEntity.class, context.getSender().m_20191_().m_82400_(100.0), recruit -> recruit.isEffectedByCommand(this.player, this.group)).forEach(recruit -> CommandEvents.onShieldsCommand(player, this.player, recruit, this.group, this.should));
    }

    @Override
    public MessageShields fromBytes(FriendlyByteBuf buf) {
        this.player = buf.m_130259_();
        this.group = buf.m_130259_();
        this.should = buf.readBoolean();
        return this;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130077_(this.player);
        buf.m_130077_(this.group);
        buf.writeBoolean(this.should);
    }
}

