/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.world;

import com.talhanation.recruits.ClaimEvents;
import com.talhanation.recruits.FactionEvents;
import com.talhanation.recruits.config.RecruitsServerConfig;
import com.talhanation.recruits.world.RecruitsFaction;
import com.talhanation.recruits.world.RecruitsPlayerInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;

public class RecruitsClaim {
    private final UUID uuid;
    private final List<ChunkPos> claimedChunks = new ArrayList<ChunkPos>();
    private String name;
    private RecruitsFaction ownerFaction;
    private boolean allowBlockInteraction = false;
    private boolean allowBlockPlacement = false;
    private boolean allowBlockBreaking = false;
    public List<RecruitsFaction> defendingParties = new ArrayList<RecruitsFaction>();
    public List<RecruitsFaction> attackingParties = new ArrayList<RecruitsFaction>();
    public ChunkPos center;
    public boolean isUnderSiege;
    public int health;
    public RecruitsPlayerInfo playerInfo;
    public boolean isAdmin;
    public boolean isRemoved;
    public static int MAX_SIZE = 50;

    public RecruitsClaim(String name, RecruitsFaction ownerFaction) {
        this.uuid = UUID.randomUUID();
        this.name = name;
        this.ownerFaction = ownerFaction;
        this.isAdmin = false;
        this.resetHealth();
    }

    private RecruitsClaim(UUID uuid, String name, RecruitsFaction ownerFaction) {
        this.uuid = uuid;
        this.name = name;
        this.ownerFaction = ownerFaction;
        this.isAdmin = false;
    }

    public RecruitsClaim(RecruitsFaction faction) {
        this(faction.getTeamDisplayName(), faction);
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public void setCenter(ChunkPos center) {
        this.center = center;
    }

    public ChunkPos getCenter() {
        return this.center;
    }

    public void addChunk(ChunkPos chunkPos) {
        if (this.claimedChunks.size() >= MAX_SIZE) {
            return;
        }
        if (!this.claimedChunks.contains(chunkPos)) {
            this.claimedChunks.add(chunkPos);
        }
    }

    public void removeChunk(ChunkPos chunkPos) {
        this.claimedChunks.remove(chunkPos);
    }

    public boolean containsChunk(ChunkPos chunkPos) {
        return this.claimedChunks.contains(chunkPos);
    }

    public List<ChunkPos> getClaimedChunks() {
        return this.claimedChunks;
    }

    public String getName() {
        return this.name;
    }

    public String getOwnerFactionStringID() {
        return this.ownerFaction.getStringID();
    }

    public RecruitsFaction getOwnerFaction() {
        return this.ownerFaction;
    }

    public RecruitsPlayerInfo getPlayerInfo() {
        return this.playerInfo;
    }

    public boolean isBlockInteractionAllowed() {
        return this.allowBlockInteraction;
    }

    public boolean isBlockPlacementAllowed() {
        return this.allowBlockPlacement;
    }

    public boolean isBlockBreakingAllowed() {
        return this.allowBlockBreaking;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAdminClaim(boolean admin) {
        this.isAdmin = admin;
    }

    public void setOwnerFaction(RecruitsFaction faction) {
        this.ownerFaction = faction;
    }

    public void setPlayer(RecruitsPlayerInfo playerInfo) {
        this.playerInfo = playerInfo;
    }

    public void setBlockInteractionAllowed(boolean allow) {
        this.allowBlockInteraction = allow;
    }

    public void setBlockPlacementAllowed(boolean allow) {
        this.allowBlockPlacement = allow;
    }

    public void setBlockBreakingAllowed(boolean allow) {
        this.allowBlockBreaking = allow;
    }

    public int getHealth() {
        return this.health;
    }

    public void setHealth(int health) {
        this.health = health;
    }

    public String toString() {
        return this.getName();
    }

    public CompoundTag toNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128362_("UUID", this.uuid);
        nbt.m_128359_("name", this.name);
        if (this.ownerFaction != null) {
            nbt.m_128365_("ownerFaction", (Tag)this.ownerFaction.toNBT());
        }
        if (this.playerInfo != null) {
            nbt.m_128365_("playerInfo", (Tag)this.playerInfo.toNBT());
        }
        nbt.m_128379_("allowInteraction", this.allowBlockInteraction);
        nbt.m_128379_("allowPlacement", this.allowBlockPlacement);
        nbt.m_128379_("allowBreaking", this.allowBlockBreaking);
        nbt.m_128379_("isAdmin", this.isAdmin);
        nbt.m_128379_("isUnderSiege", this.isUnderSiege);
        nbt.m_128379_("isRemoved", this.isRemoved);
        ListTag chunkList = new ListTag();
        for (ChunkPos chunkPos : this.claimedChunks) {
            CompoundTag chunkTag = new CompoundTag();
            chunkTag.m_128405_("x", chunkPos.f_45578_);
            chunkTag.m_128405_("z", chunkPos.f_45579_);
            chunkList.add((Object)chunkTag);
        }
        nbt.m_128365_("chunks", (Tag)chunkList);
        nbt.m_128405_("centerX", this.getCenter().f_45578_);
        nbt.m_128405_("centerZ", this.getCenter().f_45579_);
        nbt.m_128405_("health", this.getHealth());
        ListTag defendingList = new ListTag();
        if (this.defendingParties != null && !this.defendingParties.isEmpty()) {
            for (RecruitsFaction team : this.defendingParties) {
                if (team == null) continue;
                defendingList.add((Object)team.toNBT());
            }
        }
        nbt.m_128365_("defendingParties", (Tag)defendingList);
        ListTag listTag = new ListTag();
        if (this.attackingParties != null && !this.attackingParties.isEmpty()) {
            for (RecruitsFaction team : this.attackingParties) {
                if (team == null) continue;
                listTag.add((Object)team.toNBT());
            }
        }
        nbt.m_128365_("attackingParties", (Tag)listTag);
        return nbt;
    }

    public static RecruitsClaim fromNBT(CompoundTag nbt) {
        UUID uuid = nbt.m_128342_("UUID");
        String name = nbt.m_128461_("name");
        RecruitsFaction recruitsFaction = RecruitsFaction.fromNBT(nbt.m_128469_("ownerFaction"));
        RecruitsClaim claim = new RecruitsClaim(uuid, name, recruitsFaction);
        RecruitsPlayerInfo playerInfo = RecruitsPlayerInfo.getFromNBT(nbt.m_128469_("playerInfo"));
        if (playerInfo != null) {
            claim.setPlayer(playerInfo);
        }
        claim.setBlockInteractionAllowed(nbt.m_128471_("allowInteraction"));
        claim.setBlockPlacementAllowed(nbt.m_128471_("allowPlacement"));
        claim.setBlockBreakingAllowed(nbt.m_128471_("allowBreaking"));
        claim.setAdminClaim(nbt.m_128471_("isAdmin"));
        claim.isUnderSiege = nbt.m_128471_("isUnderSiege");
        claim.isRemoved = nbt.m_128471_("isRemoved");
        if (nbt.m_128425_("chunks", 9)) {
            ListTag chunkList = nbt.m_128437_("chunks", 10);
            for (Tag tag : chunkList) {
                CompoundTag chunkTag = (CompoundTag)tag;
                int x = chunkTag.m_128451_("x");
                int z = chunkTag.m_128451_("z");
                claim.addChunk(new ChunkPos(x, z));
            }
        }
        int x = nbt.m_128451_("centerX");
        int z = nbt.m_128451_("centerZ");
        claim.setCenter(new ChunkPos(x, z));
        claim.setHealth(nbt.m_128451_("health"));
        if (nbt.m_128425_("defendingParties", 9)) {
            ListTag defendingList = nbt.m_128437_("defendingParties", 10);
            for (Tag tag : defendingList) {
                claim.defendingParties.add(RecruitsFaction.fromNBT((CompoundTag)tag));
            }
        }
        if (nbt.m_128425_("attackingParties", 9)) {
            ListTag attackingList = nbt.m_128437_("attackingParties", 10);
            for (Tag tag : attackingList) {
                claim.attackingParties.add(RecruitsFaction.fromNBT((CompoundTag)tag));
            }
        }
        return claim;
    }

    public static CompoundTag toNBT(List<RecruitsClaim> list) {
        CompoundTag nbt = new CompoundTag();
        ListTag claimList = new ListTag();
        for (RecruitsClaim claim : list) {
            claimList.add((Object)claim.toNBT());
        }
        nbt.m_128365_("Claims", (Tag)claimList);
        return nbt;
    }

    public static List<RecruitsClaim> getListFromNBT(CompoundTag nbt) {
        ArrayList<RecruitsClaim> list = new ArrayList<RecruitsClaim>();
        ListTag claimList = nbt.m_128437_("Claims", 10);
        for (int i = 0; i < claimList.size(); ++i) {
            CompoundTag claimTag = claimList.m_128728_(i);
            RecruitsClaim claim = RecruitsClaim.fromNBT(claimTag);
            list.add(claim);
        }
        return list;
    }

    public void setSiegeSuccess(ServerLevel level) {
        for (Player player : FactionEvents.recruitsFactionManager.getPlayersInTeam(this.getOwnerFactionStringID(), level)) {
            player.m_213846_(this.SIEGE_SUCCESS_DEFENDER(this.getName()));
        }
        RecruitsFaction faction = this.attackingParties.get(0);
        this.setOwnerFaction(faction);
        this.setPlayer(new RecruitsPlayerInfo(faction.getTeamLeaderUUID(), faction.getTeamLeaderName(), faction));
        this.isUnderSiege = false;
        this.resetHealth();
        for (Player player : FactionEvents.recruitsFactionManager.getPlayersInTeam(this.getOwnerFactionStringID(), level)) {
            player.m_213846_(this.SIEGE_SUCCESS_ATTACKER(this.getName()));
        }
        this.attackingParties.clear();
        this.defendingParties.clear();
    }

    public void resetHealth() {
        this.health = this.getMaxHealth();
    }

    public int getMaxHealth() {
        return 60 * (Integer)RecruitsServerConfig.SiegeClaimsConquerTime.get();
    }

    public void setUnderSiege(boolean newState, ServerLevel level) {
        if (this.isUnderSiege == newState) {
            return;
        }
        RecruitsFaction owner = this.getOwnerFaction();
        if (owner == null) {
            return;
        }
        if (newState) {
            this.startSiege(owner, level);
        } else {
            this.endSiege(owner, level);
        }
        this.isUnderSiege = newState;
    }

    private void startSiege(RecruitsFaction owner, ServerLevel level) {
        this.notifyDefendersSiegeStart(owner, level);
        this.notifyAttackersSiegeStart(level);
        ClaimEvents.sendVillagersHome(level, this);
    }

    private void endSiege(RecruitsFaction owner, ServerLevel level) {
        this.notifyDefendersSiegeFailed(owner, level);
        this.notifyAttackersSiegeFailed(level);
    }

    private void notifyDefendersSiegeStart(RecruitsFaction owner, ServerLevel level) {
        Component msg = this.SIEGE_START_DEFENDER(this.getName(), this.getAttackingParties().toString());
        for (Player player : this.getPlayersOfFaction(owner, level)) {
            player.m_213846_(msg);
        }
    }

    private void notifyAttackersSiegeStart(ServerLevel level) {
        Component msg = this.SIEGE_START_ATTACKER(this.getName());
        for (RecruitsFaction attacker : this.getAttackingParties()) {
            for (Player player : this.getPlayersOfFaction(attacker, level)) {
                player.m_213846_(msg);
            }
        }
    }

    private void notifyDefendersSiegeFailed(RecruitsFaction owner, ServerLevel level) {
        Component msg = this.SIEGE_FAILED_DEFENDER(this.getName());
        for (Player player : this.getPlayersOfFaction(owner, level)) {
            player.m_213846_(msg);
        }
    }

    private void notifyAttackersSiegeFailed(ServerLevel level) {
        Component msg = this.SIEGE_FAILED_ATTACKER(this.getName());
        for (RecruitsFaction attacker : this.getAttackingParties()) {
            for (Player player : this.getPlayersOfFaction(attacker, level)) {
                player.m_213846_(msg);
            }
        }
    }

    public void addParty(List<RecruitsFaction> list, RecruitsFaction recruitsFaction) {
        if (list.isEmpty()) {
            return;
        }
        for (RecruitsFaction attacker : list) {
            if (attacker == null || !attacker.getStringID().equals(recruitsFaction.getStringID())) continue;
            return;
        }
        list.add(recruitsFaction);
    }

    private List<RecruitsFaction> getAttackingParties() {
        return this.attackingParties == null ? Collections.emptyList() : this.attackingParties;
    }

    private List<ServerPlayer> getPlayersOfFaction(RecruitsFaction faction, ServerLevel level) {
        return FactionEvents.recruitsFactionManager.getPlayersInTeam(faction.getStringID(), level);
    }

    public Component SIEGE_START_ATTACKER(String claim) {
        return Component.m_237110_((String)"chat.recruits.text.siegeStartAttacker", (Object[])new Object[]{claim}).m_130940_(ChatFormatting.GOLD);
    }

    public Component SIEGE_START_DEFENDER(String claim, String attackers) {
        return Component.m_237110_((String)"chat.recruits.text.siegeStartDefender", (Object[])new Object[]{claim, attackers}).m_130940_(ChatFormatting.GOLD);
    }

    public Component SIEGE_FAILED_ATTACKER(String claim) {
        return Component.m_237110_((String)"chat.recruits.text.siegeFailedAttacker", (Object[])new Object[]{claim}).m_130940_(ChatFormatting.GOLD);
    }

    public Component SIEGE_FAILED_DEFENDER(String claim) {
        return Component.m_237110_((String)"chat.recruits.text.siegeFailedDefender", (Object[])new Object[]{claim}).m_130940_(ChatFormatting.GOLD);
    }

    public Component SIEGE_SUCCESS_ATTACKER(String claim) {
        return Component.m_237110_((String)"chat.recruits.text.siegeSuccessAttacker", (Object[])new Object[]{claim}).m_130940_(ChatFormatting.GOLD);
    }

    public Component SIEGE_SUCCESS_DEFENDER(String claim) {
        return Component.m_237110_((String)"chat.recruits.text.siegeSuccessDefender", (Object[])new Object[]{claim}).m_130940_(ChatFormatting.GOLD);
    }
}

