/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.world;

import com.talhanation.recruits.FactionEvents;
import com.talhanation.recruits.Main;
import com.talhanation.recruits.config.RecruitsServerConfig;
import com.talhanation.recruits.network.MessageToClientUpdateFactions;
import com.talhanation.recruits.network.MessageToClientUpdateOnlinePlayers;
import com.talhanation.recruits.network.MessageToClientUpdateOwnFaction;
import com.talhanation.recruits.world.RecruitsFaction;
import com.talhanation.recruits.world.RecruitsPlayerInfo;
import com.talhanation.recruits.world.RecruitsTeamSaveData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraftforge.network.PacketDistributor;

public class RecruitsFactionManager {
    private final Map<String, RecruitsFaction> teams = new HashMap<String, RecruitsFaction>();

    public void load(ServerLevel level) {
        RecruitsTeamSaveData data = RecruitsTeamSaveData.get(level);
        this.teams.clear();
        this.teams.putAll(data.getTeams());
        this.teams.values().forEach(this::loadConfig);
    }

    public void loadConfig(RecruitsFaction team) {
        team.maxPlayers = (Integer)RecruitsServerConfig.MaxPlayersInFaction.get();
        team.maxNPCs = (Integer)RecruitsServerConfig.MaxNPCsInFaction.get();
    }

    public void save(ServerLevel level) {
        RecruitsTeamSaveData data = RecruitsTeamSaveData.get(level);
        data.setTeams(this.teams);
        data.m_77762_();
        this.broadcastOwnFactionToAll(level);
        this.broadcastFactionsToAll(level);
        this.broadcastOnlinePlayersToAll(level);
    }

    public Collection<RecruitsFaction> getFactions() {
        return this.teams.values();
    }

    @Nullable
    public RecruitsFaction getFactionByStringID(String stringID) {
        return this.teams.get(stringID);
    }

    public List<ServerPlayer> getPlayersInTeam(String stringID, ServerLevel level) {
        ServerScoreboard scoreboard = level.m_6188_();
        PlayerTeam playerTeam = scoreboard.m_83489_(stringID);
        ArrayList<ServerPlayer> list = new ArrayList<ServerPlayer>();
        if (playerTeam != null) {
            for (ServerPlayer p : level.m_6907_()) {
                if (!playerTeam.m_6809_().contains(p.m_7755_().getString())) continue;
                list.add(p);
            }
        }
        return list;
    }

    @Nullable
    public ServerPlayer getTeamLeader(RecruitsFaction recruitsFaction, ServerLevel level) {
        for (ServerPlayer p : level.m_6907_()) {
            if (!p.m_20148_().equals(recruitsFaction.getTeamLeaderUUID())) continue;
            return p;
        }
        return null;
    }

    public void addTeam(String teamName, String teamDisplayName, UUID leaderUUID, String leaderName, CompoundTag bannerNbt, byte color, ChatFormatting teamColor) {
        RecruitsFaction recruitsFaction = new RecruitsFaction();
        recruitsFaction.setStringID(teamName);
        recruitsFaction.setTeamDisplayName(teamDisplayName);
        recruitsFaction.setTeamLeaderID(leaderUUID);
        recruitsFaction.setTeamLeaderName(leaderName);
        recruitsFaction.setBanner(bannerNbt);
        recruitsFaction.setUnitColor(color);
        recruitsFaction.setTeamColor(teamColor.m_126656_());
        recruitsFaction.setMaxNPCsPerPlayer((Integer)RecruitsServerConfig.MaxRecruitsForPlayer.get());
        recruitsFaction.setMaxPlayers((Integer)RecruitsServerConfig.MaxPlayersInFaction.get());
        recruitsFaction.setMaxNPCs((Integer)RecruitsServerConfig.MaxNPCsInFaction.get());
        this.teams.put(teamName, recruitsFaction);
    }

    public void removeTeam(String teamName) {
        this.teams.remove(teamName);
    }

    public static boolean isNameInUse(String teamName, List<RecruitsFaction> factions) {
        boolean equ = false;
        for (RecruitsFaction recruitsFaction : factions) {
            equ = recruitsFaction.getStringID().toLowerCase().strip().equals(teamName.toLowerCase());
        }
        return equ;
    }

    public static boolean isDisplayNameInUse(String displayName, List<RecruitsFaction> factions) {
        boolean equ = false;
        for (RecruitsFaction recruitsFaction : factions) {
            equ = recruitsFaction.getTeamDisplayName().toLowerCase().strip().equals(displayName.toLowerCase());
        }
        return equ;
    }

    public static boolean isBannerInUse(CompoundTag bannerNbt, List<RecruitsFaction> factions) {
        boolean inUse = false;
        if (bannerNbt != null) {
            for (RecruitsFaction recruitsFaction : factions) {
                inUse = bannerNbt.equals((Object)recruitsFaction.getBanner());
            }
        }
        return inUse;
    }

    public static boolean isBannerBlank(ItemStack itemStack) {
        CompoundTag compoundtag = BlockItem.m_186336_((ItemStack)itemStack);
        return compoundtag == null || !compoundtag.m_128441_("Patterns");
    }

    public boolean isDisplayNameInUse(String displayName) {
        return RecruitsFactionManager.isDisplayNameInUse(displayName, this.getFactions().stream().toList());
    }

    public boolean isNameInUse(String factionName) {
        return RecruitsFactionManager.isNameInUse(factionName, this.getFactions().stream().toList());
    }

    public boolean isBannerInUse(CompoundTag bannerNbt) {
        return RecruitsFactionManager.isBannerInUse(bannerNbt, this.getFactions().stream().toList());
    }

    public void broadcastOnlinePlayersToPlayer(ServerPlayer serverPlayer, ServerLevel serverLevel) {
        if (serverPlayer == null) {
            return;
        }
        ArrayList<RecruitsPlayerInfo> playerInfoList = new ArrayList<RecruitsPlayerInfo>();
        for (ServerPlayer onlinePlayer : serverLevel.m_6907_()) {
            if (onlinePlayer.m_5647_() != null) {
                RecruitsFaction faction = this.getFactionByStringID(onlinePlayer.m_5647_().m_5758_());
                playerInfoList.add(new RecruitsPlayerInfo(onlinePlayer.m_20148_(), onlinePlayer.m_6302_(), faction));
                continue;
            }
            playerInfoList.add(new RecruitsPlayerInfo(onlinePlayer.m_20148_(), onlinePlayer.m_6302_()));
        }
        Main.SIMPLE_CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new MessageToClientUpdateOnlinePlayers(playerInfoList));
    }

    public void broadcastFactionsToAll(ServerLevel serverLevel) {
        if (serverLevel == null) {
            return;
        }
        for (ServerPlayer serverPlayer : serverLevel.m_7654_().m_6846_().m_11314_()) {
            this.broadcastFactionsToPlayer((Player)serverPlayer);
        }
    }

    public void broadcastToFactionPlayers(String factionID, ServerLevel serverLevel) {
        if (serverLevel == null) {
            return;
        }
        RecruitsFaction faction = this.getFactionByStringID(factionID);
        if (faction == null) {
            return;
        }
        PlayerTeam team = serverLevel.m_6188_().m_83489_(factionID);
        if (team == null) {
            return;
        }
        for (String playerName : team.m_6809_()) {
            ServerPlayer player = serverLevel.m_7654_().m_6846_().m_11255_(playerName);
            if (player == null) continue;
            this.broadcastOwnFactionToPlayer((Player)player);
        }
    }

    private void broadcastOwnFactionToPlayer(Player player) {
        String teamName = "";
        if (player.m_5647_() != null) {
            teamName = player.m_5647_().m_5758_();
        }
        RecruitsFaction faction = this.getFactionByStringID(teamName);
        Main.SIMPLE_CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new MessageToClientUpdateOwnFaction(faction));
    }

    public void broadcastFactionsToPlayer(Player player) {
        if (player == null) {
            return;
        }
        String factionID = null;
        if (player.m_5647_() != null) {
            factionID = player.m_5647_().m_5758_();
        }
        Main.SIMPLE_CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new MessageToClientUpdateFactions(this.getFactions().stream().toList(), factionID, (Boolean)RecruitsServerConfig.ShouldFactionEditingBeAllowed.get(), (Boolean)RecruitsServerConfig.ShouldFactionManagingBeAllowed.get(), (Integer)RecruitsServerConfig.FactionCreationCost.get(), (Integer)RecruitsServerConfig.MaxRecruitsForPlayer.get(), FactionEvents.getCurrency()));
        this.broadcastOwnFactionToPlayer(player);
    }

    public void broadcastOnlinePlayersToAll(ServerLevel serverLevel) {
        if (serverLevel == null) {
            return;
        }
        ArrayList<RecruitsPlayerInfo> playerInfoList = new ArrayList<RecruitsPlayerInfo>();
        for (ServerPlayer onlinePlayer : serverLevel.m_7654_().m_6846_().m_11314_()) {
            if (onlinePlayer.m_5647_() != null) {
                RecruitsFaction faction = this.getFactionByStringID(onlinePlayer.m_5647_().m_5758_());
                playerInfoList.add(new RecruitsPlayerInfo(onlinePlayer.m_20148_(), onlinePlayer.m_6302_(), faction));
                continue;
            }
            playerInfoList.add(new RecruitsPlayerInfo(onlinePlayer.m_20148_(), onlinePlayer.m_6302_()));
        }
        for (ServerPlayer serverPlayer : serverLevel.m_7654_().m_6846_().m_11314_()) {
            Main.SIMPLE_CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new MessageToClientUpdateOnlinePlayers(playerInfoList));
        }
    }

    public void broadcastOwnFactionToAll(ServerLevel serverLevel) {
        if (serverLevel == null) {
            return;
        }
        for (ServerPlayer serverPlayer : serverLevel.m_7654_().m_6846_().m_11314_()) {
            this.broadcastOwnFactionToPlayer((Player)serverPlayer);
        }
    }
}

