/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.world;

import com.talhanation.recruits.Main;
import com.talhanation.recruits.entities.AbstractRecruitEntity;
import com.talhanation.recruits.network.MessageToClientUpdateGroups;
import com.talhanation.recruits.world.RecruitsGroup;
import com.talhanation.recruits.world.RecruitsGroupsSaveData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.PacketDistributor;

public class RecruitsGroupsManager {
    private final List<RecruitsGroup> groups = new ArrayList<RecruitsGroup>();
    private final Map<UUID, RecruitsGroup> groupMap = new HashMap<UUID, RecruitsGroup>();
    private final Map<UUID, UUID> redirects = new HashMap<UUID, UUID>();
    private final Map<UUID, UUID> recruitRedirects = new HashMap<UUID, UUID>();
    private static final String[] ROMAN = new String[]{"", "I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX", "X"};

    public void load(ServerLevel level) {
        RecruitsGroupsSaveData data = RecruitsGroupsSaveData.get(level);
        this.groups.clear();
        this.redirects.clear();
        for (RecruitsGroup group : data.getAllGroups()) {
            this.addGroup(group);
        }
        this.redirects.putAll(data.getRedirects());
        this.recruitRedirects.putAll(data.getRecruitRedirects());
    }

    public void save(ServerLevel level) {
        RecruitsGroupsSaveData data = RecruitsGroupsSaveData.get(level);
        data.setAllGroups(this.groups);
        data.setRedirects(this.redirects);
        data.setRecruitRedirects(this.recruitRedirects);
        data.m_77762_();
    }

    public void addOrUpdateGroup(ServerLevel level, ServerPlayer player, RecruitsGroup incoming) {
        if (incoming == null || level == null) {
            return;
        }
        UUID id = this.resolveGroup(incoming.getUUID());
        RecruitsGroup existing = this.groupMap.get(id);
        if (existing != null) {
            incoming.members = existing.members;
            incoming.setUUID(existing.getUUID());
        }
        this.removeGroup(id);
        if (!incoming.removed) {
            this.addGroup(incoming);
        }
        this.save(level);
        this.broadCastGroupsToPlayer((Player)player);
    }

    private void addGroup(RecruitsGroup group) {
        this.groups.add(group);
        this.groupMap.put(group.getUUID(), group);
    }

    public void removeGroup(UUID group) {
        if (group == null) {
            return;
        }
        this.groupMap.remove(group);
        this.groups.removeIf(saved -> saved.getUUID().equals(group));
    }

    @Nullable
    public RecruitsGroup getGroup(UUID groupUUID) {
        groupUUID = this.resolveGroup(groupUUID);
        return this.groupMap.get(groupUUID);
    }

    public void addMember(UUID groupUUID, UUID member, ServerLevel serverLevel) {
        RecruitsGroup group = this.groupMap.get(groupUUID = this.resolveGroup(groupUUID));
        if (group == null) {
            return;
        }
        group.addMember(member);
        this.save(serverLevel);
        this.broadCastGroupsToPlayer(serverLevel, group.getPlayerUUID());
    }

    public void removeMember(UUID groupUUID, UUID member, ServerLevel serverLevel) {
        RecruitsGroup group = this.groupMap.get(groupUUID = this.resolveGroup(groupUUID));
        if (group == null) {
            return;
        }
        group.removeMember(member);
        this.save(serverLevel);
        this.broadCastGroupsToPlayer(serverLevel, group.getPlayerUUID());
    }

    public List<RecruitsGroup> getPlayerGroups(Player player) {
        ArrayList<RecruitsGroup> list = new ArrayList<RecruitsGroup>();
        for (RecruitsGroup group : this.groups) {
            if (!group.getPlayerUUID().equals(player.m_20148_())) continue;
            list.add(group);
        }
        if (list.isEmpty()) {
            list.addAll(RecruitsGroupsManager.getBaseGroups(player));
            for (RecruitsGroup group : list) {
                this.addGroup(group);
            }
        }
        return list;
    }

    public List<RecruitsGroup> getPlayerGroupsForClient(Player player) {
        ArrayList<RecruitsGroup> list = new ArrayList<RecruitsGroup>();
        for (RecruitsGroup group : this.getPlayerGroups(player)) {
            RecruitsGroup copy = group.copy();
            copy.setUUID(group.getUUID());
            list.add(copy);
        }
        return list;
    }

    @Nullable
    public RecruitsGroup getPlayersGroupByName(Player player, String name) {
        if (player == null || name == null) {
            return null;
        }
        List<RecruitsGroup> groups = this.getPlayerGroups(player);
        for (RecruitsGroup group : groups) {
            if (!group.getName().equalsIgnoreCase(name)) continue;
            return group;
        }
        return null;
    }

    public List<RecruitsGroup> getAllGroups() {
        return this.groups;
    }

    public void broadCastGroupsToPlayer(ServerLevel level, UUID playerUUID) {
        for (ServerPlayer player : level.m_7654_().m_6846_().m_11314_()) {
            if (!player.m_20148_().equals(playerUUID)) continue;
            this.broadCastGroupsToPlayer((Player)player);
            return;
        }
    }

    public void broadCastGroupsToPlayer(Player player) {
        if (player == null) {
            return;
        }
        Main.SIMPLE_CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new MessageToClientUpdateGroups(RecruitsGroup.listToNbt(this.getPlayerGroupsForClient(player))));
    }

    public static List<RecruitsGroup> getBaseGroups(Player player) {
        return Arrays.asList(new RecruitsGroup("Infantry", player, 0), new RecruitsGroup("Ranged", player, 2), new RecruitsGroup("Cavalry", player, 5), new RecruitsGroup("Ranged Cavalry", player, 6));
    }

    public void addRedirect(UUID oldId, UUID newId) {
        this.redirects.put(oldId, newId);
    }

    public UUID resolveGroup(UUID uuid) {
        while (this.redirects.containsKey(uuid)) {
            uuid = this.redirects.get(uuid);
        }
        return uuid;
    }

    public UUID resolveRecruit(UUID recruitUUID, UUID fallbackGroupUUID) {
        if (this.recruitRedirects.containsKey(recruitUUID)) {
            return this.recruitRedirects.remove(recruitUUID);
        }
        return fallbackGroupUUID;
    }

    public void mergeGroups(RecruitsGroup groupToMerge, RecruitsGroup baseGroup, ServerLevel serverLevel) {
        baseGroup.members.addAll(groupToMerge.members);
        baseGroup.setSize(baseGroup.members.size());
        this.addRedirect(groupToMerge.getUUID(), baseGroup.getUUID());
        this.updateRecruitEntities(serverLevel, baseGroup, groupToMerge.members);
        this.removeGroup(groupToMerge.getUUID());
        this.save(serverLevel);
        this.broadCastGroupsToPlayer(serverLevel, groupToMerge.getPlayerUUID());
    }

    public void splitGroup(RecruitsGroup original, ServerLevel serverLevel) {
        ArrayList<UUID> members = new ArrayList<UUID>(original.members);
        if (members.size() < 2) {
            return;
        }
        RecruitsGroup newGroup = original.copy();
        newGroup.setUUID(UUID.randomUUID());
        newGroup.setName(this.getNextGroupName(original.getName()));
        newGroup.members.clear();
        ArrayList<UUID> remain = new ArrayList<UUID>();
        ArrayList<UUID> moved = new ArrayList<UUID>();
        for (int i = 0; i < members.size(); ++i) {
            if (i % 2 == 0) {
                moved.add((UUID)members.get(i));
                continue;
            }
            remain.add((UUID)members.get(i));
        }
        original.members = remain;
        newGroup.members = moved;
        original.setSize(remain.size());
        newGroup.setSize(moved.size());
        this.addGroup(newGroup);
        this.updateRecruitEntities(serverLevel, original, remain);
        this.updateRecruitEntities(serverLevel, newGroup, moved);
        this.save(serverLevel);
        this.broadCastGroupsToPlayer(serverLevel, original.getPlayerUUID());
    }

    private void updateRecruitEntities(ServerLevel level, RecruitsGroup newGroup, List<UUID> memberList) {
        for (UUID uuid : memberList) {
            AbstractRecruitEntity r;
            AbstractRecruitEntity recruit;
            Entity entity = level.m_8791_(uuid);
            AbstractRecruitEntity abstractRecruitEntity = recruit = entity instanceof AbstractRecruitEntity ? (r = (AbstractRecruitEntity)entity) : null;
            if (recruit != null) {
                recruit.setGroupUUID(newGroup.getUUID());
                recruit.needsGroupUpdate = true;
                continue;
            }
            this.recruitRedirects.put(uuid, newGroup.getUUID());
        }
    }

    private String getNextGroupName(String baseName) {
        String[] parts = baseName.trim().split(" ");
        String last = parts[parts.length - 1];
        int current = 1;
        for (int i = 1; i < ROMAN.length; ++i) {
            if (!ROMAN[i].equals(last)) continue;
            current = i + 1;
            baseName = String.join((CharSequence)" ", Arrays.copyOf(parts, parts.length - 1));
            break;
        }
        if (current >= ROMAN.length) {
            return baseName + " " + current;
        }
        return baseName + " " + ROMAN[current];
    }
}

