/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.world;

import com.talhanation.recruits.FactionEvents;
import com.talhanation.recruits.Main;
import com.talhanation.recruits.config.RecruitsServerConfig;
import com.talhanation.recruits.network.MessageToClientUpdateUnitInfo;
import com.talhanation.recruits.world.RecruitPlayerUnitSaveData;
import com.talhanation.recruits.world.RecruitsFaction;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.PacketDistributor;

public class RecruitsPlayerUnitManager {
    private Map<UUID, Integer> recruitCountMap = new HashMap<UUID, Integer>();

    public void load(ServerLevel level) {
        RecruitPlayerUnitSaveData data = RecruitPlayerUnitSaveData.get(level);
        this.recruitCountMap = data.getRecruitCountMap();
    }

    public void save(ServerLevel level) {
        RecruitPlayerUnitSaveData data = RecruitPlayerUnitSaveData.get(level);
        for (Map.Entry<UUID, Integer> entry : this.recruitCountMap.entrySet()) {
            data.setRecruitCount(entry.getKey(), entry.getValue());
        }
        data.m_77762_();
    }

    public int getRecruitCount(UUID playerUUID) {
        return this.recruitCountMap.getOrDefault(playerUUID, 0);
    }

    public void setRecruitCount(Player player, int count) {
        this.recruitCountMap.put(player.m_20148_(), count);
    }

    public void addRecruits(UUID playerUUID, int count) {
        this.recruitCountMap.put(playerUUID, this.getRecruitCount(playerUUID) + count);
    }

    public void removeRecruits(UUID playerUUID, int count) {
        this.recruitCountMap.put(playerUUID, Math.max(this.getRecruitCount(playerUUID) - count, 0));
    }

    public boolean canPlayerRecruit(String stringId, UUID playerUUID) {
        RecruitsFaction recruitsFaction = FactionEvents.recruitsFactionManager.getFactionByStringID(stringId);
        int currentRecruitCount = this.getRecruitCount(playerUUID);
        int maxRecruitCount = 0;
        if (recruitsFaction == null) {
            maxRecruitCount = (Integer)RecruitsServerConfig.MaxRecruitsForPlayer.get();
        } else {
            int maxRecruitsInFaction = recruitsFaction.maxNPCs;
            if (maxRecruitsInFaction == 0) {
                maxRecruitsInFaction = 1000000000;
            }
            maxRecruitCount = playerUUID.equals(recruitsFaction.getTeamLeaderUUID()) ? maxRecruitsInFaction : recruitsFaction.getMaxNPCsPerPlayer();
            if (recruitsFaction.npcs >= maxRecruitsInFaction) {
                return false;
            }
        }
        return currentRecruitCount < maxRecruitCount;
    }

    public int getRemainingRecruitSlots(String stringId, UUID playerUUID) {
        int maxRecruitCount;
        RecruitsFaction recruitsFaction = FactionEvents.recruitsFactionManager.getFactionByStringID(stringId);
        int currentRecruitCount = this.getRecruitCount(playerUUID);
        if (recruitsFaction == null) {
            maxRecruitCount = (Integer)RecruitsServerConfig.MaxRecruitsForPlayer.get();
        } else {
            maxRecruitCount = playerUUID.equals(recruitsFaction.getTeamLeaderUUID()) ? recruitsFaction.maxNPCs : recruitsFaction.getMaxNPCsPerPlayer();
            if (recruitsFaction.npcs >= recruitsFaction.maxNPCs) {
                return 0;
            }
        }
        int remaining = maxRecruitCount - currentRecruitCount;
        return Math.max(remaining, 0);
    }

    public void broadCastUnitInfoToPlayer(Player player) {
        if (player == null) {
            return;
        }
        String factionID = null;
        if (player.m_5647_() != null) {
            factionID = player.m_5647_().m_5758_();
        }
        Main.SIMPLE_CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new MessageToClientUpdateUnitInfo((Boolean)RecruitsServerConfig.NobleVillagerNeedsVillagers.get(), this.getRemainingRecruitSlots(factionID, player.m_20148_())));
    }
}

