/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.world;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;

public class RecruitsRoute {
    private UUID id;
    private String name;
    private List<Waypoint> waypoints;

    public RecruitsRoute(String name) {
        this.id = UUID.randomUUID();
        this.name = name;
        this.waypoints = new ArrayList<Waypoint>();
    }

    public RecruitsRoute(UUID id, String name, List<Waypoint> waypoints) {
        this.id = id;
        this.name = name;
        this.waypoints = waypoints;
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Waypoint> getWaypoints() {
        return this.waypoints;
    }

    public void addWaypoint(Waypoint waypoint) {
        this.waypoints.add(waypoint);
    }

    public void removeWaypoint(Waypoint waypoint) {
        this.waypoints.remove(waypoint);
    }

    public CompoundTag toNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128362_("ID", this.id);
        nbt.m_128359_("Name", this.name);
        ListTag waypointList = new ListTag();
        for (Waypoint waypoint : this.waypoints) {
            waypointList.add((Object)waypoint.toNBT());
        }
        nbt.m_128365_("Waypoints", (Tag)waypointList);
        return nbt;
    }

    public static RecruitsRoute fromNBT(CompoundTag nbt) {
        if (nbt == null || nbt.m_128456_()) {
            return null;
        }
        UUID id = nbt.m_128342_("ID");
        String name = nbt.m_128461_("Name");
        ArrayList<Waypoint> waypoints = new ArrayList<Waypoint>();
        ListTag waypointList = nbt.m_128437_("Waypoints", 10);
        for (int i = 0; i < waypointList.size(); ++i) {
            CompoundTag waypointTag = waypointList.m_128728_(i);
            Waypoint waypoint = Waypoint.fromNBT(waypointTag);
            if (waypoint == null) continue;
            waypoints.add(waypoint);
        }
        return new RecruitsRoute(id, name, waypoints);
    }

    public void saveToFile(File directory) throws IOException {
        if (!directory.exists()) {
            directory.mkdirs();
        }
        File routeFile = new File(directory, this.name + ".nbt");
        CompoundTag nbt = this.toNBT();
        NbtIo.m_128955_((CompoundTag)nbt, (File)routeFile);
    }

    @Nullable
    public static RecruitsRoute loadFromFile(File file) throws IOException {
        if (!file.exists()) {
            return null;
        }
        CompoundTag nbt = NbtIo.m_128953_((File)file);
        if (nbt == null) {
            return null;
        }
        return RecruitsRoute.fromNBT(nbt);
    }

    public static List<RecruitsRoute> loadAllRoutes(File directory) throws IOException {
        ArrayList<RecruitsRoute> routes = new ArrayList<RecruitsRoute>();
        if (!directory.exists()) {
            return routes;
        }
        File[] files = directory.listFiles((dir, name) -> name.endsWith(".nbt"));
        if (files == null) {
            return routes;
        }
        for (File file : files) {
            RecruitsRoute route = RecruitsRoute.loadFromFile(file);
            if (route == null) continue;
            routes.add(route);
        }
        return routes;
    }

    public static File getRoutesDirectory() {
        return new File(Minecraft.m_91087_().f_91069_, "recruits/routes/");
    }

    public static class Waypoint {
        private String name;
        private BlockPos position;

        public Waypoint(String name, BlockPos position) {
            this.name = name;
            this.position = position;
        }

        public String getName() {
            return this.name;
        }

        public BlockPos getPosition() {
            return this.position;
        }

        public CompoundTag toNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("Name", this.name);
            nbt.m_128405_("X", this.position.m_123341_());
            nbt.m_128405_("Y", this.position.m_123342_());
            nbt.m_128405_("Z", this.position.m_123343_());
            return nbt;
        }

        @Nullable
        public static Waypoint fromNBT(CompoundTag nbt) {
            if (nbt == null || nbt.m_128456_()) {
                return null;
            }
            String name = nbt.m_128461_("Name");
            int x = nbt.m_128451_("X");
            int y = nbt.m_128451_("Y");
            int z = nbt.m_128451_("Z");
            return new Waypoint(name, new BlockPos(x, y, z));
        }
    }
}

