/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.world;

import com.talhanation.recruits.world.RecruitsFaction;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class RecruitsTeamSaveData
extends SavedData {
    public static final String FILE_ID = "recruitsTeamSaveData";
    private Map<String, RecruitsFaction> teams = new HashMap<String, RecruitsFaction>();

    public static RecruitsTeamSaveData get(ServerLevel level) {
        DimensionDataStorage storage = level.m_8895_();
        return (RecruitsTeamSaveData)storage.m_164861_(RecruitsTeamSaveData::load, RecruitsTeamSaveData::new, FILE_ID);
    }

    public static RecruitsTeamSaveData load(CompoundTag nbt) {
        RecruitsTeamSaveData data = new RecruitsTeamSaveData();
        if (nbt.m_128425_("Teams", 9)) {
            data.teams = RecruitsTeamSaveData.loadTeams(nbt.m_128437_("Teams", 10));
        }
        return data;
    }

    private static Map<String, RecruitsFaction> loadTeams(ListTag list) {
        HashMap<String, RecruitsFaction> loadedTeams = new HashMap<String, RecruitsFaction>();
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag nbt = list.m_128728_(i);
            RecruitsFaction recruitsFaction = new RecruitsFaction();
            recruitsFaction.setStringID(nbt.m_128461_("TeamName"));
            recruitsFaction.setTeamDisplayName(nbt.m_128461_("TeamDisplayName"));
            recruitsFaction.setTeamLeaderID(nbt.m_128342_("TeamLeaderID"));
            recruitsFaction.setTeamLeaderName(nbt.m_128461_("TeamLeaderName"));
            recruitsFaction.setBanner((CompoundTag)nbt.m_128423_("TeamBanner"));
            recruitsFaction.setPlayers(nbt.m_128451_("Players"));
            recruitsFaction.setNPCs(nbt.m_128451_("NPCs"));
            recruitsFaction.setMaxPlayers(nbt.m_128451_("MaxPlayers"));
            recruitsFaction.setMaxNPCs(nbt.m_128451_("MaxNPCs"));
            ListTag joinRequestsList = nbt.m_128437_("JoinRequests", 8);
            for (int j = 0; j < joinRequestsList.size(); ++j) {
                recruitsFaction.getJoinRequests().add(joinRequestsList.m_128778_(j));
            }
            recruitsFaction.setUnitColor(nbt.m_128445_("Color"));
            recruitsFaction.setTeamColor(nbt.m_128451_("TeamColor"));
            recruitsFaction.setMaxNPCsPerPlayer(nbt.m_128451_("maxNpcsPerPlayer"));
            loadedTeams.put(recruitsFaction.getStringID(), recruitsFaction);
        }
        return loadedTeams;
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        nbt.m_128365_("Teams", (Tag)this.saveTeams());
        return nbt;
    }

    private ListTag saveTeams() {
        ListTag listTag = new ListTag();
        for (RecruitsFaction team : this.teams.values()) {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("TeamName", team.getStringID());
            nbt.m_128359_("TeamDisplayName", team.getTeamDisplayName());
            nbt.m_128362_("TeamLeaderID", team.getTeamLeaderUUID());
            nbt.m_128359_("TeamLeaderName", team.getTeamLeaderName());
            nbt.m_128365_("TeamBanner", (Tag)team.getBanner());
            nbt.m_128405_("Players", team.getPlayers());
            nbt.m_128405_("NPCs", team.getNPCs());
            nbt.m_128405_("MaxPlayers", team.getMaxPlayers());
            nbt.m_128405_("MaxNPCs", team.getMaxNPCs());
            ListTag joinRequestsTag = new ListTag();
            for (String request : team.getJoinRequests()) {
                joinRequestsTag.add((Object)StringTag.m_129297_((String)request));
            }
            nbt.m_128365_("JoinRequests", (Tag)joinRequestsTag);
            nbt.m_128344_("Color", team.getUnitColor());
            nbt.m_128405_("TeamColor", team.getTeamColor());
            nbt.m_128405_("maxNpcsPerPlayer", team.getMaxNPCsPerPlayer());
            listTag.add((Object)nbt);
        }
        return listTag;
    }

    public Map<String, RecruitsFaction> getTeams() {
        return this.teams;
    }

    public void setTeams(Map<String, RecruitsFaction> teams) {
        this.teams = teams;
    }
}

