/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.furniture.refurbished.block.FurnitureHorizontalEntityBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.BathBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.fluid.FluidContainer;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.data.tag.BlockTagSupplier;
import com.mrcrayfish.furniture.refurbished.util.VoxelShapeHelper;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class BathBlock
extends FurnitureHorizontalEntityBlock
implements BlockTagSupplier {
    protected static final VoxelShape BASE_SHAPE = Block.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)32.0, (double)16.0, (double)16.0);
    protected static final VoxelShape COLLISION_SHAPE = Shapes.m_83113_((VoxelShape)BASE_SHAPE, (VoxelShape)Block.m_49796_((double)2.0, (double)4.0, (double)2.0, (double)28.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.f_82685_);
    public static final EnumProperty<Type> TYPE = EnumProperty.m_61587_((String)"type", Type.class);

    public BathBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)DIRECTION, (Comparable)Direction.NORTH)).m_61124_(TYPE, (Comparable)((Object)Type.BOTTOM)));
    }

    @Override
    protected Map<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        return ImmutableMap.copyOf(states.stream().collect(Collectors.toMap(state -> state, state -> {
            if (state.m_61143_(TYPE) == Type.HEAD) {
                return VoxelShapeHelper.rotateHorizontally(BASE_SHAPE.m_83216_(-1.0, 0.0, 0.0), (Direction)state.m_61143_((Property)DIRECTION));
            }
            return VoxelShapeHelper.rotateHorizontally(BASE_SHAPE, (Direction)state.m_61143_((Property)DIRECTION));
        })));
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        if (state.m_61143_(TYPE) == Type.HEAD) {
            return VoxelShapeHelper.rotateHorizontally(COLLISION_SHAPE.m_83216_(-1.0, 0.0, 0.0), (Direction)state.m_61143_((Property)DIRECTION));
        }
        return VoxelShapeHelper.rotateHorizontally(COLLISION_SHAPE, (Direction)state.m_61143_((Property)DIRECTION));
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos headPos;
        Direction direction = context.m_8125_();
        Level level = context.m_43725_();
        if (level.m_8055_(headPos = context.m_8083_().m_121945_(direction)).m_60629_(context) && level.m_6857_().m_61937_(headPos)) {
            return (BlockState)this.m_49966_().m_61124_((Property)DIRECTION, (Comparable)direction);
        }
        return null;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        super.m_6402_(level, pos, state, entity, stack);
        if (!level.m_5776_()) {
            BlockPos headPos = pos.m_121945_((Direction)state.m_61143_((Property)DIRECTION));
            level.m_7731_(headPos, (BlockState)state.m_61124_(TYPE, (Comparable)((Object)Type.HEAD)), 3);
            level.m_6289_(pos, Blocks.f_50016_);
            state.m_60701_((LevelAccessor)level, pos, 3);
        }
    }

    @Override
    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        super.m_6810_(state, level, pos, newState, isMoving);
        if (!state.m_60713_(newState.m_60734_())) {
            Direction direction = (Direction)state.m_61143_((Property)DIRECTION);
            Type type = (Type)((Object)state.m_61143_(TYPE));
            BlockPos otherPos = pos.m_121945_(type == Type.HEAD ? direction.m_122424_() : direction);
            BlockState otherState = level.m_8055_(otherPos);
            if (otherState.m_60734_() instanceof BathBlock && otherState.m_61143_(TYPE) != type) {
                level.m_7471_(otherPos, false);
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        BlockEntity blockEntity;
        if (!level.m_5776_() && (blockEntity = level.m_7702_(pos)) instanceof BathBlockEntity) {
            BathBlockEntity bath = (BathBlockEntity)blockEntity;
            return bath.interact(player, hand, result);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{TYPE});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new BathBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.m_5776_()) {
            return BathBlock.createTicker(type, (BlockEntityType)ModBlockEntities.BATH.get(), BathBlockEntity::clientTick);
        }
        return null;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource source) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BathBlockEntity) {
            BathBlockEntity bath = (BathBlockEntity)blockEntity;
            FluidContainer container = bath.getFluidContainer();
            if (container == null || container.isEmpty()) {
                return;
            }
            double fullness = (double)container.getStoredAmount() / (double)container.getCapacity();
            if (fullness < 0.6) {
                return;
            }
            container.getStoredFluid().m_76145_().m_230558_(level, pos, source);
        }
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BathBlockEntity) {
            BathBlockEntity bath = (BathBlockEntity)blockEntity;
            FluidContainer container = bath.getFluidContainer();
            if (container == null || container.isEmpty()) {
                return;
            }
            double fullness = (double)container.getStoredAmount() / (double)container.getCapacity();
            double startY = (double)pos.m_123342_() + 0.25;
            double endY = (double)pos.m_123342_() + 0.9375 * fullness;
            if (entity.m_20186_() < startY || entity.m_20186_() > endY) {
                return;
            }
            if (container.getStoredFluid().m_6212_((Fluid)Fluids.f_76195_)) {
                entity.m_20093_();
            } else if (container.getStoredFluid().m_6212_((Fluid)Fluids.f_76193_)) {
                if (!entity.m_20067_() && entity.f_146810_) {
                    float volume = 0.7f;
                    float pitch = 1.6f + 0.4f * (level.f_46441_.m_188501_() - level.f_46441_.m_188501_());
                    level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11914_, entity.m_5720_(), volume, pitch);
                }
                entity.m_20095_();
            }
        }
    }

    @Override
    public List<TagKey<Block>> getTags() {
        return List.of(BlockTags.f_144282_);
    }

    public static enum Type implements StringRepresentable
    {
        HEAD("head"),
        BOTTOM("bottom");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

