/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.audio;

import com.mrcrayfish.furniture.refurbished.blockentity.ILevelAudio;
import com.mrcrayfish.furniture.refurbished.client.audio.AudioManager;
import java.lang.ref.WeakReference;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class AudioWorldSound
extends AbstractTickableSoundInstance {
    private final WeakReference<ILevelAudio> audioBlockRef;
    private final SoundEvent playingSound;
    private boolean switchSound;
    private boolean cancel;

    public AudioWorldSound(ILevelAudio audio) {
        super(audio.getSound(), audio.getSource(), SoundInstance.m_235150_());
        this.playingSound = audio.getSound();
        this.audioBlockRef = new WeakReference<ILevelAudio>(audio);
        this.f_119573_ = audio.getAudioVolume();
        this.f_119574_ = audio.getAudioPitch();
        this.f_119578_ = true;
        this.f_119579_ = 0;
        Vec3 pos = audio.getAudioPosition();
        this.f_119575_ = pos.f_82479_;
        this.f_119576_ = pos.f_82480_;
        this.f_119577_ = pos.f_82481_;
    }

    public boolean m_7784_() {
        return true;
    }

    public void cancel() {
        this.cancel = true;
    }

    private boolean isOutOfRange() {
        ILevelAudio audio = (ILevelAudio)this.audioBlockRef.get();
        if (audio != null) {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ != null) {
                Vec3 pos = audio.getAudioPosition();
                Vec3 eye = mc.f_91074_.m_146892_();
                return eye.m_82557_(pos) > audio.getAudioRadiusSqr();
            }
        }
        return true;
    }

    public void m_7788_() {
        ILevelAudio audio = (ILevelAudio)this.audioBlockRef.get();
        if (audio == null || !audio.canPlayAudio() || this.isOutOfRange() || this.cancel) {
            this.m_119609_();
            return;
        }
        SoundEvent currentSound = audio.getSound();
        if (this.playingSound != currentSound && !this.switchSound) {
            if (currentSound != null) {
                AudioWorldSound sound = new AudioWorldSound(audio);
                Minecraft.m_91087_().m_91106_().m_120372_((TickableSoundInstance)sound);
                AudioManager.get().updateSound(audio, sound);
            }
            this.switchSound = true;
        }
        this.f_119574_ = audio.getAudioPitch();
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null && !this.switchSound) {
            double distanceSquared = mc.f_91074_.m_146892_().m_82531_(this.f_119575_, this.f_119576_, this.f_119577_);
            if (distanceSquared > audio.getAudioRadiusSqr()) {
                this.m_119609_();
                return;
            }
            this.f_119573_ = 1.0f - (float)Mth.m_14008_((double)(distanceSquared / audio.getAudioRadiusSqr()), (double)0.0, (double)1.0);
            this.f_119573_ *= audio.getAudioVolume();
        } else {
            this.m_119609_();
        }
        Vec3 pos = audio.getAudioPosition();
        this.f_119575_ = pos.f_82479_;
        this.f_119576_ = pos.f_82480_;
        this.f_119577_ = pos.f_82481_;
    }
}

