/*
 * Decompiled with CFR 0.152.
 */
package reliquary.blocks;

import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import reliquary.blocks.tile.ApothecaryMortarBlockEntity;
import reliquary.init.ModItems;
import reliquary.items.ICreativeTabItemGenerator;
import reliquary.reference.Settings;
import reliquary.util.InventoryHelper;
import reliquary.util.WorldHelper;

public class ApothecaryMortarBlock
extends Block
implements EntityBlock,
ICreativeTabItemGenerator {
    public static final DirectionProperty FACING = DirectionProperty.m_61546_((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);
    private static final VoxelShape MORTAR_SHAPE = Stream.of(Block.m_49796_((double)6.0, (double)1.5, (double)6.0, (double)10.0, (double)2.5, (double)10.0), Block.m_49796_((double)5.0, (double)2.5, (double)5.0, (double)11.0, (double)3.5, (double)11.0), Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)1.5, (double)11.0), Block.m_49796_((double)4.0, (double)3.5, (double)5.0, (double)5.0, (double)6.5, (double)11.0), Block.m_49796_((double)11.0, (double)3.5, (double)5.0, (double)12.0, (double)6.5, (double)11.0), Block.m_49796_((double)5.0, (double)3.5, (double)11.0, (double)11.0, (double)6.5, (double)12.0), Block.m_49796_((double)5.0, (double)3.5, (double)4.0, (double)11.0, (double)6.5, (double)5.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();

    public ApothecaryMortarBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60913_(1.5f, 2.0f));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    @Override
    public void addCreativeTabItems(Consumer<ItemStack> itemConsumer) {
        if (Boolean.TRUE.equals(Settings.COMMON.disable.disablePotions.get())) {
            return;
        }
        itemConsumer.accept(new ItemStack((ItemLike)this));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return MORTAR_SHAPE;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ApothecaryMortarBlockEntity(pos, state);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldItem = player.m_21120_(hand);
        BlockEntity tileEntity = level.m_7702_(pos);
        if (!(tileEntity instanceof ApothecaryMortarBlockEntity)) {
            return InteractionResult.FAIL;
        }
        ApothecaryMortarBlockEntity mortar = (ApothecaryMortarBlockEntity)tileEntity;
        if (heldItem.m_41619_()) {
            if (player.m_6047_()) {
                InventoryHelper.getItemHandlerFrom(mortar).ifPresent(itemHandler -> InventoryHelper.tryRemovingLastStack(itemHandler, level, mortar.m_58899_()));
                return InteractionResult.SUCCESS;
            }
            boolean done = mortar.usePestle(level);
            level.m_5594_(null, pos, this.f_60446_.m_56776_(), SoundSource.BLOCKS, (this.f_60446_.m_56773_() + 1.0f) / 2.0f, this.f_60446_.m_56774_() * 0.8f);
            player.m_6674_(hand);
            return done ? InteractionResult.SUCCESS : InteractionResult.CONSUME;
        }
        if (mortar.isInCooldown(level) && heldItem.m_41720_() == ModItems.POTION_ESSENCE.get()) {
            return InteractionResult.CONSUME;
        }
        ItemStack stackToAdd = heldItem.m_41777_();
        stackToAdd.m_41764_(1);
        boolean putItemInSlot = InventoryHelper.getItemHandlerFrom(mortar).map(itemHandler -> {
            if (InventoryHelper.insertIntoInventory(stackToAdd, itemHandler) == 1) {
                heldItem.m_41774_(1);
                return true;
            }
            return false;
        }).orElse(false);
        if (!putItemInSlot) {
            mortar.usePestle(level);
            level.m_5594_(null, pos, this.f_60446_.m_56776_(), SoundSource.BLOCKS, (this.f_60446_.m_56773_() + 1.0f) / 2.0f, this.f_60446_.m_56774_() * 0.8f);
            return InteractionResult.CONSUME;
        }
        mortar.m_6596_();
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        if (context.m_43723_() == null) {
            return this.m_49966_();
        }
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_43723_().m_6350_());
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        WorldHelper.getBlockEntity((BlockGetter)level, pos, ApothecaryMortarBlockEntity.class).ifPresent(mortar -> mortar.dropItems(level));
        super.m_6810_(state, level, pos, newState, isMoving);
    }
}

