/*
 * Decompiled with CFR 0.152.
 */
package reliquary.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import reliquary.crafting.AlkahestryRecipeRegistry;
import reliquary.init.ModItems;
import reliquary.items.AlkahestryTomeItem;

public class AlkahestryCraftingRecipe
implements CraftingRecipe {
    private final Ingredient craftingIngredient;
    private final int chargeNeeded;
    private final int resultCount;
    private ItemStack result = ItemStack.f_41583_;
    private final ResourceLocation id;
    private final Ingredient tomeIngredient;

    private AlkahestryCraftingRecipe(ResourceLocation id, Ingredient craftingIngredient, int chargeNeeded, int resultCount) {
        this.id = id;
        this.craftingIngredient = craftingIngredient;
        this.chargeNeeded = chargeNeeded;
        this.tomeIngredient = new TomeIngredient(chargeNeeded);
        this.resultCount = resultCount;
        AlkahestryRecipeRegistry.registerCraftingRecipe(this);
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        boolean hasIngredient = false;
        boolean hasTome = false;
        for (int x = 0; x < inv.m_6643_(); ++x) {
            ItemStack slotStack = inv.m_8020_(x);
            if (slotStack.m_41619_()) continue;
            boolean inRecipe = false;
            if (this.craftingIngredient.test(slotStack)) {
                inRecipe = true;
                hasIngredient = true;
            } else if (!hasTome && this.tomeIngredient.test(slotStack)) {
                inRecipe = true;
                hasTome = true;
            }
            if (inRecipe) continue;
            return false;
        }
        return hasIngredient && hasTome;
    }

    public NonNullList<Ingredient> m_7527_() {
        return NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{this.craftingIngredient, this.tomeIngredient});
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess registryAccess) {
        for (int slot = 0; slot < inv.m_6643_(); ++slot) {
            ItemStack stack = inv.m_8020_(slot);
            if (stack.m_41619_() || stack.m_41720_() == ModItems.ALKAHESTRY_TOME.get()) continue;
            ItemStack craftingResult = stack.m_41777_();
            craftingResult.m_41764_(this.resultCount);
            return craftingResult;
        }
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public ItemStack getResult() {
        ItemStack[] ingredientItems;
        if (this.result.m_41619_() && (ingredientItems = this.craftingIngredient.m_43908_()).length > 0) {
            this.result = ingredientItems[0].m_41777_();
            this.result.m_41764_(this.resultCount);
        }
        return this.result;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.getResult();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModItems.ALKAHESTRY_CRAFTING_SERIALIZER.get();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList remainingItems = super.m_7457_((Container)inv);
        this.addTomeWithUsedCharge((NonNullList<ItemStack>)remainingItems, inv);
        return remainingItems;
    }

    private void addTomeWithUsedCharge(NonNullList<ItemStack> remainingItems, CraftingContainer inv) {
        for (int slot = 0; slot < remainingItems.size(); ++slot) {
            ItemStack stack = inv.m_8020_(slot);
            if (stack.m_41720_() != ModItems.ALKAHESTRY_TOME.get()) continue;
            ItemStack tome = stack.m_41777_();
            AlkahestryTomeItem.useCharge(tome, this.chargeNeeded);
            remainingItems.set(slot, (Object)tome);
            break;
        }
    }

    public boolean m_5598_() {
        return true;
    }

    public int getChargeNeeded() {
        return this.chargeNeeded;
    }

    public CraftingBookCategory m_245232_() {
        return CraftingBookCategory.MISC;
    }

    private static class TomeIngredient
    extends Ingredient {
        private final int chargeNeeded;

        private TomeIngredient(int chargeNeeded) {
            super(Stream.of(new Ingredient.ItemValue(AlkahestryTomeItem.setCharge(new ItemStack((ItemLike)ModItems.ALKAHESTRY_TOME.get()), chargeNeeded))));
            this.chargeNeeded = chargeNeeded;
        }

        public boolean test(@Nullable ItemStack stack) {
            return stack != null && stack.m_150930_((Item)ModItems.ALKAHESTRY_TOME.get()) && AlkahestryTomeItem.getCharge(stack) >= this.chargeNeeded;
        }
    }

    public static class Serializer
    implements RecipeSerializer<AlkahestryCraftingRecipe> {
        public AlkahestryCraftingRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            if (!json.has("ingredient")) {
                throw new JsonParseException("No ingredient for alkahestry crafting recipe");
            }
            Ingredient ingredient = CraftingHelper.getIngredient((JsonElement)json.get("ingredient"), (boolean)false);
            int resultCount = GsonHelper.m_13927_((JsonObject)json, (String)"result_count");
            int chargeNeeded = GsonHelper.m_13927_((JsonObject)json, (String)"charge");
            return new AlkahestryCraftingRecipe(recipeId, ingredient, chargeNeeded, resultCount);
        }

        @Nullable
        public AlkahestryCraftingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            return new AlkahestryCraftingRecipe(recipeId, Ingredient.m_43940_((FriendlyByteBuf)buffer), buffer.readInt(), buffer.readInt());
        }

        public void toNetwork(FriendlyByteBuf buffer, AlkahestryCraftingRecipe recipe) {
            recipe.craftingIngredient.m_43923_(buffer);
            buffer.writeInt(recipe.chargeNeeded);
            buffer.writeInt(recipe.resultCount);
        }
    }
}

