/*
 * Decompiled with CFR 0.152.
 */
package reliquary.items;

import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import reliquary.entities.XRTippedArrowEntity;
import reliquary.items.ICreativeTabItemGenerator;
import reliquary.items.util.IPotionItem;
import reliquary.reference.Settings;
import reliquary.util.TooltipBuilder;
import reliquary.util.potions.PotionEssence;
import reliquary.util.potions.PotionMap;
import reliquary.util.potions.XRPotionHelper;

public class TippedArrowItem
extends ArrowItem
implements IPotionItem,
ICreativeTabItemGenerator {
    public TippedArrowItem() {
        super(new Item.Properties());
    }

    public AbstractArrow m_6394_(Level world, ItemStack stack, LivingEntity shooter) {
        XRTippedArrowEntity entitytippedarrow = new XRTippedArrowEntity(world, shooter);
        entitytippedarrow.setPotionEffect(stack);
        return entitytippedarrow;
    }

    @Override
    public void addCreativeTabItems(Consumer<ItemStack> itemConsumer) {
        if (Boolean.TRUE.equals(Settings.COMMON.disable.disablePotions.get())) {
            return;
        }
        for (PotionEssence essence : PotionMap.uniquePotionEssences) {
            ItemStack tippedArrow = new ItemStack((ItemLike)this);
            XRPotionHelper.addPotionEffectsToStack(tippedArrow, XRPotionHelper.changePotionEffectsDuration(essence.getEffects(), 0.125f));
            itemConsumer.accept(tippedArrow);
        }
    }

    public void m_7373_(ItemStack arrow, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        TooltipBuilder.of(tooltip).potionEffects(arrow);
    }

    @Override
    public List<MobEffectInstance> getEffects(ItemStack stack) {
        return XRPotionHelper.getPotionEffectsFromStack(stack);
    }
}

