/*
 * Decompiled with CFR 0.152.
 */
package reliquary.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import reliquary.api.client.IPedestalItemRenderer;
import reliquary.block.tile.PedestalBlockEntity;

public class PedestalFishHookRenderer
implements IPedestalItemRenderer {
    private static final ResourceLocation FISH_PARTICLES = new ResourceLocation("textures/entity/fishing_hook.png");
    private static final RenderType ENTITY_CUTOUT = RenderType.m_110452_((ResourceLocation)FISH_PARTICLES);

    @Override
    public void doRender(PedestalBlockEntity te, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        ((Optional)te.getItemData()).ifPresent(itemData -> this.renderHook(te, matrixStack, buffer, packedLight, itemData));
    }

    private void renderHook(PedestalBlockEntity te, PoseStack matrixStack, MultiBufferSource buffer, int packedLight, Object itemData) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || !(itemData instanceof HookRenderingData)) {
            return;
        }
        HookRenderingData hookData = (HookRenderingData)itemData;
        double translateX = hookData.hookX - (double)te.m_58899_().m_123341_();
        double translateY = hookData.hookY - (double)te.m_58899_().m_123342_();
        double translateZ = hookData.hookZ - (double)te.m_58899_().m_123343_();
        matrixStack.m_85836_();
        matrixStack.m_85837_(translateX, translateY, translateZ);
        matrixStack.m_85836_();
        matrixStack.m_85841_(0.5f, 0.5f, 0.5f);
        matrixStack.m_252781_(Axis.f_252392_.m_252977_(player.f_20885_ + 180.0f));
        PoseStack.Pose matrixStackEntry = matrixStack.m_85850_();
        Matrix4f matrix = matrixStackEntry.m_252922_();
        Matrix3f normal = matrixStackEntry.m_252943_();
        VertexConsumer vertexBuilder = buffer.m_6299_(ENTITY_CUTOUT);
        PedestalFishHookRenderer.addVertex(vertexBuilder, matrix, normal, packedLight, 0.0f, 0, 0, 1);
        PedestalFishHookRenderer.addVertex(vertexBuilder, matrix, normal, packedLight, 1.0f, 0, 1, 1);
        PedestalFishHookRenderer.addVertex(vertexBuilder, matrix, normal, packedLight, 1.0f, 1, 1, 0);
        PedestalFishHookRenderer.addVertex(vertexBuilder, matrix, normal, packedLight, 0.0f, 1, 0, 0);
        matrixStack.m_85849_();
        double pedestalX = (double)te.m_58899_().m_123341_() + 0.5;
        double pedestalY = (double)te.m_58899_().m_123342_() + 0.45;
        double pedestalZ = (double)te.m_58899_().m_123343_() + 0.5;
        double hookX = hookData.hookX;
        double hookY = hookData.hookY;
        double hookZ = hookData.hookZ;
        float xDiff = (float)(pedestalX - hookX);
        float yDiff = (float)(pedestalY - hookY);
        float zDiff = (float)(pedestalZ - hookZ);
        VertexConsumer vertextConsumer2 = buffer.m_6299_(RenderType.m_173247_());
        PoseStack.Pose pose = matrixStack.m_85850_();
        for (int k = 0; k < 16; ++k) {
            PedestalFishHookRenderer.stringVertex(xDiff, yDiff, zDiff, vertextConsumer2, pose, (float)k / 16.0f, (float)(k + 1) / 16.0f);
        }
        matrixStack.m_85849_();
    }

    private static void addVertex(VertexConsumer vertexBuilder, Matrix4f matrix, Matrix3f normal, int packedLight, float x, int y, int u, int v) {
        vertexBuilder.m_252986_(matrix, x - 0.5f, (float)y - 0.5f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_((float)u, (float)v).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    private static void stringVertex(float xDiff, float yDiff, float zDiff, VertexConsumer vertexConsumer, PoseStack.Pose pose, float scale1, float scale2) {
        float x = xDiff * scale1;
        float y = yDiff * (scale1 * scale1 + scale1) * 0.5f + 0.25f;
        float z = zDiff * scale1;
        float normalX = xDiff * scale2 - x;
        float normalY = yDiff * (scale2 * scale2 + scale2) * 0.5f + 0.25f - y;
        float normalZ = zDiff * scale2 - z;
        float f6 = Mth.m_14116_((float)(normalX * normalX + normalY * normalY + normalZ * normalZ));
        vertexConsumer.m_252986_(pose.m_252922_(), x, y, z).m_6122_(0, 0, 0, 255).m_252939_(pose.m_252943_(), normalX /= f6, normalY /= f6, normalZ /= f6).m_5752_();
    }

    public static class HookRenderingData {
        final double hookX;
        final double hookY;
        final double hookZ;

        public HookRenderingData(double hookX, double hookY, double hookZ) {
            this.hookX = hookX;
            this.hookY = hookY;
            this.hookZ = hookZ;
        }
    }
}

