/*
 * Decompiled with CFR 0.152.
 */
package reliquary.data;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemKilledByPlayerCondition;
import reliquary.data.RandomChanceLootingSeveringCondition;
import reliquary.init.ModItems;

public class EntityLootInjectSubProvider
implements LootTableSubProvider {
    private static final String INJECT_FOLDER = "inject/";
    protected static final Map<ResourceLocation, ResourceLocation> LOOT_INJECTS = new HashMap<ResourceLocation, ResourceLocation>();
    public static final ResourceLocation BAT = EntityLootInjectSubProvider.registerLootInject(EntityType.f_20549_.m_20677_());
    public static final ResourceLocation BLAZE = EntityLootInjectSubProvider.registerLootInject(EntityType.f_20551_.m_20677_());
    public static final ResourceLocation CAVE_SPIDER = EntityLootInjectSubProvider.registerLootInject(EntityType.f_20554_.m_20677_());
    public static final ResourceLocation CREEPER = EntityLootInjectSubProvider.registerLootInject(EntityType.f_20558_.m_20677_());
    public static final ResourceLocation ENDERMAN = EntityLootInjectSubProvider.registerLootInject(EntityType.f_20566_.m_20677_());
    public static final ResourceLocation GHAST = EntityLootInjectSubProvider.registerLootInject(EntityType.f_20453_.m_20677_());
    public static final ResourceLocation GUARDIAN = EntityLootInjectSubProvider.registerLootInject(EntityType.f_20455_.m_20677_());
    public static final ResourceLocation HUSK = EntityLootInjectSubProvider.registerLootInject(EntityType.f_20458_.m_20677_());
    public static final ResourceLocation MAGMA_CUBE = EntityLootInjectSubProvider.registerLootInject(EntityType.f_20468_.m_20677_());
    public static final ResourceLocation SKELETON = EntityLootInjectSubProvider.registerLootInject(EntityType.f_20524_.m_20677_());
    public static final ResourceLocation SNOW_GOLEM = EntityLootInjectSubProvider.registerLootInject(EntityType.f_20528_.m_20677_());
    public static final ResourceLocation SLIME = EntityLootInjectSubProvider.registerLootInject(EntityType.f_20526_.m_20677_());
    public static final ResourceLocation SPIDER = EntityLootInjectSubProvider.registerLootInject(EntityType.f_20479_.m_20677_());
    public static final ResourceLocation SQUID = EntityLootInjectSubProvider.registerLootInject(EntityType.f_20480_.m_20677_());
    public static final ResourceLocation STRAY = EntityLootInjectSubProvider.registerLootInject(EntityType.f_20481_.m_20677_());
    public static final ResourceLocation WITCH = EntityLootInjectSubProvider.registerLootInject(EntityType.f_20495_.m_20677_());
    public static final ResourceLocation WITHER_SKELETON = EntityLootInjectSubProvider.registerLootInject(EntityType.f_20497_.m_20677_());
    public static final ResourceLocation ZOMBIE = EntityLootInjectSubProvider.registerLootInject(EntityType.f_20501_.m_20677_());
    public static final ResourceLocation ZOMBIE_VILLAGER = EntityLootInjectSubProvider.registerLootInject(EntityType.f_20530_.m_20677_());
    public static final ResourceLocation ZOMBIFIED_PIGLIN = EntityLootInjectSubProvider.registerLootInject(EntityType.f_20531_.m_20677_());

    private static ResourceLocation registerLootInject(ResourceLocation vanillaLootTable) {
        return LOOT_INJECTS.computeIfAbsent(vanillaLootTable, k -> new ResourceLocation("reliquary", INJECT_FOLDER + vanillaLootTable.m_135815_()));
    }

    public void m_245126_(BiConsumer<ResourceLocation, LootTable.Builder> tables) {
        tables.accept(BAT, EntityLootInjectSubProvider.getEntityLootTable(0.02f, 0.03f, 0.1f, this.getItemLootEntry((Item)ModItems.BAT_WING.get(), 1)));
        tables.accept(BLAZE, EntityLootInjectSubProvider.getEntityLootTable(0.03f, 0.04f, 0.12f, this.getItemLootEntry((Item)ModItems.MOLTEN_CORE.get(), 1)));
        tables.accept(CAVE_SPIDER, EntityLootInjectSubProvider.getEntityLootTable(0.03f, 0.04f, 0.12f, this.getItemLootEntry((Item)ModItems.CHELICERAE.get(), 1)));
        CompoundTag poweredTag = new CompoundTag();
        poweredTag.m_128379_("powered", true);
        tables.accept(CREEPER, EntityLootInjectSubProvider.getEntityLootTable(0.02f, 0.03f, 0.1f, this.getItemLootEntry((Item)ModItems.CATALYZING_GLAND.get(), 1)).m_79161_(LootPool.m_79043_().name("powered_creeper").m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.EYE_OF_THE_STORM.get()))).m_79080_(LootItemKilledByPlayerCondition.m_81901_()).m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)new EntityPredicate.Builder().m_36654_(new NbtPredicate(poweredTag)))).m_79080_(RandomChanceLootingSeveringCondition.randomChanceLootingSevering(0.03f, 0.05f, 0.15f))));
        tables.accept(ENDERMAN, EntityLootInjectSubProvider.getEntityLootTable(0.02f, 0.03f, 0.1f, this.getItemLootEntry((Item)ModItems.NEBULOUS_HEART.get(), 1)));
        tables.accept(GHAST, EntityLootInjectSubProvider.getEntityLootTable(0.03f, 0.04f, 0.12f, this.getItemLootEntry((Item)ModItems.CATALYZING_GLAND.get(), 1)));
        tables.accept(GUARDIAN, EntityLootInjectSubProvider.getEntityLootTable(0.02f, 0.03f, 0.1f, this.getItemLootEntry((Item)ModItems.GUARDIAN_SPIKE.get(), 1)));
        tables.accept(HUSK, EntityLootInjectSubProvider.getEntityLootTable(0.02f, 0.03f, 0.1f, this.getItemLootEntry((Item)ModItems.ZOMBIE_HEART.get(), 1)));
        tables.accept(MAGMA_CUBE, EntityLootInjectSubProvider.getEntityLootTable(0.02f, 0.03f, 0.1f, this.getItemLootEntry((Item)ModItems.MOLTEN_CORE.get(), 1)));
        tables.accept(SKELETON, EntityLootInjectSubProvider.getEntityLootTable(0.02f, 0.03f, 0.1f, this.getItemLootEntry((Item)ModItems.RIB_BONE.get(), 1)));
        tables.accept(SLIME, EntityLootInjectSubProvider.getEntityLootTable(0.02f, 0.03f, 0.1f, this.getItemLootEntry((Item)ModItems.SLIME_PEARL.get(), 1)));
        tables.accept(SNOW_GOLEM, EntityLootInjectSubProvider.getEntityLootTable(0.02f, 0.03f, 0.1f, this.getItemLootEntry((Item)ModItems.FROZEN_CORE.get(), 1)));
        tables.accept(SPIDER, EntityLootInjectSubProvider.getEntityLootTable(0.02f, 0.03f, 0.1f, this.getItemLootEntry((Item)ModItems.CHELICERAE.get(), 1)));
        tables.accept(SQUID, EntityLootInjectSubProvider.getEntityLootTable(0.02f, 0.03f, 0.1f, this.getItemLootEntry((Item)ModItems.SQUID_BEAK.get(), 1)));
        tables.accept(STRAY, EntityLootInjectSubProvider.getEntityLootTable(0.02f, 0.03f, 0.1f, this.getItemLootEntry((Item)ModItems.RIB_BONE.get(), 1)));
        tables.accept(WITCH, EntityLootInjectSubProvider.getEntityLootTable(0.02f, 0.03f, 0.1f, this.getItemLootEntry((Item)ModItems.WITCH_HAT.get(), 1)));
        tables.accept(WITHER_SKELETON, EntityLootInjectSubProvider.getEntityLootTable(0.02f, 0.03f, 0.1f, this.getItemLootEntry((Item)ModItems.WITHERED_RIB.get(), 1)));
        tables.accept(ZOMBIE, EntityLootInjectSubProvider.getEntityLootTable(0.02f, 0.03f, 0.1f, this.getItemLootEntry((Item)ModItems.ZOMBIE_HEART.get(), 1)));
        tables.accept(ZOMBIE_VILLAGER, EntityLootInjectSubProvider.getEntityLootTable(0.02f, 0.03f, 0.1f, this.getItemLootEntry((Item)ModItems.ZOMBIE_HEART.get(), 1)));
        tables.accept(ZOMBIFIED_PIGLIN, EntityLootInjectSubProvider.getEntityLootTable(0.03f, 0.04f, 0.12f, this.getItemLootEntry((Item)ModItems.ZOMBIE_HEART.get(), 1)));
    }

    private LootPoolEntryContainer.Builder<?> getItemLootEntry(Item item, int weight) {
        return LootItem.m_79579_((ItemLike)item).m_79707_(weight);
    }

    private static LootTable.Builder getEntityLootTable(float baseChance, float lootingMultiplier, float severingMultiplier, LootPoolEntryContainer.Builder<?> ... entries) {
        LootPool.Builder pool = LootPool.m_79043_().name("main");
        for (LootPoolEntryContainer.Builder<?> entry : entries) {
            pool.m_79076_(entry);
        }
        pool.m_79080_(LootItemKilledByPlayerCondition.m_81901_());
        pool.m_79080_(RandomChanceLootingSeveringCondition.randomChanceLootingSevering(baseChance, lootingMultiplier, severingMultiplier));
        return LootTable.m_79147_().m_79161_(pool);
    }
}

