/*
 * Decompiled with CFR 0.152.
 */
package reliquary.entity;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.network.NetworkHooks;
import reliquary.init.ModEntities;
import reliquary.init.ModItems;
import reliquary.reference.Settings;
import reliquary.util.LogHelper;

public class LyssaHook
extends FishingHook
implements IEntityAdditionalSpawnData {
    private static final Field HANDS_CHANCES = ObfuscationReflectionHelper.findField(Mob.class, (String)"f_21347_");
    private static final Field ARMOR_CHANCES = ObfuscationReflectionHelper.findField(Mob.class, (String)"f_21348_");

    public LyssaHook(EntityType<LyssaHook> entityType, Level world) {
        this(entityType, world, 0, 0);
    }

    private LyssaHook(EntityType<LyssaHook> entityType, Level level, int luck, int lureSpeed) {
        super(entityType, level, luck, lureSpeed);
    }

    public LyssaHook(Level world, Player fishingPlayer, int lureSpeed, int luck) {
        this((EntityType<LyssaHook>)((EntityType)ModEntities.LYSSA_HOOK.get()), world, luck, lureSpeed);
        this.m_5602_((Entity)fishingPlayer);
        this.shoot(fishingPlayer);
        this.speedUp();
    }

    private void shoot(Player fishingPlayer) {
        float f = fishingPlayer.m_146909_();
        float f1 = fishingPlayer.m_146908_();
        float f2 = Mth.m_14089_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.m_14031_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.m_14089_((float)(-f * ((float)Math.PI / 180)));
        float f5 = Mth.m_14031_((float)(-f * ((float)Math.PI / 180)));
        double d0 = fishingPlayer.m_20185_() - (double)f3 * 0.3;
        double d1 = fishingPlayer.m_20188_();
        double d2 = fishingPlayer.m_20189_() - (double)f2 * 0.3;
        this.m_7678_(d0, d1, d2, f1, f);
        Vec3 vec3 = new Vec3((double)(-f3), (double)Mth.m_14036_((float)(-(f5 / f4)), (float)-5.0f, (float)5.0f), (double)(-f2));
        double d3 = vec3.m_82553_();
        vec3 = vec3.m_82542_(0.6 / d3 + 0.5 + this.f_19796_.m_188583_() * 0.0045, 0.6 / d3 + 0.5 + this.f_19796_.m_188583_() * 0.0045, 0.6 / d3 + 0.5 + this.f_19796_.m_188583_() * 0.0045);
        this.m_20256_(vec3);
        this.m_146922_((float)(Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 57.2957763671875));
        this.m_146926_((float)(Mth.m_14136_((double)vec3.f_82480_, (double)vec3.m_165924_()) * 57.2957763671875));
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6783_(double distance) {
        return distance < 16384.0;
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeInt(this.getFishingPlayerOptional().map(Entity::m_19879_).orElse(0).intValue());
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        int entityId = additionalData.readInt();
        if (entityId != 0) {
            this.m_5602_(this.m_9236_().m_6815_(entityId));
        }
    }

    public Optional<Player> getFishingPlayerOptional() {
        Player player;
        Entity entity = this.m_19749_();
        return Optional.ofNullable(entity instanceof Player ? (player = (Player)entity) : null);
    }

    private void speedUp() {
        if (this.m_20184_().m_7098_() >= 0.0) {
            this.m_20256_(this.m_20184_().m_82542_(2.0, 2.0, 2.0));
        }
    }

    public void m_8119_() {
        super.m_8119_();
        this.pullItemEntitiesTowardsHook();
    }

    protected boolean m_37136_(Player fishingPlayer) {
        boolean flag1;
        ItemStack itemstack = fishingPlayer.m_21205_();
        ItemStack itemstack1 = fishingPlayer.m_21206_();
        boolean flag = itemstack.m_41720_() == ModItems.ROD_OF_LYSSA.get();
        boolean bl = flag1 = itemstack1.m_41720_() == ModItems.ROD_OF_LYSSA.get();
        if (fishingPlayer.m_6084_() && (flag || flag1) && this.m_20280_((Entity)fishingPlayer) <= 10240.0) {
            return false;
        }
        this.m_146870_();
        return true;
    }

    private void pullItemEntitiesTowardsHook() {
        if (this.m_6084_() && this.m_37170_() == null) {
            float f = 0.0f;
            BlockPos blockpos = this.m_20183_();
            FluidState fluidState = this.m_9236_().m_6425_(blockpos);
            if (fluidState.m_205070_(FluidTags.f_13131_)) {
                f = fluidState.m_76155_((BlockGetter)this.m_9236_(), blockpos);
            }
            if (f <= 0.0f) {
                List list = this.m_9236_().m_45976_(ItemEntity.class, this.m_20191_().m_82369_(this.m_20184_()).m_82400_(3.0));
                for (ItemEntity e : list) {
                    Vec3 pullVector = new Vec3(this.m_20185_() - e.m_20185_(), this.m_20186_() - e.m_20186_(), this.m_20189_() - e.m_20189_()).m_82541_();
                    e.m_20256_(pullVector.m_82542_(0.4, 0.4, 0.4));
                }
            }
        }
    }

    public void handleHookRetraction(ItemStack stack) {
        if (!this.m_9236_().f_46443_) {
            Entity hookedIn = this.m_37170_();
            if (hookedIn != null && this.getFishingPlayerOptional().map(Entity::m_6047_).orElse(false).booleanValue() && this.canStealFromEntity()) {
                this.stealFromLivingEntity();
                this.m_146870_();
            } else if (!this.m_9236_().f_46443_ && this.getFishingPlayerOptional().isPresent() && hookedIn != null) {
                this.bringInHookedEntity();
                this.m_9236_().m_7605_((Entity)this, (byte)31);
                this.m_146870_();
            } else {
                super.m_37156_(stack);
            }
            this.pullItemEntitiesWithHook();
        }
    }

    private void bringInHookedEntity() {
        Entity hookedIn = this.m_37170_();
        if (hookedIn != null) {
            super.m_150155_(hookedIn);
        }
        if (hookedIn instanceof ItemEntity) {
            hookedIn.m_20256_(hookedIn.m_20184_().m_82542_(4.0, 4.0, 4.0));
        } else if (hookedIn instanceof LivingEntity) {
            hookedIn.m_20256_(hookedIn.m_20184_().m_82542_(1.0, 1.5, 1.0));
        }
    }

    private boolean canStealFromEntity() {
        Entity hookedIn = this.m_37170_();
        return hookedIn instanceof LivingEntity && ((Boolean)Settings.COMMON.items.rodOfLyssa.stealFromPlayers.get() != false || !(hookedIn instanceof Player)) && Settings.COMMON.items.rodOfLyssa.canStealFromEntity(hookedIn);
    }

    private void pullItemEntitiesWithHook() {
        List pullingItemsList = this.m_9236_().m_45976_(ItemEntity.class, this.m_20191_().m_82369_(this.m_20184_()).m_82377_(1.0, 1.0, 1.0));
        this.getFishingPlayerOptional().ifPresent(p -> {
            for (ItemEntity e : pullingItemsList) {
                double d1 = p.m_20185_() - this.m_20185_();
                double d3 = p.m_20186_() - this.m_20186_();
                double d5 = p.m_20189_() - this.m_20189_();
                double d7 = Math.sqrt(d1 * d1 + d3 * d3 + d5 * d5);
                double d9 = 0.1;
                e.m_20334_(d1 * d9, d3 * d9 + Math.sqrt(d7) * 0.08, d5 * d9);
            }
        });
    }

    private void stealFromLivingEntity() {
        Optional<Player> p;
        Entity entity = this.m_37170_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        EquipmentSlot slotBeingStolenFrom = EquipmentSlot.values()[this.m_9236_().f_46441_.m_188503_(EquipmentSlot.values().length)];
        ItemStack stolenStack = livingEntity.m_6844_(slotBeingStolenFrom);
        if (stolenStack.m_41619_() && Boolean.TRUE.equals(Settings.COMMON.items.rodOfLyssa.stealFromVacantSlots.get())) {
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                stolenStack = livingEntity.m_6844_(slot);
                if (stolenStack.m_41619_() || !this.canDropFromSlot(livingEntity, slot)) continue;
                slotBeingStolenFrom = slot;
                break;
            }
        }
        if ((p = this.getFishingPlayerOptional()).isEmpty()) {
            return;
        }
        Player fishingPlayer = p.get();
        float failProbabilityFactor = Boolean.TRUE.equals(Settings.COMMON.items.rodOfLyssa.useLeveledFailureRate.get()) ? 1.0f / ((float)Math.sqrt(Math.max(1, Math.min(fishingPlayer.f_36078_, (Integer)Settings.COMMON.items.rodOfLyssa.levelCapForLeveledFormula.get()))) * 2.0f) : (float)((Integer)Settings.COMMON.items.rodOfLyssa.flatStealFailurePercentRate.get()).intValue() / 100.0f;
        if ((this.f_19796_.m_188501_() <= failProbabilityFactor || stolenStack.m_41619_() && ((Boolean)Settings.COMMON.items.rodOfLyssa.failStealFromVacantSlots.get()).booleanValue()) && Boolean.TRUE.equals(Settings.COMMON.items.rodOfLyssa.angerOnStealFailure.get())) {
            livingEntity.m_6469_(this.m_269291_().m_269075_(fishingPlayer), 0.0f);
        }
        if (!stolenStack.m_41619_()) {
            int randomItemDamage = this.m_9236_().f_46441_.m_188503_(3);
            stolenStack.m_41622_(randomItemDamage, livingEntity, e -> {});
            ItemEntity entityitem = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), stolenStack);
            entityitem.m_32010_(5);
            double d1 = fishingPlayer.m_20185_() - this.m_20185_();
            double d3 = fishingPlayer.m_20186_() - this.m_20186_();
            double d5 = fishingPlayer.m_20189_() - this.m_20189_();
            double d7 = Math.sqrt(d1 * d1 + d3 * d3 + d5 * d5);
            double d9 = 0.1;
            entityitem.m_20334_(d1 * d9, d3 * d9 + Math.sqrt(d7) * 0.08, d5 * d9);
            this.m_9236_().m_7967_((Entity)entityitem);
            livingEntity.m_8061_(slotBeingStolenFrom, ItemStack.f_41583_);
        }
    }

    private boolean canDropFromSlot(LivingEntity entity, EquipmentSlot slot) {
        if (!(entity instanceof Mob)) {
            return true;
        }
        Mob mob = (Mob)entity;
        try {
            if (slot.m_20743_() == EquipmentSlot.Type.HAND) {
                return ((float[])HANDS_CHANCES.get(mob))[slot.m_20749_()] > -1.0f;
            }
            return ((float[])ARMOR_CHANCES.get(mob))[slot.m_20749_()] > -1.0f;
        }
        catch (IllegalAccessException e) {
            LogHelper.error(e);
            return false;
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

