/*
 * Decompiled with CFR 0.152.
 */
package com.phantomwing.rusticdelight.datagen;

import com.phantomwing.rusticdelight.block.ModBlocks;
import com.phantomwing.rusticdelight.block.custom.BellPepperCropBlock;
import com.phantomwing.rusticdelight.block.custom.CoffeeCropBlock;
import com.phantomwing.rusticdelight.block.custom.CottonCropBlock;
import com.phantomwing.rusticdelight.block.custom.PancakeBlock;
import com.phantomwing.rusticdelight.block.custom.RiceRollRoyaleBlock;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import vectorwing.farmersdelight.common.block.PieBlock;

public class ModBlockStateProvider
extends BlockStateProvider {
    private static final int DEFAULT_ANGLE_OFFSET = 180;

    public ModBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "rusticdelight", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.makeCottonCrop((CropBlock)ModBlocks.COTTON_CROP.get(), "cotton_stage", "cotton_stage");
        this.makeBellPepperCrop((CropBlock)ModBlocks.BELL_PEPPER_CROP.get(), "bell_peppers_stage", "bell_peppers_stage");
        this.makeCoffeeCrop((CropBlock)ModBlocks.COFFEE_CROP.get(), "coffee_stage", "coffee_stage");
        this.makeWildCrop((Block)ModBlocks.WILD_COTTON.get());
        this.makeWildCrop((Block)ModBlocks.WILD_BELL_PEPPERS.get());
        this.makeWildCrop((Block)ModBlocks.WILD_COFFEE.get());
        this.makePottedFlower((Block)ModBlocks.POTTED_WILD_COTTON.get(), (Block)ModBlocks.WILD_COTTON.get());
        this.makePottedFlower((Block)ModBlocks.POTTED_WILD_BELL_PEPPERS.get(), (Block)ModBlocks.WILD_BELL_PEPPERS.get());
        this.makePottedFlower((Block)ModBlocks.POTTED_WILD_COFFEE.get(), (Block)ModBlocks.WILD_COFFEE.get());
        this.canvasBag((Block)ModBlocks.COTTON_SEEDS_BAG.get());
        this.canvasBag((Block)ModBlocks.BELL_PEPPER_SEEDS_BAG.get());
        this.canvasBag((Block)ModBlocks.COFFEE_BEANS_BAG.get());
        this.canvasBag((Block)ModBlocks.ROASTED_COFFEE_BEANS_BAG.get());
        this.farmersDelightCrate((Block)ModBlocks.COTTON_BOLL_CRATE.get());
        this.farmersDelightCrate((Block)ModBlocks.BELL_PEPPER_GREEN_CRATE.get());
        this.farmersDelightCrate((Block)ModBlocks.BELL_PEPPER_YELLOW_CRATE.get());
        this.farmersDelightCrate((Block)ModBlocks.BELL_PEPPER_RED_CRATE.get());
        this.pieBlock((Block)ModBlocks.SYRUP_CHEESECAKE.get());
        this.pieBlock((Block)ModBlocks.CHERRY_BLOSSOM_CHEESECAKE.get());
        this.pancakeBlock((Block)ModBlocks.PANCAKES.get());
        this.pancakeBlock((Block)ModBlocks.HONEY_PANCAKES.get());
        this.pancakeBlock((Block)ModBlocks.CHOCOLATE_PANCAKES.get());
        this.pancakeBlock((Block)ModBlocks.CHERRY_BLOSSOM_PANCAKES.get());
        this.pancakeBlock((Block)ModBlocks.VEGETABLE_PANCAKES.get());
        this.pancakeBlock((Block)ModBlocks.PUMPKIN_PANCAKES.get());
        this.riceRollBlock((Block)ModBlocks.RICE_ROLL_ROYALE.get());
    }

    private void makeWildCrop(Block block) {
        this.simpleBlockWithItem(block, (ModelFile)((BlockModelBuilder)this.models().cross(this.blockTexture(block).m_135815_(), this.blockTexture(block))).renderType("cutout"));
    }

    private void makePottedFlower(Block pottedBlock, Block block) {
        this.simpleBlockWithItem(pottedBlock, (ModelFile)((BlockModelBuilder)this.models().singleTexture(this.blockName(pottedBlock), new ResourceLocation("flower_pot_cross"), "plant", this.blockTexture(block))).renderType("cutout"));
    }

    public void makeCottonCrop(CropBlock block, String modelName, String textureName) {
        Function<BlockState, ConfiguredModel[]> function = state -> this.cottonStates((BlockState)state, block, modelName, textureName);
        this.getVariantBuilder((Block)block).forAllStates(function);
    }

    private ConfiguredModel[] cottonStates(BlockState state, CropBlock block, String modelName, String textureName) {
        Integer ageProperty = (Integer)state.m_61143_((Property)((CottonCropBlock)block).m_7959_());
        ConfiguredModel[] models = new ConfiguredModel[]{new ConfiguredModel((ModelFile)((BlockModelBuilder)this.models().crop(modelName + ageProperty, new ResourceLocation("rusticdelight", "block/" + textureName + ageProperty))).renderType("cutout"))};
        return models;
    }

    public void makeBellPepperCrop(CropBlock block, String modelName, String textureName) {
        Function<BlockState, ConfiguredModel[]> function = state -> this.bellPepperStates((BlockState)state, block, modelName, textureName);
        this.getVariantBuilder((Block)block).forAllStates(function);
    }

    private ConfiguredModel[] bellPepperStates(BlockState state, CropBlock block, String modelName, String textureName) {
        Integer ageProperty = (Integer)state.m_61143_((Property)((BellPepperCropBlock)block).m_7959_());
        ConfiguredModel[] models = new ConfiguredModel[]{new ConfiguredModel((ModelFile)((BlockModelBuilder)this.models().cross(modelName + ageProperty, new ResourceLocation("rusticdelight", "block/" + textureName + ageProperty))).renderType("cutout"))};
        return models;
    }

    private void makeCoffeeCrop(CropBlock block, String modelName, String textureName) {
        Function<BlockState, ConfiguredModel[]> function = state -> this.coffeeStates((BlockState)state, block, modelName, textureName);
        this.getVariantBuilder((Block)block).forAllStates(function);
    }

    private ConfiguredModel[] coffeeStates(BlockState state, CropBlock block, String modelName, String textureName) {
        Integer ageProperty = (Integer)state.m_61143_((Property)((CoffeeCropBlock)block).m_7959_());
        ConfiguredModel[] models = new ConfiguredModel[]{new ConfiguredModel((ModelFile)((BlockModelBuilder)this.models().cross(modelName + ageProperty, new ResourceLocation("rusticdelight", "block/" + textureName + ageProperty))).renderType("cutout"))};
        return models;
    }

    private void farmersDelightCrate(Block block) {
        String blockName = this.blockName(block);
        this.simpleBlock(block, (ModelFile)this.models().cubeBottomTop(blockName, this.resourceBlock(blockName + "_side"), this.resourceBlock("crate_bottom"), this.resourceBlock(blockName + "_top")));
    }

    private void canvasBag(Block block) {
        String blockName = this.blockName(block);
        this.simpleBlock(block, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockName, "cube")).texture("particle", this.resourceBlock(blockName + "_top"))).texture("down", this.resourceBlock(blockName + "_bottom"))).texture("up", this.resourceBlock(blockName + "_top"))).texture("north", this.resourceBlock(blockName + "_side_tied"))).texture("south", this.resourceBlock(blockName + "_side_tied"))).texture("east", this.resourceBlock(blockName + "_side"))).texture("west", this.resourceBlock(blockName + "_side")));
    }

    private void pieBlock(Block block) {
        this.getVariantBuilder(block).forAllStates(state -> {
            int bites = (Integer)state.m_61143_((Property)PieBlock.BITES);
            Object suffix = bites == 0 ? "" : "_slice" + bites;
            return ConfiguredModel.builder().modelFile(this.existingModel(this.blockName(block) + (String)suffix)).rotationY(((int)((Direction)state.m_61143_((Property)PieBlock.FACING)).m_122435_() + 180) % 360).build();
        });
    }

    private void riceRollBlock(Block block) {
        this.getVariantBuilder(block).forAllStates(state -> {
            int servings = 8 - (Integer)state.m_61143_((Property)RiceRollRoyaleBlock.ROLL_SERVINGS);
            Object suffix = servings == 8 ? "_leftover" : "_stage" + servings;
            return ConfiguredModel.builder().modelFile(this.existingModel(this.blockName(block) + (String)suffix)).rotationY(((int)((Direction)state.m_61143_((Property)RiceRollRoyaleBlock.FACING)).m_122435_() + 180) % 360).build();
        });
    }

    private void pancakeBlock(Block block) {
        this.getVariantBuilder(block).forAllStates(state -> {
            int bites = (Integer)state.m_61143_((Property)PancakeBlock.SERVINGS);
            String suffix = "_stage" + bites;
            return ConfiguredModel.builder().modelFile(this.existingModel(this.blockName(block) + suffix)).rotationY(((int)((Direction)state.m_61143_((Property)PancakeBlock.FACING)).m_122435_() + 180) % 360).build();
        });
    }

    private String blockName(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
    }

    public ResourceLocation resourceBlock(String path) {
        return new ResourceLocation("rusticdelight", "block/" + path);
    }

    public ModelFile existingModel(String path) {
        return new ModelFile.ExistingModelFile(this.resourceBlock(path), this.models().existingFileHelper);
    }
}

