/*
 * Decompiled with CFR 0.152.
 */
package com.phantomwing.rusticdelight.datagen;

import com.phantomwing.rusticdelight.block.custom.PancakeBlock;
import com.phantomwing.rusticdelight.item.ModItems;
import com.phantomwing.rusticdelight.tags.ForgeTags;
import com.phantomwing.rusticdelight.tags.ModTags;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.CompoundIngredient;
import net.minecraftforge.common.crafting.DifferenceIngredient;
import net.minecraftforge.common.crafting.PartialNBTIngredient;
import net.minecraftforge.common.crafting.conditions.IConditionBuilder;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import vectorwing.farmersdelight.client.recipebook.CookingPotRecipeBookTab;
import vectorwing.farmersdelight.common.tag.ModTags;
import vectorwing.farmersdelight.data.builder.CookingPotRecipeBuilder;
import vectorwing.farmersdelight.data.builder.CuttingBoardRecipeBuilder;

public class ModRecipeProvider
extends RecipeProvider
implements IConditionBuilder {
    public static final float FOOD_COOKING_EXP = 0.35f;

    public ModRecipeProvider(PackOutput output) {
        super(output);
    }

    protected void m_245200_(Consumer<FinishedRecipe> output) {
        this.buildCraftingRecipes(output);
        this.buildCuttingRecipes(output);
        this.buildCookingRecipes(output);
    }

    private void buildCraftingRecipes(@NotNull Consumer<FinishedRecipe> output) {
        ModRecipeProvider.foodCookingRecipes(output, (ItemLike)ModItems.BELL_PEPPER_GREEN.get(), (ItemLike)ModItems.ROASTED_BELL_PEPPER_GREEN.get(), 0.35f);
        ModRecipeProvider.foodCookingRecipes(output, (ItemLike)ModItems.BELL_PEPPER_YELLOW.get(), (ItemLike)ModItems.ROASTED_BELL_PEPPER_YELLOW.get(), 0.35f);
        ModRecipeProvider.foodCookingRecipes(output, (ItemLike)ModItems.BELL_PEPPER_RED.get(), (ItemLike)ModItems.ROASTED_BELL_PEPPER_RED.get(), 0.35f);
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.BELL_PEPPER_SOUP.get()), (int)1).m_126209_((ItemLike)Items.f_42399_).m_206419_(ForgeTags.VEGETABLES_BELL_PEPPER).m_206419_(ForgeTags.VEGETABLES_BELL_PEPPER).m_206419_(ForgeTags.VEGETABLES_BELL_PEPPER).m_206419_(ForgeTags.VEGETABLES_BELL_PEPPER).m_206419_(ForgeTags.VEGETABLES_BELL_PEPPER).m_206419_(ForgeTags.VEGETABLES_BELL_PEPPER).m_126132_(ModRecipeProvider.m_176602_((ItemLike)((ItemLike)ModItems.BELL_PEPPER_RED.get())), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.BELL_PEPPER_RED.get()))).m_126132_(ModRecipeProvider.m_176602_((ItemLike)((ItemLike)ModItems.BELL_PEPPER_GREEN.get())), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.BELL_PEPPER_GREEN.get()))).m_126132_(ModRecipeProvider.m_176602_((ItemLike)((ItemLike)ModItems.BELL_PEPPER_YELLOW.get())), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.BELL_PEPPER_YELLOW.get()))).m_176498_(output);
        ModRecipeProvider.foodCookingRecipes(output, (ItemLike)ModItems.CALAMARI.get(), (ItemLike)ModItems.COOKED_CALAMARI.get(), 0.35f);
        ModRecipeProvider.foodCookingRecipes(output, (ItemLike)ModItems.CALAMARI_SLICE.get(), (ItemLike)ModItems.COOKED_CALAMARI_SLICE.get(), 0.35f);
        ModRecipeProvider.simpleSushiRoll(output, ModItems.BELL_PEPPER_GREEN, ModItems.BELL_PEPPER_ROLL_GREEN);
        ModRecipeProvider.simpleSushiRoll(output, ModItems.BELL_PEPPER_YELLOW, ModItems.BELL_PEPPER_ROLL_YELLOW);
        ModRecipeProvider.simpleSushiRoll(output, ModItems.BELL_PEPPER_RED, ModItems.BELL_PEPPER_ROLL_RED);
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.CALAMARI_ROLL.get()), (int)2).m_206419_(ModTags.Items.CALAMARI_ROLL_INGREDIENTS).m_206419_(ModTags.Items.CALAMARI_ROLL_INGREDIENTS).m_126209_((ItemLike)vectorwing.farmersdelight.common.registry.ModItems.COOKED_RICE.get()).m_126132_(ModRecipeProvider.m_176602_((ItemLike)((ItemLike)ModItems.CALAMARI_SLICE.get())), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.CALAMARI_SLICE.get()))).m_126132_(ModRecipeProvider.m_176602_((ItemLike)((ItemLike)vectorwing.farmersdelight.common.registry.ModItems.COOKED_RICE.get())), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)((ItemLike)vectorwing.farmersdelight.common.registry.ModItems.COOKED_RICE.get()))).m_176498_(output);
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.CHERRY_BLOSSOM_ROLL.get()), (int)2).m_206419_(ModTags.Items.CHERRY_BLOSSOM_INGREDIENTS).m_206419_(ModTags.Items.CHERRY_BLOSSOM_INGREDIENTS).m_126209_((ItemLike)vectorwing.farmersdelight.common.registry.ModItems.COOKED_RICE.get()).m_126132_(ModRecipeProvider.m_176602_((ItemLike)Items.f_271209_), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)Items.f_271209_)).m_126132_(ModRecipeProvider.m_176602_((ItemLike)Items.f_271375_), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)Items.f_271375_)).m_126132_(ModRecipeProvider.m_176602_((ItemLike)Items.f_271517_), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)Items.f_271517_)).m_126132_(ModRecipeProvider.m_176602_((ItemLike)((ItemLike)vectorwing.farmersdelight.common.registry.ModItems.COOKED_RICE.get())), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)((ItemLike)vectorwing.farmersdelight.common.registry.ModItems.COOKED_RICE.get()))).m_176498_(output);
        ModRecipeProvider.foodCookingRecipes(output, (ItemLike)ModItems.POTATO_SLICES.get(), (ItemLike)ModItems.BAKED_POTATO_SLICES.get(), 0.35f);
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.POTATO_SALAD.get()), (int)1).m_126209_((ItemLike)Items.f_42399_).m_206419_(ForgeTags.VEGETABLES_POTATO).m_206419_(ForgeTags.VEGETABLES_ONION).m_206419_(ForgeTags.MILK).m_206419_(Tags.Items.EGGS).m_126132_(ModRecipeProvider.m_176602_((ItemLike)Items.f_42620_), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)Items.f_42620_)).m_126132_(ModRecipeProvider.m_176602_((ItemLike)((ItemLike)ModItems.POTATO_SLICES.get())), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.POTATO_SLICES.get()))).m_176498_(output);
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.SWEET_SALAD.get()), (int)1).m_126209_((ItemLike)Items.f_42399_).m_206419_(ModTags.Items.SWEET_LIQUIDS).m_206419_(ForgeTags.SALAD_INGREDIENTS).m_206419_(ForgeTags.VEGETABLES).m_206419_(ForgeTags.BERRIES).m_206419_(ForgeTags.BERRIES).m_126132_(ModRecipeProvider.m_176602_((ItemLike)Items.f_42787_), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)Items.f_42787_)).m_126132_(ModRecipeProvider.m_176602_((ItemLike)((ItemLike)ModItems.SYRUP.get())), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.SYRUP.get()))).m_176498_(output);
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.CHERRY_BLOSSOM_COOKIE.get()), (int)8).m_126209_((ItemLike)Items.f_42405_).m_126209_((ItemLike)Items.f_42405_).m_206419_(ModTags.Items.CHERRY_BLOSSOM_INGREDIENTS).m_126132_(ModRecipeProvider.m_176602_((ItemLike)Items.f_271209_), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)Items.f_271209_)).m_126132_(ModRecipeProvider.m_176602_((ItemLike)Items.f_271375_), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)Items.f_271375_)).m_126132_(ModRecipeProvider.m_176602_((ItemLike)Items.f_271517_), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)Items.f_271517_)).m_176498_(output);
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.COFFEE_COOKIE.get()), (int)8).m_206419_(ModTags.Items.COFFEE_INGREDIENTS).m_126209_((ItemLike)Items.f_42405_).m_126209_((ItemLike)Items.f_42405_).m_126132_(ModRecipeProvider.m_176602_((ItemLike)((ItemLike)ModItems.ROASTED_COFFEE_BEANS.get())), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.ROASTED_COFFEE_BEANS.get()))).m_176498_(output);
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.SYRUP_COOKIE.get()), (int)8).m_206419_(ModTags.Items.SYRUP).m_126209_((ItemLike)Items.f_42405_).m_126209_((ItemLike)Items.f_42405_).m_126132_(ModRecipeProvider.m_176602_((ItemLike)((ItemLike)ModItems.SYRUP.get())), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.SYRUP.get()))).m_176498_(output);
        ModRecipeProvider.pieRecipes(output, ModItems.SYRUP_CHEESECAKE, ModItems.SYRUP_CHEESECAKE_SLICE, Ingredient.m_204132_(ModTags.Items.SYRUP));
        ModRecipeProvider.pieRecipes(output, ModItems.CHERRY_BLOSSOM_CHEESECAKE, ModItems.CHERRY_BLOSSOM_CHEESECAKE_SLICE, Ingredient.m_204132_(ModTags.Items.CHERRY_BLOSSOM_INGREDIENTS));
        ModRecipeProvider.pancakeRecipes(output, ModItems.PANCAKES, ModItems.PANCAKE, Ingredient.m_204132_(ModTags.Items.SYRUP), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42501_}));
        ModRecipeProvider.pancakeRecipes(output, ModItems.HONEY_PANCAKES, ModItems.HONEY_PANCAKE, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42787_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42780_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42501_}));
        ModRecipeProvider.pancakeRecipes(output, ModItems.CHOCOLATE_PANCAKES, ModItems.CHOCOLATE_PANCAKE, Ingredient.m_204132_(ForgeTags.MILK), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42533_}));
        ModRecipeProvider.pancakeRecipes(output, ModItems.VEGETABLE_PANCAKES, ModItems.VEGETABLE_PANCAKE, Ingredient.m_204132_(ForgeTags.MILK), Ingredient.m_204132_(ForgeTags.VEGETABLES), Ingredient.m_204132_(ForgeTags.SALAD_INGREDIENTS));
        ModRecipeProvider.pancakeRecipes(output, ModItems.CHERRY_BLOSSOM_PANCAKES, ModItems.CHERRY_BLOSSOM_PANCAKE, Ingredient.m_204132_(ForgeTags.MILK), Ingredient.m_204132_(ModTags.Items.CHERRY_BLOSSOM_INGREDIENTS));
        ModRecipeProvider.pancakeRecipes(output, ModItems.PUMPKIN_PANCAKES, ModItems.PUMPKIN_PANCAKE, Ingredient.m_204132_(ModTags.Items.SYRUP), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)vectorwing.farmersdelight.common.registry.ModItems.PUMPKIN_SLICE.get()}));
        ModRecipeProvider.oneToOne(output, RecipeCategory.MISC, (ItemLike)ModItems.COTTON_BOLL.get(), (ItemLike)Items.f_42401_, 1);
        ModRecipeProvider.horizontalRecipe(output, RecipeCategory.MISC, (ItemLike)ModItems.COTTON_BOLL.get(), (ItemLike)Items.f_42516_, 3);
        ModRecipeProvider.twoBytwo(output, RecipeCategory.MISC, (ItemLike)ModItems.COTTON_BOLL.get(), (ItemLike)vectorwing.farmersdelight.common.registry.ModItems.CANVAS.get(), 1);
        ModRecipeProvider.storageItemRecipes(output, RecipeCategory.MISC, (ItemLike)ModItems.COTTON_SEEDS.get(), (ItemLike)ModItems.COTTON_SEEDS_BAG.get());
        ModRecipeProvider.storageItemRecipes(output, RecipeCategory.MISC, (ItemLike)ModItems.COTTON_BOLL.get(), (ItemLike)ModItems.COTTON_BOLL_CRATE.get());
        ModRecipeProvider.oneToOne(output, RecipeCategory.MISC, (ItemLike)ModItems.BELL_PEPPER_GREEN.get(), (ItemLike)Items.f_42496_, 1);
        ModRecipeProvider.oneToOne(output, RecipeCategory.MISC, (ItemLike)ModItems.BELL_PEPPER_YELLOW.get(), (ItemLike)Items.f_42539_, 1);
        ModRecipeProvider.oneToOne(output, RecipeCategory.MISC, (ItemLike)ModItems.BELL_PEPPER_RED.get(), (ItemLike)Items.f_42497_, 1);
        ModRecipeProvider.storageItemRecipes(output, RecipeCategory.MISC, (ItemLike)ModItems.BELL_PEPPER_SEEDS.get(), (ItemLike)ModItems.BELL_PEPPER_SEEDS_BAG.get());
        ModRecipeProvider.storageItemRecipes(output, RecipeCategory.MISC, (ItemLike)ModItems.BELL_PEPPER_GREEN.get(), (ItemLike)ModItems.BELL_PEPPER_GREEN_CRATE.get());
        ModRecipeProvider.storageItemRecipes(output, RecipeCategory.MISC, (ItemLike)ModItems.BELL_PEPPER_YELLOW.get(), (ItemLike)ModItems.BELL_PEPPER_YELLOW_CRATE.get());
        ModRecipeProvider.storageItemRecipes(output, RecipeCategory.MISC, (ItemLike)ModItems.BELL_PEPPER_RED.get(), (ItemLike)ModItems.BELL_PEPPER_RED_CRATE.get());
        ModRecipeProvider.storageItemRecipes(output, RecipeCategory.MISC, (ItemLike)ModItems.COFFEE_BEANS.get(), (ItemLike)ModItems.COFFEE_BEANS_BAG.get());
        ModRecipeProvider.storageItemRecipes(output, RecipeCategory.MISC, (ItemLike)ModItems.ROASTED_COFFEE_BEANS.get(), (ItemLike)ModItems.ROASTED_COFFEE_BEANS_BAG.get());
        ModRecipeProvider.oneToOne(output, RecipeCategory.MISC, (ItemLike)ModItems.COFFEE_BEANS.get(), (ItemLike)Items.f_42539_, 1);
        ModRecipeProvider.oneToOne(output, RecipeCategory.MISC, (ItemLike)ModItems.ROASTED_COFFEE_BEANS.get(), (ItemLike)Items.f_42495_, 1);
        ModRecipeProvider.foodCookingRecipes(output, (ItemLike)ModItems.COFFEE_BEANS.get(), (ItemLike)ModItems.ROASTED_COFFEE_BEANS.get(), 0.35f);
        Ingredient goldenCoffeeBeansIngredient = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.COFFEE_BEANS.get(), (ItemLike)ModItems.ROASTED_COFFEE_BEANS.get()});
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.GOLDEN_COFFEE_BEANS.get()), (int)1).m_126130_("GGG").m_126130_("GCG").m_126130_("GGG").m_126127_(Character.valueOf('G'), (ItemLike)Items.f_42587_).m_126124_(Character.valueOf('C'), goldenCoffeeBeansIngredient).m_126132_(ModRecipeProvider.m_176602_((ItemLike)((ItemLike)ModItems.COFFEE_BEANS.get())), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.COFFEE_BEANS.get()))).m_126132_(ModRecipeProvider.m_176602_((ItemLike)((ItemLike)ModItems.ROASTED_COFFEE_BEANS.get())), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.ROASTED_COFFEE_BEANS.get()))).m_176498_(output);
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.MILK_COFFEE.get()), (int)1).m_126209_((ItemLike)ModItems.COFFEE.get()).m_206419_(ForgeTags.MILK).m_126132_(ModRecipeProvider.m_176602_((ItemLike)((ItemLike)ModItems.COFFEE.get())), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.COFFEE.get()))).m_176500_(output, ModRecipeProvider.getRecipeName((ItemLike)ModItems.COFFEE.get(), (ItemLike)ModItems.MILK_COFFEE.get()));
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.CHOCOLATE_COFFEE.get()), (int)1).m_126209_((ItemLike)ModItems.MILK_COFFEE.get()).m_126209_((ItemLike)Items.f_42533_).m_126209_((ItemLike)Items.f_42533_).m_126132_(ModRecipeProvider.m_176602_((ItemLike)((ItemLike)ModItems.MILK_COFFEE.get())), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.MILK_COFFEE.get()))).m_176500_(output, ModRecipeProvider.getRecipeName((ItemLike)ModItems.MILK_COFFEE.get(), (ItemLike)ModItems.CHOCOLATE_COFFEE.get()));
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.CHOCOLATE_COFFEE.get()), (int)1).m_126209_((ItemLike)ModItems.COFFEE.get()).m_206419_(ForgeTags.MILK).m_126209_((ItemLike)Items.f_42533_).m_126209_((ItemLike)Items.f_42533_).m_126132_(ModRecipeProvider.m_176602_((ItemLike)((ItemLike)ModItems.COFFEE.get())), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.COFFEE.get()))).m_176500_(output, ModRecipeProvider.getRecipeName((ItemLike)ModItems.COFFEE.get(), (ItemLike)ModItems.CHOCOLATE_COFFEE.get()));
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.HONEY_COFFEE.get()), (int)1).m_126209_((ItemLike)ModItems.MILK_COFFEE.get()).m_126209_((ItemLike)Items.f_42787_).m_126209_((ItemLike)Items.f_42501_).m_126132_(ModRecipeProvider.m_176602_((ItemLike)((ItemLike)ModItems.MILK_COFFEE.get())), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.MILK_COFFEE.get()))).m_176500_(output, ModRecipeProvider.getRecipeName((ItemLike)ModItems.MILK_COFFEE.get(), (ItemLike)ModItems.HONEY_COFFEE.get()));
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.HONEY_COFFEE.get()), (int)1).m_126209_((ItemLike)ModItems.COFFEE.get()).m_206419_(ForgeTags.MILK).m_126209_((ItemLike)Items.f_42787_).m_126209_((ItemLike)Items.f_42501_).m_126132_(ModRecipeProvider.m_176602_((ItemLike)((ItemLike)ModItems.COFFEE.get())), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.COFFEE.get()))).m_176500_(output, ModRecipeProvider.getRecipeName((ItemLike)ModItems.COFFEE.get(), (ItemLike)ModItems.HONEY_COFFEE.get()));
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.SYRUP_COFFEE.get()), (int)1).m_126209_((ItemLike)ModItems.MILK_COFFEE.get()).m_206419_(ModTags.Items.SYRUP).m_126132_(ModRecipeProvider.m_176602_((ItemLike)((ItemLike)ModItems.MILK_COFFEE.get())), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.MILK_COFFEE.get()))).m_176500_(output, ModRecipeProvider.getRecipeName((ItemLike)ModItems.MILK_COFFEE.get(), (ItemLike)ModItems.SYRUP_COFFEE.get()));
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.SYRUP_COFFEE.get()), (int)1).m_126209_((ItemLike)ModItems.COFFEE.get()).m_206419_(ForgeTags.MILK).m_206419_(ModTags.Items.SYRUP).m_126132_(ModRecipeProvider.m_176602_((ItemLike)((ItemLike)ModItems.COFFEE.get())), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.COFFEE.get()))).m_176500_(output, ModRecipeProvider.getRecipeName((ItemLike)ModItems.COFFEE.get(), (ItemLike)ModItems.SYRUP_COFFEE.get()));
        ModRecipeProvider.oneToOne(output, RecipeCategory.MISC, (ItemLike)ModItems.SYRUP.get(), (ItemLike)Items.f_42501_, 3);
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.SYRUP_SANDWICH.get()), (int)1).m_206419_(ForgeTags.BREAD).m_206419_(ModTags.Items.SYRUP).m_126209_((ItemLike)Items.f_42501_).m_126132_(ModRecipeProvider.m_176602_((ItemLike)((ItemLike)ModItems.SYRUP.get())), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)((ItemLike)ModItems.SYRUP.get()))).m_176498_(output);
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.RICE_ROLL_ROYALE.get())).m_126209_((ItemLike)vectorwing.farmersdelight.common.registry.ModItems.KELP_ROLL_SLICE.get()).m_126209_((ItemLike)vectorwing.farmersdelight.common.registry.ModItems.KELP_ROLL_SLICE.get()).m_126209_((ItemLike)vectorwing.farmersdelight.common.registry.ModItems.KELP_ROLL_SLICE.get()).m_126209_((ItemLike)ModItems.BELL_PEPPER_ROLL_GREEN.get()).m_126209_((ItemLike)ModItems.BELL_PEPPER_ROLL_YELLOW.get()).m_126209_((ItemLike)ModItems.BELL_PEPPER_ROLL_RED.get()).m_126209_((ItemLike)ModItems.CALAMARI_ROLL.get()).m_126209_((ItemLike)Items.f_42399_).m_126209_((ItemLike)ModItems.CHERRY_BLOSSOM_ROLL.get()).m_126132_("has_rice_roll", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.BELL_PEPPER_ROLL_GREEN.get(), (ItemLike)ModItems.BELL_PEPPER_ROLL_YELLOW.get(), (ItemLike)ModItems.BELL_PEPPER_ROLL_RED.get(), (ItemLike)ModItems.CALAMARI_ROLL.get(), (ItemLike)ModItems.CHERRY_BLOSSOM_ROLL.get(), (ItemLike)vectorwing.farmersdelight.common.registry.ModItems.KELP_ROLL_SLICE.get()})).m_176498_(output);
    }

    private void buildCuttingRecipes(@NotNull Consumer<FinishedRecipe> output) {
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.WILD_COTTON.get()}), (Ingredient)Ingredient.m_204132_(ForgeTags.TOOLS_KNIVES), (ItemLike)((ItemLike)ModItems.COTTON_SEEDS.get()), (int)1).addResultWithChance((ItemLike)ModItems.COTTON_BOLL.get(), 0.3f).addResultWithChance((ItemLike)Items.f_42535_, 0.1f).build(output, ModRecipeProvider.getCuttingPath((Item)ModItems.WILD_COTTON.get()));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.WILD_BELL_PEPPERS.get()}), (Ingredient)Ingredient.m_204132_(ForgeTags.TOOLS_KNIVES), (ItemLike)((ItemLike)ModItems.BELL_PEPPER_SEEDS.get()), (int)1).addResultWithChance((ItemLike)ModItems.BELL_PEPPER_RED.get(), 0.3f).addResultWithChance((ItemLike)Items.f_42497_, 0.1f).build(output, ModRecipeProvider.getCuttingPath((Item)ModItems.WILD_BELL_PEPPERS.get()));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.WILD_COFFEE.get()}), (Ingredient)Ingredient.m_204132_(ForgeTags.TOOLS_KNIVES), (ItemLike)((ItemLike)ModItems.COFFEE_BEANS.get()), (int)1).addResultWithChance((ItemLike)ModItems.COFFEE_BEANS.get(), 0.3f).addResultWithChance((ItemLike)Items.f_42539_, 0.1f).build(output, ModItems.WILD_COFFEE.getId());
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42620_}), (Ingredient)Ingredient.m_204132_(ForgeTags.TOOLS_KNIVES), (ItemLike)((ItemLike)ModItems.POTATO_SLICES.get()), (int)2).build(output, ModRecipeProvider.getCuttingPath((Item)ModItems.POTATO_SLICES.get()));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42674_}), (Ingredient)Ingredient.m_204132_(ForgeTags.TOOLS_KNIVES), (ItemLike)((ItemLike)ModItems.BAKED_POTATO_SLICES.get()), (int)2).build(output, ModRecipeProvider.getCuttingPath((Item)ModItems.BAKED_POTATO_SLICES.get()));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CALAMARI.get()}), (Ingredient)Ingredient.m_204132_(ForgeTags.TOOLS_KNIVES), (ItemLike)((ItemLike)ModItems.CALAMARI_SLICE.get()), (int)2).addResult((ItemLike)Items.f_42499_).build(output, ModRecipeProvider.getCuttingPath((Item)ModItems.CALAMARI_SLICE.get()));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.COOKED_CALAMARI.get()}), (Ingredient)Ingredient.m_204132_(ForgeTags.TOOLS_KNIVES), (ItemLike)((ItemLike)ModItems.COOKED_CALAMARI_SLICE.get()), (int)2).addResult((ItemLike)Items.f_42499_).build(output, ModRecipeProvider.getCuttingPath((Item)ModItems.COOKED_CALAMARI_SLICE.get()));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CHERRY_BLOSSOM_CHEESECAKE.get()}), (Ingredient)Ingredient.m_204132_(ForgeTags.TOOLS_KNIVES), (ItemLike)((ItemLike)ModItems.CHERRY_BLOSSOM_CHEESECAKE_SLICE.get()), (int)4).build(output, ModItems.CHERRY_BLOSSOM_CHEESECAKE_SLICE.getId());
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.SYRUP_CHEESECAKE.get()}), (Ingredient)Ingredient.m_204132_(ForgeTags.TOOLS_KNIVES), (ItemLike)((ItemLike)ModItems.SYRUP_CHEESECAKE_SLICE.get()), (int)4).build(output, ModItems.SYRUP_CHEESECAKE_SLICE.getId());
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.m_204132_((TagKey)ItemTags.f_13167_), (Ingredient)Ingredient.m_204132_((TagKey)Tags.Items.SHEARS), (ItemLike)Items.f_42401_, (int)2).build(output, ModRecipeProvider.getCuttingPath("wool"));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.m_204132_((TagKey)ItemTags.f_215867_), (Ingredient)Ingredient.m_204132_((TagKey)Tags.Items.SHEARS), (ItemLike)Items.f_42401_, (int)1).build(output, ModRecipeProvider.getCuttingPath("wool_carpet"));
    }

    private void buildCookingRecipes(@NotNull Consumer<FinishedRecipe> output) {
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)((ItemLike)ModItems.COOKING_OIL.get()), (int)2, (int)100, (float)0.35f, (ItemLike)Items.f_42590_).addIngredient(ModTags.Items.COOKING_OIL_INGREDIENTS).addIngredient(ModTags.Items.COOKING_OIL_INGREDIENTS).addIngredient(ModTags.Items.COOKING_OIL_INGREDIENTS).addIngredient(ModTags.Items.COOKING_OIL_INGREDIENTS).addIngredient(ModTags.Items.COOKING_OIL_INGREDIENTS).addIngredient(ModTags.Items.COOKING_OIL_INGREDIENTS).unlockedByAnyIngredient(new ItemLike[]{(ItemLike)ModItems.COTTON_SEEDS.get()}).setRecipeBookTab(CookingPotRecipeBookTab.MISC).build(output, ModRecipeProvider.getCookingPath((Item)ModItems.COOKING_OIL.get()));
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)((ItemLike)ModItems.BATTER.get()), (int)2, (int)100, (float)0.35f, (ItemLike)Items.f_42399_).addIngredient(ForgeTags.MILK).addIngredient(Tags.Items.EGGS).addIngredient((ItemLike)Items.f_42405_).addIngredient((ItemLike)Items.f_42405_).unlockedByAnyIngredient(new ItemLike[]{Items.f_42455_, (ItemLike)vectorwing.farmersdelight.common.registry.ModItems.MILK_BOTTLE.get()}).setRecipeBookTab(CookingPotRecipeBookTab.MISC).build(output, ModRecipeProvider.getCookingPath((Item)ModItems.BATTER.get()));
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)((ItemLike)ModItems.SYRUP.get()), (int)1, (int)100, (float)0.35f, (ItemLike)Items.f_42590_).addIngredient(ModTags.Items.SYRUP_INGREDIENTS).addIngredient((ItemLike)Items.f_42501_).unlockedByAnyIngredient(new ItemLike[]{Items.f_42410_, Items.f_42732_, Items.f_42501_}).setRecipeBookTab(CookingPotRecipeBookTab.MISC).build(output, ModItems.SYRUP.getId());
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)((ItemLike)ModItems.FRIED_DOUGH.get()), (int)1, (int)100, (float)0.35f).addIngredient(ModTags.Items.COOKING_OIL).addIngredient(ForgeTags.DOUGH).unlockedByAnyIngredient(new ItemLike[]{(ItemLike)ModItems.COOKING_OIL.get()}).setRecipeBookTab(CookingPotRecipeBookTab.MISC).build(output, ModItems.FRIED_DOUGH.getId());
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)((ItemLike)ModItems.FRIED_DUMPLINGS.get()), (int)2, (int)100, (float)1.0f).addIngredient(ModTags.Items.COOKING_OIL).addIngredient((ItemLike)vectorwing.farmersdelight.common.registry.ModItems.DUMPLINGS.get(), 2).unlockedByAnyIngredient(new ItemLike[]{(ItemLike)vectorwing.farmersdelight.common.registry.ModItems.DUMPLINGS.get()}).setRecipeBookTab(CookingPotRecipeBookTab.MISC).build(output, ModItems.FRIED_DUMPLINGS.getId());
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)((ItemLike)ModItems.SPRING_ROLLS.get()), (int)2, (int)100, (float)1.0f).addIngredient(ModTags.Items.COOKING_OIL).addIngredient(ForgeTags.DOUGH).addIngredient(ForgeTags.SALAD_INGREDIENTS).addIngredient(ModTags.CABBAGE_ROLL_INGREDIENTS).unlockedByAnyIngredient(new ItemLike[]{(ItemLike)ModItems.COOKING_OIL.get()}).setRecipeBookTab(CookingPotRecipeBookTab.MISC).build(output, ModRecipeProvider.getCookingPath((Item)ModItems.SPRING_ROLLS.get()));
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)((ItemLike)ModItems.FRUIT_BEIGNET.get()), (int)1, (int)100, (float)1.0f).addIngredient(ModTags.Items.COOKING_OIL).addIngredient(ForgeTags.DOUGH).addIngredient(ForgeTags.BERRIES).addIngredient((ItemLike)Items.f_42501_).unlockedByAnyIngredient(new ItemLike[]{(ItemLike)ModItems.COOKING_OIL.get()}).setRecipeBookTab(CookingPotRecipeBookTab.MISC).build(output, ModRecipeProvider.getCookingPath((Item)ModItems.FRUIT_BEIGNET.get()));
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)((ItemLike)ModItems.FRIED_CALAMARI.get()), (int)1, (int)200, (float)1.0f, (ItemLike)Items.f_42399_).addIngredient(ModTags.Items.COOKING_OIL).addIngredient((ItemLike)ModItems.BATTER.get()).addIngredient(ForgeTags.RAW_FISHES_CALAMARI).addIngredient(ForgeTags.VEGETABLES_TOMATO).unlockedByAnyIngredient(new ItemLike[]{(ItemLike)ModItems.COOKING_OIL.get()}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(output, ModRecipeProvider.getCookingPath((Item)ModItems.FRIED_CALAMARI.get()));
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)((ItemLike)ModItems.FRIED_CHICKEN.get()), (int)1, (int)200, (float)1.0f, (ItemLike)Items.f_42399_).addIngredient(ModTags.Items.COOKING_OIL).addIngredient((ItemLike)ModItems.BATTER.get()).addIngredient(ForgeTags.RAW_CHICKEN).addIngredient(ForgeTags.VEGETABLES_ONION).unlockedByAnyIngredient(new ItemLike[]{(ItemLike)ModItems.COOKING_OIL.get()}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(output, ModRecipeProvider.getCookingPath((Item)ModItems.FRIED_CHICKEN.get()));
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)((ItemLike)ModItems.FRIED_MUSHROOMS.get()), (int)1, (int)200, (float)1.0f, (ItemLike)Items.f_42399_).addIngredient(ModTags.Items.COOKING_OIL).addIngredient((ItemLike)Items.f_41952_).addIngredient((ItemLike)Items.f_41953_).addIngredient(ForgeTags.VEGETABLES_ONION).unlockedByAnyIngredient(new ItemLike[]{(ItemLike)ModItems.COOKING_OIL.get()}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(output, ModRecipeProvider.getCookingPath((Item)ModItems.FRIED_MUSHROOMS.get()));
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)((ItemLike)vectorwing.farmersdelight.common.registry.ModItems.FRIED_RICE.get()), (int)1, (int)200, (float)1.0f, (ItemLike)Items.f_42399_).addIngredient((ItemLike)vectorwing.farmersdelight.common.registry.ModItems.RICE.get()).addIngredient(CompoundIngredient.of((Ingredient[])new Ingredient[]{Ingredient.m_204132_((TagKey)Tags.Items.EGGS), Ingredient.m_204132_(ModTags.Items.COOKING_OIL)})).addIngredient(ForgeTags.VEGETABLES_CARROT).addIngredient(ForgeTags.VEGETABLES_ONION).unlockedByAnyIngredient(new ItemLike[]{(ItemLike)vectorwing.farmersdelight.common.registry.ModItems.RICE.get(), Items.f_42521_, Items.f_42619_, (ItemLike)vectorwing.farmersdelight.common.registry.ModItems.ONION.get(), (ItemLike)ModItems.COOKING_OIL.get()}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(output);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)((ItemLike)vectorwing.farmersdelight.common.registry.ModItems.FRIED_EGG.get()), (int)1, (int)100, (float)0.35f).addIngredient((ItemLike)Items.f_42521_).addIngredient(ModTags.Items.COOKING_OIL).unlockedByAnyIngredient(new ItemLike[]{(ItemLike)ModItems.COOKING_OIL.get()}).setRecipeBookTab(CookingPotRecipeBookTab.MISC).build(output, ModRecipeProvider.getRecipeName((ItemLike)ModItems.COOKING_OIL.get(), (ItemLike)vectorwing.farmersdelight.common.registry.ModItems.FRIED_EGG.get()));
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)((ItemLike)ModItems.BELL_PEPPER_SOUP.get()), (int)1, (int)200, (float)1.0f, (ItemLike)Items.f_42399_).addIngredient(ForgeTags.VEGETABLES_BELL_PEPPER).addIngredient(ForgeTags.VEGETABLES_BELL_PEPPER).addIngredient(ForgeTags.VEGETABLES_BELL_PEPPER).unlockedByAnyIngredient(new ItemLike[]{(ItemLike)ModItems.BELL_PEPPER_GREEN.get(), (ItemLike)ModItems.BELL_PEPPER_YELLOW.get(), (ItemLike)ModItems.BELL_PEPPER_RED.get()}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(output, ModRecipeProvider.getCookingPath((Item)ModItems.BELL_PEPPER_SOUP.get()));
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)((ItemLike)ModItems.STUFFED_BELL_PEPPER_GREEN.get()), (int)1, (int)200, (float)1.0f).addIngredient((ItemLike)ModItems.BELL_PEPPER_GREEN.get()).addIngredient(ForgeTags.GRAIN_RICE).addIngredient(ModRecipeProvider.stuffedBellPepperFilling()).unlockedByAnyIngredient(new ItemLike[]{(ItemLike)ModItems.BELL_PEPPER_GREEN.get()}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(output, ModRecipeProvider.getCookingPath((Item)ModItems.STUFFED_BELL_PEPPER_GREEN.get()));
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)((ItemLike)ModItems.STUFFED_BELL_PEPPER_YELLOW.get()), (int)1, (int)200, (float)1.0f).addIngredient((ItemLike)ModItems.BELL_PEPPER_YELLOW.get()).addIngredient(ForgeTags.GRAIN_RICE).addIngredient(ModRecipeProvider.stuffedBellPepperFilling()).unlockedByAnyIngredient(new ItemLike[]{(ItemLike)ModItems.BELL_PEPPER_YELLOW.get()}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(output, ModRecipeProvider.getCookingPath((Item)ModItems.STUFFED_BELL_PEPPER_YELLOW.get()));
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)((ItemLike)ModItems.STUFFED_BELL_PEPPER_RED.get()), (int)1, (int)200, (float)1.0f).addIngredient((ItemLike)ModItems.BELL_PEPPER_RED.get()).addIngredient(ForgeTags.GRAIN_RICE).addIngredient(ModRecipeProvider.stuffedBellPepperFilling()).unlockedByAnyIngredient(new ItemLike[]{(ItemLike)ModItems.BELL_PEPPER_RED.get()}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(output, ModRecipeProvider.getCookingPath((Item)ModItems.STUFFED_BELL_PEPPER_RED.get()));
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)((ItemLike)ModItems.BELL_PEPPER_PASTA.get()), (int)1, (int)200, (float)1.0f, (ItemLike)Items.f_42399_).addIngredient(ForgeTags.PASTA).addIngredient((ItemLike)ModItems.BELL_PEPPER_GREEN.get()).addIngredient((ItemLike)ModItems.BELL_PEPPER_YELLOW.get()).addIngredient((ItemLike)ModItems.BELL_PEPPER_RED.get()).unlockedByAnyIngredient(new ItemLike[]{(ItemLike)ModItems.BELL_PEPPER_GREEN.get(), (ItemLike)ModItems.BELL_PEPPER_YELLOW.get(), (ItemLike)ModItems.BELL_PEPPER_RED.get()}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(output, ModRecipeProvider.getCookingPath((Item)ModItems.BELL_PEPPER_PASTA.get()));
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)((ItemLike)ModItems.COFFEE.get()), (int)1, (int)200, (float)1.0f, (ItemLike)Items.f_42590_).addIngredient(ModRecipeProvider.waterIngredient()).addIngredient(ModTags.Items.COFFEE_INGREDIENTS).addIngredient(ModTags.Items.COFFEE_INGREDIENTS).addIngredient(ModTags.Items.COFFEE_INGREDIENTS).unlockedByAnyIngredient(new ItemLike[]{(ItemLike)ModItems.ROASTED_COFFEE_BEANS.get()}).setRecipeBookTab(CookingPotRecipeBookTab.DRINKS).build(output, ModItems.COFFEE.getId());
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)((ItemLike)ModItems.MILK_COFFEE.get()), (int)1, (int)200, (float)1.0f, (ItemLike)Items.f_42590_).addIngredient(ForgeTags.MILK).addIngredient(ModTags.Items.COFFEE_INGREDIENTS).addIngredient(ModTags.Items.COFFEE_INGREDIENTS).addIngredient(ModTags.Items.COFFEE_INGREDIENTS).unlockedByAnyIngredient(new ItemLike[]{(ItemLike)ModItems.ROASTED_COFFEE_BEANS.get()}).setRecipeBookTab(CookingPotRecipeBookTab.DRINKS).build(output, ModItems.MILK_COFFEE.getId());
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)((ItemLike)ModItems.CHOCOLATE_COFFEE.get()), (int)1, (int)200, (float)1.0f, (ItemLike)Items.f_42590_).addIngredient(ForgeTags.MILK).addIngredient(ModTags.Items.COFFEE_INGREDIENTS).addIngredient(ModTags.Items.COFFEE_INGREDIENTS).addIngredient(ModTags.Items.COFFEE_INGREDIENTS).addIngredient((ItemLike)Items.f_42533_, 2).unlockedByAnyIngredient(new ItemLike[]{(ItemLike)ModItems.ROASTED_COFFEE_BEANS.get()}).setRecipeBookTab(CookingPotRecipeBookTab.DRINKS).build(output, ModItems.CHOCOLATE_COFFEE.getId());
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)((ItemLike)ModItems.HONEY_COFFEE.get()), (int)1, (int)200, (float)1.0f, (ItemLike)Items.f_42590_).addIngredient(ForgeTags.MILK).addIngredient(ModTags.Items.COFFEE_INGREDIENTS).addIngredient(ModTags.Items.COFFEE_INGREDIENTS).addIngredient(ModTags.Items.COFFEE_INGREDIENTS).addIngredient((ItemLike)Items.f_42787_, 1).addIngredient((ItemLike)Items.f_42501_, 1).unlockedByAnyIngredient(new ItemLike[]{(ItemLike)ModItems.ROASTED_COFFEE_BEANS.get()}).setRecipeBookTab(CookingPotRecipeBookTab.DRINKS).build(output, ModItems.HONEY_COFFEE.getId());
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)((ItemLike)ModItems.SYRUP_COFFEE.get()), (int)1, (int)200, (float)1.0f, (ItemLike)Items.f_42590_).addIngredient(ForgeTags.MILK).addIngredient(ModTags.Items.COFFEE_INGREDIENTS).addIngredient(ModTags.Items.COFFEE_INGREDIENTS).addIngredient(ModTags.Items.COFFEE_INGREDIENTS).addIngredient((ItemLike)ModItems.SYRUP.get(), 1).unlockedByAnyIngredient(new ItemLike[]{(ItemLike)ModItems.ROASTED_COFFEE_BEANS.get()}).setRecipeBookTab(CookingPotRecipeBookTab.DRINKS).build(output, ModItems.SYRUP_COFFEE.getId());
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)((ItemLike)ModItems.DARK_COFFEE.get()), (int)1, (int)400, (float)1.0f, (ItemLike)Items.f_42590_).addIngredient(ModRecipeProvider.waterIngredient()).addIngredient(ModTags.Items.COFFEE_INGREDIENTS).addIngredient(ModTags.Items.COFFEE_INGREDIENTS).addIngredient(ModTags.Items.COFFEE_INGREDIENTS).addIngredient(ModTags.Items.COFFEE_INGREDIENTS).addIngredient(ModTags.Items.COFFEE_INGREDIENTS).unlockedByAnyIngredient(new ItemLike[]{(ItemLike)ModItems.ROASTED_COFFEE_BEANS.get()}).setRecipeBookTab(CookingPotRecipeBookTab.DRINKS).build(output, ModItems.DARK_COFFEE.getId());
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)((ItemLike)ModItems.COFFEE_BRAISED_BEEF.get()), (int)1, (int)400, (float)1.0f, (ItemLike)Items.f_42399_).addIngredient(ForgeTags.RAW_BEEF).addIngredient(ModTags.Items.COFFEE_FOOD_INGREDIENTS).addIngredient(ForgeTags.VEGETABLES_CARROT).addIngredient(ForgeTags.VEGETABLES_POTATO).unlockedByAnyIngredient(new ItemLike[]{(ItemLike)ModItems.COFFEE.get()}).setRecipeBookTab(CookingPotRecipeBookTab.MEALS).build(output, ModItems.COFFEE_BRAISED_BEEF.getId());
    }

    protected static void oneToOne(Consumer<FinishedRecipe> recipeOutput, RecipeCategory category, ItemLike item, ItemLike result, int count) {
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)category, (ItemLike)result, (int)count).m_126209_(item).m_126132_(ModRecipeProvider.m_176602_((ItemLike)item), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)item)).m_176500_(recipeOutput, ModRecipeProvider.getRecipeName(item, result));
    }

    protected static void horizontalRecipe(Consumer<FinishedRecipe> recipeOutput, RecipeCategory category, ItemLike item, ItemLike result, int count) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)category, (ItemLike)result, (int)count).m_126130_("###").m_126127_(Character.valueOf('#'), item).m_126132_(ModRecipeProvider.m_176602_((ItemLike)item), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)item)).m_176500_(recipeOutput, ModRecipeProvider.getRecipeName(item, result));
    }

    protected static void twoBytwo(Consumer<FinishedRecipe> recipeOutput, RecipeCategory category, ItemLike item, ItemLike result, int count) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)category, (ItemLike)result, (int)count).m_126130_("##").m_126130_("##").m_126127_(Character.valueOf('#'), item).m_126132_(ModRecipeProvider.m_176602_((ItemLike)item), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)item)).m_176500_(recipeOutput, ModRecipeProvider.getRecipeName(item, result));
    }

    protected static void storageItemRecipes(Consumer<FinishedRecipe> recipeOutput, RecipeCategory category, ItemLike item, ItemLike storageItem) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)category, (ItemLike)storageItem).m_126130_("###").m_126130_("###").m_126130_("###").m_126127_(Character.valueOf('#'), item).m_126132_(ModRecipeProvider.m_176602_((ItemLike)item), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)item)).m_176500_(recipeOutput, ModRecipeProvider.getRecipeName(item, storageItem));
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)category, (ItemLike)item, (int)9).m_126209_(storageItem).m_126132_(ModRecipeProvider.m_176602_((ItemLike)storageItem), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)storageItem)).m_176500_(recipeOutput, ModRecipeProvider.getRecipeName(storageItem, item));
    }

    protected static void foodCookingRecipes(@NotNull Consumer<FinishedRecipe> recipeOutput, @NotNull ItemLike material, @NotNull ItemLike result, float experience) {
        ModRecipeProvider.foodSmelting(recipeOutput, material, result, experience);
        ModRecipeProvider.foodSmoking(recipeOutput, material, result, experience);
        ModRecipeProvider.foodCampfireCooking(recipeOutput, material, result, experience);
    }

    protected static void foodSmelting(@NotNull Consumer<FinishedRecipe> recipeOutput, @NotNull ItemLike material, @NotNull ItemLike result, float experience) {
        SimpleCookingRecipeBuilder.m_247607_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{material}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)result, (float)experience, (int)200, (RecipeSerializer)RecipeSerializer.f_44091_).m_126132_(ModRecipeProvider.m_176602_((ItemLike)material), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)material)).m_176498_(recipeOutput);
    }

    protected static void foodSmoking(@NotNull Consumer<FinishedRecipe> recipeOutput, @NotNull ItemLike material, @NotNull ItemLike result, float experience) {
        SimpleCookingRecipeBuilder.m_247607_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{material}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)result, (float)experience, (int)100, (RecipeSerializer)RecipeSerializer.f_44093_).m_126132_(ModRecipeProvider.m_176602_((ItemLike)material), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)material)).m_176500_(recipeOutput, "rusticdelight:" + ModRecipeProvider.m_176632_((ItemLike)result) + "_from_smoking");
    }

    protected static void foodCampfireCooking(@NotNull Consumer<FinishedRecipe> recipeOutput, @NotNull ItemLike material, @NotNull ItemLike result, float experience) {
        SimpleCookingRecipeBuilder.m_247607_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{material}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)result, (float)experience, (int)600, (RecipeSerializer)RecipeSerializer.f_44094_).m_126132_(ModRecipeProvider.m_176602_((ItemLike)material), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)material)).m_176500_(recipeOutput, "rusticdelight:" + ModRecipeProvider.m_176632_((ItemLike)result) + "_from_campfire_cooking");
    }

    protected static void simpleSushiRoll(@NotNull Consumer<FinishedRecipe> recipeOutput, @NotNull RegistryObject<Item> ingredient, @NotNull RegistryObject<Item> result) {
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)result.get()), (int)2).m_126209_((ItemLike)ingredient.get()).m_126209_((ItemLike)ingredient.get()).m_126209_((ItemLike)vectorwing.farmersdelight.common.registry.ModItems.COOKED_RICE.get()).m_126132_(ModRecipeProvider.m_176602_((ItemLike)((ItemLike)ingredient.get())), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)((ItemLike)ingredient.get()))).m_126132_(ModRecipeProvider.m_176602_((ItemLike)((ItemLike)vectorwing.farmersdelight.common.registry.ModItems.COOKED_RICE.get())), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)((ItemLike)vectorwing.farmersdelight.common.registry.ModItems.COOKED_RICE.get()))).m_176498_(recipeOutput);
    }

    protected static void pancakeRecipes(@NotNull Consumer<FinishedRecipe> recipeOutput, @NotNull RegistryObject<Item> pancakeBlock, @NotNull RegistryObject<Item> singlePancake, Ingredient topping, Ingredient ingredient) {
        ModRecipeProvider.pancakeRecipes(recipeOutput, pancakeBlock, singlePancake, topping, ingredient, ingredient);
    }

    protected static void pancakeRecipes(@NotNull Consumer<FinishedRecipe> recipeOutput, @NotNull RegistryObject<Item> pancakeBlock, @NotNull RegistryObject<Item> singlePancake, Ingredient topping, Ingredient ingredient, Ingredient ingredient2) {
        RegistryObject<Item> batter = ModItems.BATTER;
        Item servingItem = Items.f_42399_;
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)pancakeBlock.get()), (int)1).m_126130_(" T ").m_126130_("XMX").m_126130_("YBY").m_126124_(Character.valueOf('T'), topping).m_126124_(Character.valueOf('X'), ingredient).m_126124_(Character.valueOf('Y'), ingredient2).m_126127_(Character.valueOf('M'), (ItemLike)batter.get()).m_126127_(Character.valueOf('B'), (ItemLike)servingItem).m_126132_(ModRecipeProvider.m_176602_((ItemLike)((ItemLike)batter.get())), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)((ItemLike)batter.get()))).m_176498_(recipeOutput);
        CookingPotRecipeBuilder.cookingPotRecipe((ItemLike)((ItemLike)pancakeBlock.get()), (int)1, (int)400, (float)2.0f, (ItemLike)servingItem).addIngredient((ItemLike)batter.get()).addIngredient(topping).addIngredient(ingredient, 2).addIngredient(ingredient2, 2).unlockedByAnyIngredient(new ItemLike[]{(ItemLike)batter.get()}).setRecipeBookTab(CookingPotRecipeBookTab.MISC).build(recipeOutput, ModRecipeProvider.getCookingPath((Item)pancakeBlock.get()));
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)pancakeBlock.get()}), (Ingredient)Ingredient.m_204132_(ForgeTags.TOOLS_KNIVES), (ItemLike)((ItemLike)singlePancake.get()), (int)PancakeBlock.MAX_SERVINGS).addResult((ItemLike)servingItem).build(recipeOutput, ModRecipeProvider.getCuttingPath((Item)pancakeBlock.get()));
        ModRecipeProvider.oneToOne(recipeOutput, RecipeCategory.MISC, (ItemLike)pancakeBlock.get(), (ItemLike)singlePancake.get(), PancakeBlock.MAX_SERVINGS);
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)pancakeBlock.get())).m_126211_((ItemLike)singlePancake.get(), PancakeBlock.MAX_SERVINGS.intValue()).m_126209_((ItemLike)servingItem).m_126132_(ModRecipeProvider.m_176602_((ItemLike)((ItemLike)singlePancake.get())), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)((ItemLike)singlePancake.get()))).m_176500_(recipeOutput, ModRecipeProvider.getRecipeName((ItemLike)singlePancake.get(), (ItemLike)pancakeBlock.get()));
    }

    protected static void pieRecipes(@NotNull Consumer<FinishedRecipe> recipeOutput, @NotNull RegistryObject<Item> pieBlock, @NotNull RegistryObject<Item> sliceItem, Ingredient topping) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)pieBlock.get()), (int)1).m_126130_("TTT").m_126130_("MMM").m_126130_("SCS").m_126124_(Character.valueOf('T'), topping).m_206416_(Character.valueOf('M'), ForgeTags.MILK).m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42501_).m_126127_(Character.valueOf('C'), (ItemLike)vectorwing.farmersdelight.common.registry.ModItems.PIE_CRUST.get()).m_126132_(ModRecipeProvider.m_176602_((ItemLike)((ItemLike)vectorwing.farmersdelight.common.registry.ModItems.PIE_CRUST.get())), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)((ItemLike)vectorwing.farmersdelight.common.registry.ModItems.PIE_CRUST.get()))).m_176498_(recipeOutput);
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)pieBlock.get()), (int)1).m_126130_("##").m_126130_("##").m_126127_(Character.valueOf('#'), (ItemLike)sliceItem.get()).m_126132_(ModRecipeProvider.m_176602_((ItemLike)((ItemLike)sliceItem.get())), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)((ItemLike)sliceItem.get()))).m_126140_(recipeOutput, new ResourceLocation("rusticdelight", ModRecipeProvider.m_176632_((ItemLike)((ItemLike)pieBlock.get())) + "_from_slices"));
    }

    protected static String getRecipeName(ItemLike item, ItemLike result) {
        return "rusticdelight:" + ModRecipeProvider.m_176517_((ItemLike)result, (ItemLike)item);
    }

    protected static String getCookingPath(Item item) {
        return "rusticdelight:cooking/" + ForgeRegistries.ITEMS.getKey((Object)item).m_135815_();
    }

    protected static String getCuttingPath(Item item) {
        return "rusticdelight:cutting/" + ForgeRegistries.ITEMS.getKey((Object)item).m_135815_();
    }

    protected static String getCuttingPath(String itemName) {
        return "rusticdelight:cutting/" + itemName;
    }

    private static Ingredient stuffedBellPepperFilling() {
        return DifferenceIngredient.of((Ingredient)Ingredient.m_204132_((TagKey)ModTags.CABBAGE_ROLL_INGREDIENTS), (Ingredient)Ingredient.m_204132_(ForgeTags.VEGETABLES_BELL_PEPPER));
    }

    private static Ingredient waterIngredient() {
        CompoundTag waterPotionTag = new CompoundTag();
        waterPotionTag.m_128359_("Potion", Objects.requireNonNull(ForgeRegistries.POTIONS.getKey((Object)Potions.f_43599_)).toString());
        PartialNBTIngredient waterBottleIngredient = PartialNBTIngredient.of((CompoundTag)waterPotionTag, (ItemLike[])new ItemLike[]{Items.f_42589_});
        return CompoundIngredient.of((Ingredient[])new Ingredient[]{waterBottleIngredient, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42447_})});
    }
}

