/*
 * Decompiled with CFR 0.152.
 */
package com.phantomwing.rusticdelight;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import com.phantomwing.rusticdelight.Configuration;
import com.phantomwing.rusticdelight.block.ModBlocks;
import com.phantomwing.rusticdelight.item.ModItems;
import com.phantomwing.rusticdelight.loot.ModLootModifiers;
import com.phantomwing.rusticdelight.potions.ModBrewingRecipe;
import com.phantomwing.rusticdelight.potions.ModPotions;
import com.phantomwing.rusticdelight.ui.ModCreativeModeTab;
import com.phantomwing.rusticdelight.world.ModPlacementModifiers;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.common.crafting.CompoundIngredient;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="rusticdelight")
public class RusticDelight {
    public static final String MOD_ID = "rusticdelight";
    private static final Logger LOGGER = LogUtils.getLogger();

    public RusticDelight() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Configuration.COMMON_CONFIG);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.registerManagers(modEventBus);
    }

    private void registerManagers(IEventBus eventBus) {
        ModItems.register(eventBus);
        ModBlocks.register(eventBus);
        ModLootModifiers.register(eventBus);
        ModCreativeModeTab.register(eventBus);
        ModPlacementModifiers.register(eventBus);
        ModPotions.register(eventBus);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            this.addFlowerPots();
            this.registerCompostables();
            RusticDelight.registerItemSetAdditions();
            RusticDelight.registerPotionRecipes();
        });
    }

    private void addFlowerPots() {
        FlowerPotBlock flowerPotBlock = (FlowerPotBlock)Blocks.f_50276_;
        flowerPotBlock.addPlant(ModBlocks.WILD_COTTON.getId(), ModBlocks.POTTED_WILD_COTTON);
        flowerPotBlock.addPlant(ModBlocks.WILD_BELL_PEPPERS.getId(), ModBlocks.POTTED_WILD_BELL_PEPPERS);
        flowerPotBlock.addPlant(ModBlocks.WILD_COFFEE.getId(), ModBlocks.POTTED_WILD_COFFEE);
    }

    private void registerCompostables() {
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.COTTON_SEEDS.get()), 0.3f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.BELL_PEPPER_SEEDS.get()), 0.3f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.COTTON_BOLL.get()), 0.5f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.POTATO_SLICES.get()), 0.5f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.COFFEE_BEANS.get()), 0.5f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.BELL_PEPPER_SLICE_GREEN.get()), 0.5f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.BELL_PEPPER_SLICE_YELLOW.get()), 0.5f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.BELL_PEPPER_SLICE_RED.get()), 0.5f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.BELL_PEPPER_GREEN.get()), 0.65f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.BELL_PEPPER_YELLOW.get()), 0.65f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.BELL_PEPPER_RED.get()), 0.65f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.WILD_COTTON.get()), 0.65f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.WILD_BELL_PEPPERS.get()), 0.65f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.WILD_COFFEE.get()), 0.65f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.ROASTED_COFFEE_BEANS.get()), 0.65f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.COFFEE_COOKIE.get()), 0.85f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.SYRUP_COOKIE.get()), 0.85f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.CHERRY_BLOSSOM_COOKIE.get()), 0.85f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.SYRUP_CHEESECAKE_SLICE.get()), 0.85f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.CHERRY_BLOSSOM_CHEESECAKE_SLICE.get()), 0.85f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.SYRUP_CHEESECAKE.get()), 1.0f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.CHERRY_BLOSSOM_CHEESECAKE.get()), 1.0f);
    }

    public static void registerItemSetAdditions() {
        Ingredient newChickenFood = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.COTTON_SEEDS.get(), (ItemLike)ModItems.BELL_PEPPER_SEEDS.get()});
        Chicken.f_28233_ = new CompoundIngredient(Arrays.asList(Chicken.f_28233_, newChickenFood)){};
        Ingredient newPigFood = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.BELL_PEPPER_GREEN.get(), (ItemLike)ModItems.BELL_PEPPER_YELLOW.get(), (ItemLike)ModItems.BELL_PEPPER_RED.get()});
        Pig.f_29458_ = new CompoundIngredient(Arrays.asList(Pig.f_29458_, newPigFood)){};
        Collections.addAll(Parrot.f_29357_, (Item)ModItems.COTTON_SEEDS.get(), (Item)ModItems.BELL_PEPPER_SEEDS.get());
        HashSet newWantedItems = Sets.newHashSet((Object[])new Item[]{(Item)ModItems.BELL_PEPPER_GREEN.get(), (Item)ModItems.BELL_PEPPER_YELLOW.get(), (Item)ModItems.BELL_PEPPER_RED.get(), (Item)ModItems.COTTON_BOLL.get(), (Item)ModItems.BELL_PEPPER_SEEDS.get(), (Item)ModItems.COTTON_SEEDS.get(), (Item)ModItems.COFFEE_BEANS.get()});
        newWantedItems.addAll(Villager.f_35372_);
        Villager.f_35372_ = ImmutableSet.copyOf((Collection)newWantedItems);
    }

    public static void registerPotionRecipes() {
        if (!((Boolean)Configuration.ENABLE_POTIONS.get()).booleanValue()) {
            return;
        }
        if ((Integer)Configuration.CHANCE_WILD_COFFEE.get() > 0) {
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ModBrewingRecipe(Potions.f_43602_, (Item)ModItems.GOLDEN_COFFEE_BEANS.get(), (Potion)ModPotions.HASTE_POTION.get()));
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ModBrewingRecipe((Potion)ModPotions.HASTE_POTION.get(), Items.f_42451_, (Potion)ModPotions.LONG_HASTE_POTION.get()));
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ModBrewingRecipe((Potion)ModPotions.HASTE_POTION.get(), Items.f_42525_, (Potion)ModPotions.STRONG_HASTE_POTION.get()));
        }
    }

    @Mod.EventBusSubscriber(modid="rusticdelight", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
        }
    }
}

