/*
 * Decompiled with CFR 0.152.
 */
package com.phantomwing.rusticdelight.block.custom;

import com.mojang.datafixers.util.Pair;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import vectorwing.farmersdelight.common.tag.ModTags;
import vectorwing.farmersdelight.common.utility.ItemUtils;

public class PancakeBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final Integer MAX_SERVINGS = 6;
    public static final IntegerProperty SERVINGS = IntegerProperty.m_61631_((String)"servings", (int)0, (int)(MAX_SERVINGS - 1));
    public final Supplier<Item> servingItem;
    protected static final VoxelShape PLATE_SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)15.0);
    protected static final VoxelShape[] PANCAKES_SHAPES = new VoxelShape[]{Shapes.m_83148_((VoxelShape)PLATE_SHAPE, (VoxelShape)Block.m_49796_((double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0), (BooleanOp)BooleanOp.f_82695_), Shapes.m_83148_((VoxelShape)PLATE_SHAPE, (VoxelShape)Block.m_49796_((double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)7.0, (double)13.0), (BooleanOp)BooleanOp.f_82695_), Shapes.m_83148_((VoxelShape)PLATE_SHAPE, (VoxelShape)Block.m_49796_((double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)6.0, (double)13.0), (BooleanOp)BooleanOp.f_82695_), Shapes.m_83148_((VoxelShape)PLATE_SHAPE, (VoxelShape)Block.m_49796_((double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)5.0, (double)13.0), (BooleanOp)BooleanOp.f_82695_), Shapes.m_83148_((VoxelShape)PLATE_SHAPE, (VoxelShape)Block.m_49796_((double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)4.0, (double)13.0), (BooleanOp)BooleanOp.f_82695_), Shapes.m_83148_((VoxelShape)PLATE_SHAPE, (VoxelShape)Block.m_49796_((double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)3.0, (double)13.0), (BooleanOp)BooleanOp.f_82695_)};

    public PancakeBlock(Supplier<Item> servingItem, BlockBehaviour.Properties properties) {
        super(properties);
        this.servingItem = servingItem;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)SERVINGS, (Comparable)Integer.valueOf(0)));
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, Level level, @NotNull BlockPos pos, Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        ItemStack heldStack = player.m_21120_(hand);
        if (level.f_46443_) {
            if (heldStack.m_204117_(ModTags.KNIVES)) {
                return this.takeServing(level, pos, state, player);
            }
            if (this.consumeServing(level, pos, state, player) == InteractionResult.SUCCESS) {
                return InteractionResult.SUCCESS;
            }
            if (heldStack.m_41619_()) {
                return InteractionResult.CONSUME;
            }
        }
        if (heldStack.m_204117_(ModTags.KNIVES)) {
            return this.takeServing(level, pos, state, player);
        }
        return this.consumeServing(level, pos, state, player);
    }

    protected InteractionResult takeServing(Level level, BlockPos pos, BlockState state, Player player) {
        Direction direction = player.m_6350_().m_122424_();
        ItemUtils.spawnItemEntity((Level)level, (ItemStack)this.getServingItem(), (double)((double)pos.m_123341_() + 0.5), (double)((double)pos.m_123342_() + 0.3), (double)((double)pos.m_123343_() + 0.5), (double)((double)direction.m_122429_() * 0.15), (double)0.05, (double)((double)direction.m_122431_() * 0.15));
        this.removeServing(level, pos, state);
        level.m_5594_(null, pos, SoundEvents.f_12639_, SoundSource.PLAYERS, 0.8f, 0.8f);
        return InteractionResult.SUCCESS;
    }

    protected InteractionResult consumeServing(Level level, BlockPos pos, BlockState state, Player playerIn) {
        if (!playerIn.m_36391_(false)) {
            return InteractionResult.PASS;
        }
        ItemStack servingStack = this.getServingItem();
        FoodProperties foodProperties = servingStack.getFoodProperties((LivingEntity)playerIn);
        if (foodProperties != null) {
            playerIn.m_36324_().m_38707_(foodProperties.m_38744_(), foodProperties.m_38745_());
            for (Pair pair : foodProperties.m_38749_()) {
                if (level.f_46443_ || pair.getFirst() == null || !(level.f_46441_.m_188501_() < ((Float)pair.getSecond()).floatValue())) continue;
                playerIn.m_7292_(new MobEffectInstance((MobEffectInstance)pair.getFirst()));
            }
        }
        this.removeServing(level, pos, state);
        level.m_5594_(null, pos, SoundEvents.f_11912_, SoundSource.PLAYERS, 0.8f, 0.8f);
        return InteractionResult.SUCCESS;
    }

    private void removeServing(Level level, BlockPos pos, BlockState state) {
        int servingsTaken = (Integer)state.m_61143_((Property)SERVINGS);
        if (servingsTaken < MAX_SERVINGS - 1) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)SERVINGS, (Comparable)Integer.valueOf(servingsTaken + 1)), MAX_SERVINGS - 1);
        } else {
            level.m_46961_(pos, true);
        }
    }

    public ItemStack getServingItem() {
        return new ItemStack((ItemLike)this.servingItem.get());
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return PANCAKES_SHAPES[(Integer)state.m_61143_((Property)SERVINGS)];
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_());
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.DOWN && !stateIn.m_60710_((LevelReader)level, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, level, currentPos, facingPos);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return level.m_8055_(pos.m_7495_()).m_280296_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, SERVINGS});
    }

    public int m_6782_(BlockState blockState, Level level, BlockPos pos) {
        return (Integer)blockState.m_61143_((Property)SERVINGS);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }
}

