/*
 * Decompiled with CFR 0.152.
 */
package com.phantomwing.rusticdelight.world;

import com.phantomwing.rusticdelight.tags.ModTags;
import com.phantomwing.rusticdelight.world.ModPlacedFeatures;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.registries.ForgeRegistries;

public class ModBiomeModifiers {
    public static final ResourceKey<BiomeModifier> ADD_WILD_COTTON = ModBiomeModifiers.registerKey("add_wild_cotton");
    public static final ResourceKey<BiomeModifier> ADD_WILD_BELL_PEPPERS = ModBiomeModifiers.registerKey("add_wild_bell_peppers");
    public static final ResourceKey<BiomeModifier> ADD_WILD_COFFEE = ModBiomeModifiers.registerKey("add_wild_coffee");

    public static void bootstrap(BootstapContext<BiomeModifier> context) {
        ModBiomeModifiers.registerFlowers(context);
    }

    private static void registerFlowers(BootstapContext<BiomeModifier> context) {
        HolderGetter placedFeatures = context.m_255420_(Registries.f_256988_);
        HolderGetter biomes = context.m_255420_(Registries.f_256952_);
        ModBiomeModifiers.registerWithBiomeFilter(context, (HolderGetter<PlacedFeature>)placedFeatures, (HolderGetter<Biome>)biomes, ADD_WILD_COTTON, ModPlacedFeatures.WILD_COTTON_PLACED_KEY, ModTags.Biomes.HAS_WILD_COTTON);
        ModBiomeModifiers.registerWithBiomeFilter(context, (HolderGetter<PlacedFeature>)placedFeatures, (HolderGetter<Biome>)biomes, ADD_WILD_BELL_PEPPERS, ModPlacedFeatures.WILD_BELL_PEPPERS_PLACED_KEY, ModTags.Biomes.HAS_WILD_BELL_PEPPERS);
        ModBiomeModifiers.registerWithBiomeFilter(context, (HolderGetter<PlacedFeature>)placedFeatures, (HolderGetter<Biome>)biomes, ADD_WILD_COFFEE, ModPlacedFeatures.WILD_COFFEE_PLACED_KEY, ModTags.Biomes.HAS_WILD_COFFEE);
    }

    private static void registerWithBiomeFilter(BootstapContext<BiomeModifier> context, HolderGetter<PlacedFeature> placedFeatures, HolderGetter<Biome> biomes, ResourceKey<BiomeModifier> biomeModifierKey, ResourceKey<PlacedFeature> placedFeatureKey, TagKey<Biome> biomeTag) {
        context.m_255272_(biomeModifierKey, (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.m_254956_(biomeTag), (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{placedFeatures.m_255043_(placedFeatureKey)}), GenerationStep.Decoration.VEGETAL_DECORATION));
    }

    private static ResourceKey<BiomeModifier> registerKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)new ResourceLocation("rusticdelight", name));
    }
}

