/*
 * Decompiled with CFR 0.152.
 */
package com.phantomwing.rusticdelight.world;

import com.phantomwing.rusticdelight.block.ModBlocks;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;

public class ModConfiguredFeatures {
    public static ResourceKey<ConfiguredFeature<?, ?>> WILD_COTTON_KEY = ModConfiguredFeatures.registerKey("wild_cotton");
    public static ResourceKey<ConfiguredFeature<?, ?>> WILD_BELL_PEPPERS_KEY = ModConfiguredFeatures.registerKey("wild_bell_peppers");
    public static ResourceKey<ConfiguredFeature<?, ?>> WILD_COFFEE_KEY = ModConfiguredFeatures.registerKey("wild_coffee");

    public static void bootstrap(BootstapContext<ConfiguredFeature<?, ?>> context) {
        ModConfiguredFeatures.registerFlowers(context);
    }

    private static void registerFlowers(BootstapContext<ConfiguredFeature<?, ?>> context) {
        ModConfiguredFeatures.registerFlowerPatch(context, WILD_COTTON_KEY, (Block)ModBlocks.WILD_COTTON.get(), 32, 6, 4);
        ModConfiguredFeatures.registerFlowerPatch(context, WILD_BELL_PEPPERS_KEY, (Block)ModBlocks.WILD_BELL_PEPPERS.get(), 48, 4, 4);
        ModConfiguredFeatures.registerFlowerPatch(context, WILD_COFFEE_KEY, (Block)ModBlocks.WILD_COFFEE.get(), 48, 6, 4);
    }

    private static void registerFlowerPatch(BootstapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, Block block, int tries, int xzSpread, int ySpread) {
        ModConfiguredFeatures.register(context, key, Feature.f_65761_, new RandomPatchConfiguration(tries, xzSpread, ySpread, PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)block)))));
    }

    private static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)new ResourceLocation("rusticdelight", name));
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC configuration) {
        context.m_255272_(key, (Object)new ConfiguredFeature(feature, configuration));
    }
}

