/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.backpack;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.server.ServerLifecycleHooks;

public class BackpackTemplateStorage
extends SavedData {
    private static final String SAVED_DATA_NAME = "sophisticatedbackpacks_backpack_templates";
    private static final BackpackTemplateStorage clientStorageCopy = new BackpackTemplateStorage();
    private final Map<ResourceLocation, CompoundTag> backpackTemplates = new HashMap<ResourceLocation, CompoundTag>();

    private BackpackTemplateStorage() {
    }

    public static BackpackTemplateStorage get() {
        MinecraftServer server;
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER && (server = ServerLifecycleHooks.getCurrentServer()) != null) {
            ServerLevel overworld = server.m_129880_(Level.f_46428_);
            DimensionDataStorage storage = overworld.m_8895_();
            return (BackpackTemplateStorage)storage.m_164861_(BackpackTemplateStorage::load, BackpackTemplateStorage::new, SAVED_DATA_NAME);
        }
        return clientStorageCopy;
    }

    public static BackpackTemplateStorage load(CompoundTag nbt) {
        BackpackTemplateStorage storage = new BackpackTemplateStorage();
        BackpackTemplateStorage.readBackpackTemplates(nbt, storage);
        return storage;
    }

    private static void readBackpackTemplates(CompoundTag nbt, BackpackTemplateStorage storage) {
        if (!nbt.m_128441_("backpackTemplates")) {
            return;
        }
        ListTag list = nbt.m_128437_("backpackTemplates", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag tag = list.m_128728_(i);
            ResourceLocation templateName = new ResourceLocation(tag.m_128461_("templateName"));
            CompoundTag contents = tag.m_128469_("contents");
            storage.backpackTemplates.put(templateName, contents);
        }
    }

    public CompoundTag m_7176_(CompoundTag compound) {
        CompoundTag ret = new CompoundTag();
        this.writeBackpackTemplates(ret);
        return ret;
    }

    private void writeBackpackTemplates(CompoundTag ret) {
        if (this.backpackTemplates.isEmpty()) {
            return;
        }
        ListTag backpackTemplatesNbt = new ListTag();
        for (Map.Entry<ResourceLocation, CompoundTag> entry : this.backpackTemplates.entrySet()) {
            CompoundTag ret1 = new CompoundTag();
            ret1.m_128359_("templateName", entry.getKey().toString());
            ret1.m_128365_("contents", (Tag)entry.getValue());
            backpackTemplatesNbt.add((Object)ret1);
        }
        ret.m_128365_("backpackTemplates", (Tag)backpackTemplatesNbt);
    }

    public Optional<CompoundTag> getBackpackTemplate(ResourceLocation templateName) {
        return Optional.ofNullable(this.backpackTemplates.get(templateName));
    }

    public void setBackpackTemplate(ResourceLocation templateName, CompoundTag contents) {
        this.backpackTemplates.put(templateName, contents);
        this.m_77762_();
    }

    public void removeBackpackTemplate(ResourceLocation templateName) {
        this.backpackTemplates.remove(templateName);
        this.m_77762_();
    }

    public Map<ResourceLocation, CompoundTag> getBackpackTemplates() {
        return this.backpackTemplates;
    }
}

