/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.inception;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.inception.InventoryOrder;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.inception.SubBackpacksHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.IInsertBlockOverride;
import net.p3pp3rf1y.sophisticatedcore.inventory.IItemHandlerSimpleInserter;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;

public class InceptionInventoryHandler
implements ITrackedContentsItemHandler {
    private IItemHandlerModifiable combinedInventories;
    private final ITrackedContentsItemHandler wrappedInventoryHandler;
    private final InventoryOrder inventoryOrder;
    private final SubBackpacksHandler subBackpacksHandler;
    private List<ITrackedContentsItemHandler> handlers;

    public InceptionInventoryHandler(ITrackedContentsItemHandler wrappedInventoryHandler, InventoryOrder inventoryOrder, SubBackpacksHandler subBackpacksHandler) {
        this.wrappedInventoryHandler = wrappedInventoryHandler;
        this.inventoryOrder = inventoryOrder;
        this.subBackpacksHandler = subBackpacksHandler;
        subBackpacksHandler.addRefreshListener(sbs -> this.refreshHandlerDelegate());
        this.refreshHandlerDelegate();
    }

    private void refreshHandlerDelegate() {
        this.handlers = new ArrayList<ITrackedContentsItemHandler>();
        if (this.inventoryOrder == InventoryOrder.MAIN_FIRST) {
            this.handlers.add(this.wrappedInventoryHandler);
        }
        this.subBackpacksHandler.getSubBackpacks().forEach(sbp -> this.handlers.add(sbp.getInventoryForInputOutput()));
        if (this.inventoryOrder == InventoryOrder.INCEPTED_FIRST) {
            this.handlers.add(this.wrappedInventoryHandler);
        }
        this.combinedInventories = new CombinedInvWrapper(this.handlers.toArray(new IItemHandlerModifiable[0])){

            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                ITrackedContentsItemHandler handler;
                ItemStack remaining = stack;
                Iterator<ITrackedContentsItemHandler> iterator = InceptionInventoryHandler.this.handlers.iterator();
                while (iterator.hasNext() && !(remaining = (handler = iterator.next()).insertItem(remaining, simulate)).m_41619_()) {
                }
                return remaining;
            }
        };
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.combinedInventories.setStackInSlot(slot, stack);
    }

    public int getSlots() {
        return this.combinedInventories.getSlots();
    }

    public ItemStack getStackInSlot(int slot) {
        return this.combinedInventories.getStackInSlot(slot);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        return this.combinedInventories.insertItem(slot, stack, simulate);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.combinedInventories.extractItem(slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return this.combinedInventories.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return this.combinedInventories.isItemValid(slot, stack);
    }

    public ItemStack insertItem(ItemStack stack, boolean simulate) {
        IItemHandlerSimpleInserter handler;
        ItemStack remainingStack = stack;
        Iterator<ITrackedContentsItemHandler> iterator = this.handlers.iterator();
        while (iterator.hasNext() && !(remainingStack = (handler = (IItemHandlerSimpleInserter)iterator.next()).insertItem(remainingStack, simulate)).m_41619_()) {
        }
        return remainingStack;
    }

    public Set<ItemStackKey> getTrackedStacks() {
        HashSet<ItemStackKey> ret = new HashSet<ItemStackKey>();
        this.handlers.forEach(h -> ret.addAll(h.getTrackedStacks()));
        return ret;
    }

    public void registerTrackingListeners(Consumer<ItemStackKey> onAddStackKey, Consumer<ItemStackKey> onRemoveStackKey, Runnable onAddFirstEmptySlot, Runnable onRemoveLastEmptySlot) {
        this.handlers.forEach(h -> h.registerTrackingListeners(onAddStackKey, onRemoveStackKey, onAddFirstEmptySlot, onRemoveLastEmptySlot));
    }

    public void unregisterStackKeyListeners() {
        this.handlers.forEach(ITrackedContentsItemHandler::unregisterStackKeyListeners);
    }

    public boolean hasEmptySlots() {
        return this.handlers.stream().anyMatch(ITrackedContentsItemHandler::hasEmptySlots);
    }

    public boolean isInsertBlocked() {
        return this.handlers.stream().allMatch(IInsertBlockOverride::isInsertBlocked);
    }

    public ItemStack extractItem(ItemStack stack, boolean simulate) {
        ItemStack remaining = stack;
        for (ITrackedContentsItemHandler handler : this.handlers) {
            ItemStack extracted = handler.extractItem(remaining, simulate);
            if (extracted.m_41613_() > 0) {
                remaining = stack.m_255036_(remaining.m_41613_() - extracted.m_41613_());
            }
            if (!remaining.m_41619_()) continue;
            break;
        }
        return stack.m_41613_() == remaining.m_41613_() ? ItemStack.f_41583_ : stack.m_255036_(stack.m_41613_() - remaining.m_41613_());
    }
}

