/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.structurize.management.Manager;
import com.ldtteam.structurize.network.messages.IMessage;
import com.ldtteam.structurize.operations.RemoveEntityOperation;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class RemoveEntityMessage
implements IMessage {
    private final BlockPos from;
    private final BlockPos to;
    private final ResourceLocation entityName;

    public RemoveEntityMessage(FriendlyByteBuf buf) {
        this.from = buf.m_130135_();
        this.to = buf.m_130135_();
        this.entityName = buf.m_130281_();
    }

    public RemoveEntityMessage(BlockPos pos1, BlockPos pos2, ResourceLocation entityName) {
        this.from = pos1;
        this.to = pos2;
        this.entityName = entityName;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.from);
        buf.m_130064_(this.to);
        buf.m_130085_(this.entityName);
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.SERVER;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        if (!ctxIn.getSender().m_7500_()) {
            return;
        }
        EntityType type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(this.entityName);
        if (type != null) {
            Manager.addToQueue(new RemoveEntityOperation((Player)ctxIn.getSender(), this.from, this.to, type));
        }
    }
}

