/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.storage.rendering.types;

import com.ldtteam.structurize.Network;
import com.ldtteam.structurize.Structurize;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.client.RenderingCacheKey;
import com.ldtteam.structurize.network.messages.SyncPreviewCacheToServer;
import com.ldtteam.structurize.storage.StructurePacks;
import com.ldtteam.structurize.util.PlacementSettings;
import com.ldtteam.structurize.util.RotationMirror;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class BlueprintPreviewData {
    private RotationMirror rotationMirror = RotationMirror.NONE;
    @Nullable
    private BlockPos pos;
    private int groundOffset = 0;
    @Nullable
    private Future<Blueprint> blueprintFuture;
    @Nullable
    private Blueprint blueprint;
    private String blueprintPath = "";
    private String packName = "";
    private RenderingCacheKey renderKey;
    private final boolean serverSyncEnabled;
    private float overridePreviewTransparency = -1.0f;
    private boolean renderBlocksNice;
    private BlockState solidSubstitutionOverride;

    public BlueprintPreviewData() {
        this(true);
    }

    public BlueprintPreviewData(boolean serverSyncEnabled) {
        this.renderBlocksNice = Structurize.getConfig().getClient() != null && (Boolean)Structurize.getConfig().getClient().renderPlaceholdersNice.get() != false;
        this.solidSubstitutionOverride = null;
        this.serverSyncEnabled = serverSyncEnabled;
    }

    public BlueprintPreviewData(FriendlyByteBuf byteBuf) {
        this(byteBuf, true);
    }

    public BlueprintPreviewData(FriendlyByteBuf byteBuf, boolean serverSyncEnabled) {
        this.renderBlocksNice = Structurize.getConfig().getClient() != null && (Boolean)Structurize.getConfig().getClient().renderPlaceholdersNice.get() != false;
        this.solidSubstitutionOverride = null;
        this.serverSyncEnabled = serverSyncEnabled;
        this.pos = byteBuf.m_130135_();
        this.packName = byteBuf.m_130136_(Short.MAX_VALUE);
        this.blueprintPath = byteBuf.m_130136_(Short.MAX_VALUE);
        this.blueprintFuture = StructurePacks.hasPack(this.packName) ? StructurePacks.getBlueprintFuture(this.packName, this.blueprintPath) : null;
        this.rotationMirror = RotationMirror.values()[byteBuf.readByte()];
    }

    public void writeToBuf(FriendlyByteBuf byteBuf) {
        byteBuf.m_130064_(this.pos == null ? BlockPos.f_121853_ : this.pos);
        if (this.blueprint == null) {
            byteBuf.m_130070_(this.packName);
            byteBuf.m_130070_(this.blueprintPath);
        } else {
            byteBuf.m_130070_(StructurePacks.selectedPack.getName());
            byteBuf.m_130070_(StructurePacks.selectedPack.getSubPath(this.blueprint.getFilePath().resolve(this.blueprint.getFileName() + ".blueprint")));
        }
        byteBuf.writeByte(this.rotationMirror.ordinal());
    }

    public void setBlueprintFuture(Future<Blueprint> blueprintFuture) {
        this.blueprintFuture = blueprintFuture;
    }

    public void setGroundOffset(int offset) {
        this.pos = this.pos.m_6625_(this.groundOffset);
        this.groundOffset = offset;
        this.pos = this.pos.m_6630_(this.groundOffset);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Blueprint getBlueprint() {
        if (this.pos == null) {
            return null;
        }
        if (this.blueprintFuture != null && this.blueprintFuture.isDone()) {
            try {
                if (this.blueprintFuture.get() != null) {
                    this.setBlueprint(this.blueprintFuture.get());
                    this.blueprintFuture = null;
                }
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        }
        return this.blueprint;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setBlueprint(Blueprint blueprint) {
        this.blueprintFuture = null;
        if (blueprint == null) {
            this.blueprint = null;
        } else if (!blueprint.equals(this.blueprint)) {
            this.blueprint = blueprint;
            this.applyRotationMirrorAndSync();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void mirror() {
        this.rotationMirror = this.rotationMirror.mirrorate();
        this.applyRotationMirrorAndSync();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void rotate(Rotation rotation) {
        this.rotationMirror = this.rotationMirror.rotate(rotation);
        this.applyRotationMirrorAndSync();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setRotationMirror(RotationMirror rotationMirror) {
        this.rotationMirror = rotationMirror;
        this.applyRotationMirrorAndSync();
    }

    public void syncChangesToServer() {
        if (this.serverSyncEnabled && ((Boolean)Structurize.getConfig().getClient().sharePreviews.get()).booleanValue() && (this.blueprint == null || this.blueprint.getName() != null)) {
            Network.getNetwork().sendToServer(new SyncPreviewCacheToServer(this));
        }
    }

    public void move(BlockPos offset) {
        if (this.pos != null) {
            this.setPos(this.pos.m_121955_((Vec3i)offset));
        }
    }

    @Deprecated(since="1.20", forRemoval=true)
    public boolean shouldRefresh() {
        return false;
    }

    @Deprecated(since="1.20", forRemoval=true)
    public void scheduleRefresh() {
        this.syncChangesToServer();
    }

    @Deprecated(since="1.20", forRemoval=true)
    public PlacementSettings getPlacementSettings() {
        return new PlacementSettings(this.rotationMirror.mirror(), this.rotationMirror.rotation());
    }

    public boolean isEmpty() {
        return this.blueprintFuture == null && this.blueprint == null;
    }

    @Deprecated(since="1.20", forRemoval=true)
    public Rotation getRotation() {
        return this.rotationMirror.rotation();
    }

    @Deprecated(since="1.20", forRemoval=true)
    public Mirror getMirror() {
        return this.rotationMirror.mirror();
    }

    public RotationMirror getRotationMirror() {
        return this.rotationMirror;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public void setPos(BlockPos pos) {
        this.pos = pos;
        if (pos != null) {
            this.syncChangesToServer();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void applyRotationMirrorAndSync() {
        if (this.blueprint == null) {
            return;
        }
        this.blueprint.setRotationMirror(this.rotationMirror, (Level)Minecraft.m_91087_().f_91073_);
        this.renderKey = new RenderingCacheKey(this.rotationMirror, this.blueprint);
        this.syncChangesToServer();
    }

    public RenderingCacheKey getRenderKey() {
        if (this.blueprintFuture != null) {
            this.getBlueprint();
        }
        return this.renderKey;
    }

    public boolean isServerSyncEnabled() {
        return this.serverSyncEnabled;
    }

    public void setRenderBlocksNice(boolean renderNice) {
        this.renderBlocksNice = renderNice;
    }

    public boolean getRenderBlocksNice() {
        return this.renderBlocksNice;
    }

    public void setOverridePreviewTransparency(float overridePreviewTransparency) {
        this.overridePreviewTransparency = Mth.m_14036_((float)overridePreviewTransparency, (float)-1.0f, (float)1.0f);
    }

    public float getOverridePreviewTransparency() {
        return this.overridePreviewTransparency;
    }

    public BlockState getSolidSubstitutionOverride() {
        return this.solidSubstitutionOverride;
    }

    public void setSolidSubstitutionOverride(BlockState solidSubstitutionOverride) {
        this.solidSubstitutionOverride = solidSubstitutionOverride;
    }
}

