/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.util;

import com.ldtteam.structurize.blocks.ModBlocks;
import com.ldtteam.structurize.blocks.schematic.BlockSubstitution;
import com.ldtteam.structurize.util.ChangeStorage;
import com.ldtteam.structurize.util.ITickedWorldOperation;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlacerholderFillOperation
implements ITickedWorldOperation {
    private BlockPos startPos;
    private BlockPos currentPos;
    private final BlockPos endPos;
    private final double yStretch;
    private final double circleRadiusMult;
    private final int heightOffset;
    private final int minDistToBlocks;
    private final ChangeStorage storage;

    public PlacerholderFillOperation(BlockPos startPos, BlockPos endPos, @Nullable Player player, double yStretch, double circleRadiusMult, int heightOffset, int minDistToBlocks) {
        this.startPos = new BlockPos(Math.min(startPos.m_123341_(), endPos.m_123341_()), Math.min(startPos.m_123342_(), endPos.m_123342_()), Math.min(startPos.m_123343_(), endPos.m_123343_()));
        this.currentPos = new BlockPos(Math.min(startPos.m_123341_(), endPos.m_123341_()), Math.min(startPos.m_123342_(), endPos.m_123342_()), Math.min(startPos.m_123343_(), endPos.m_123343_()));
        this.yStretch = yStretch;
        this.circleRadiusMult = circleRadiusMult;
        this.heightOffset = heightOffset;
        this.minDistToBlocks = minDistToBlocks;
        this.endPos = new BlockPos(Math.max(startPos.m_123341_(), endPos.m_123341_()), Math.max(startPos.m_123342_(), endPos.m_123342_()), Math.max(startPos.m_123343_(), endPos.m_123343_()));
        this.storage = new ChangeStorage((Component)Component.m_237113_((String)"FILL_TOP_PLACEHOLDERS"), player != null ? player.m_20148_() : UUID.randomUUID());
    }

    @Override
    public boolean apply(ServerLevel world) {
        this.fillSchematicTopWithPlaceholders(world, this.yStretch, this.circleRadiusMult, this.heightOffset, this.minDistToBlocks);
        return true;
    }

    @Override
    @NotNull
    public ChangeStorage getChangeStorage() {
        return this.storage;
    }

    private void fillSchematicTopWithPlaceholders(ServerLevel world, double yStretch, double circleRadiusMult, int heightOffset, int minDistToBlocks) {
        for (int x = this.startPos.m_123341_(); x <= this.endPos.m_123341_(); ++x) {
            for (int z = this.startPos.m_123343_(); z <= this.endPos.m_123343_(); ++z) {
                BlockPos current;
                for (int y = this.endPos.m_123342_(); y > this.startPos.m_123342_() && this.checkDistance(current = new BlockPos(x, y, z), this.startPos, this.endPos, yStretch, circleRadiusMult, heightOffset) && this.checkSurroundingBlocks((Level)world, current, minDistToBlocks); --y) {
                    this.storage.addPreviousDataFor(current, (Level)world);
                    world.m_7731_(current, ((BlockSubstitution)((Object)ModBlocks.blockSubstitution.get())).m_49966_(), 3);
                    this.storage.addPostDataFor(current, (Level)world);
                }
            }
        }
    }

    private boolean checkDistance(BlockPos comparedPos, BlockPos corner1, BlockPos corner2, double yStretch, double circleRadiusMult, int heightOffset) {
        double zDiff;
        double yDiff;
        BlockPos center = corner1.m_121955_((Vec3i)corner2);
        center = new BlockPos(center.m_123341_() / 2, (int)((double)(center.m_123342_() / 2) + (double)Math.abs(corner1.m_123342_() - corner2.m_123342_()) * 0.1) + heightOffset, center.m_123343_() / 2);
        if (comparedPos.m_123342_() < center.m_123342_()) {
            return false;
        }
        int xLength = Math.abs(corner1.m_123341_() - corner2.m_123341_());
        int zLength = Math.abs(corner1.m_123343_() - corner2.m_123343_());
        double xDiff = (double)comparedPos.m_123341_() + 0.5 - (double)center.m_123341_();
        return !(Math.sqrt(xDiff * xDiff * ((double)zLength / (double)xLength) + (yDiff = (double)comparedPos.m_123342_() + 0.5 - (double)center.m_123342_()) * yDiff * 2.0 * yStretch + (zDiff = (double)comparedPos.m_123343_() + 0.5 - (double)center.m_123343_()) * zDiff * ((double)xLength / (double)zLength)) < (double)Math.min(xLength, zLength) * 0.4 * circleRadiusMult);
    }

    private boolean checkSurroundingBlocks(Level level, BlockPos checkPos, int minDistToBlocks) {
        if (minDistToBlocks <= 0) {
            return true;
        }
        for (int x = -minDistToBlocks; x <= minDistToBlocks; ++x) {
            for (int y = -minDistToBlocks; y <= minDistToBlocks; ++y) {
                for (int z = -minDistToBlocks; z <= minDistToBlocks; ++z) {
                    BlockState state = level.m_8055_(checkPos.m_7918_(x, y, z));
                    if (state.m_60795_() || state.m_60734_() == ModBlocks.blockSubstitution.get()) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

