/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.client.gui;

import com.google.common.collect.Lists;
import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.controls.AbstractTextBuilder;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.Image;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.controls.TextField;
import com.ldtteam.blockui.util.resloc.OutOfJarResourceLocation;
import com.ldtteam.blockui.views.BOWindow;
import com.ldtteam.blockui.views.Box;
import com.ldtteam.blockui.views.ScrollingList;
import com.ldtteam.structurize.api.util.Log;
import com.ldtteam.structurize.api.util.constant.Constants;
import com.ldtteam.structurize.client.gui.AbstractWindowSkeleton;
import com.ldtteam.structurize.storage.StructurePackMeta;
import com.ldtteam.structurize.storage.StructurePacks;
import com.ldtteam.structurize.util.IOPool;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class WindowSwitchPack
extends AbstractWindowSkeleton {
    private static final String WINDOW_TAG_TOOL = ":gui/windowswitchpack.xml";
    private final Supplier<BOWindow> prevWindow;
    private final Predicate<StructurePackMeta> packPredicate;
    private final ScrollingList packList;
    private final List<DrawableComponent> drawableComponents = new ArrayList<DrawableComponent>();
    private List<StructurePackMeta> packMetas;
    private Future<List<StructurePackMeta>> packMetasFuture;

    public WindowSwitchPack(Supplier<BOWindow> prevWindow) {
        this(prevWindow, pack -> true);
    }

    public WindowSwitchPack(Supplier<BOWindow> prevWindow, Predicate<StructurePackMeta> packPredicate) {
        super("structurize:gui/windowswitchpack.xml");
        this.prevWindow = prevWindow;
        this.packPredicate = packPredicate;
        this.packList = (ScrollingList)this.findPaneOfTypeByID("packs", ScrollingList.class);
        this.registerButton("cancel", this::cancelClicked);
        ((TextField)this.findPaneOfTypeByID("filter", TextField.class)).setHandler(input -> this.sortAndFilterPacks(input.getText()));
        this.packList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return WindowSwitchPack.this.drawableComponents.size();
            }

            public void updateElement(int index, Pane rowPane) {
                ((Box)rowPane.findPaneOfTypeByID("box0", Box.class)).hide();
                ((Box)rowPane.findPaneOfTypeByID("box1", Box.class)).hide();
                ((Box)rowPane.findPaneOfTypeByID("box2", Box.class)).hide();
                WindowSwitchPack.this.drawableComponents.get(index).render(rowPane);
            }
        });
    }

    public void cancelClicked() {
        if (this.prevWindow == null) {
            this.close();
            return;
        }
        this.prevWindow.get().open();
    }

    public void onOpened() {
        super.onOpened();
        this.packMetas = Collections.emptyList();
        this.drawableComponents.clear();
        this.packMetasFuture = IOPool.submit(() -> {
            if (!StructurePacks.waitUntilFinishedLoading()) {
                return Collections.emptyList();
            }
            return new ArrayList<StructurePackMeta>(StructurePacks.getPackMetas().stream().filter(this.packPredicate).toList());
        });
    }

    public void onUpdate() {
        super.onUpdate();
        if (this.packMetasFuture != null && this.packMetasFuture.isDone()) {
            try {
                this.packMetas = this.packMetasFuture.get();
            }
            catch (InterruptedException | ExecutionException e) {
                Log.getLogger().error("Error resolving pack metas", (Throwable)e);
            }
            this.packMetasFuture = null;
            if (!this.packMetas.isEmpty()) {
                Collections.shuffle(this.packMetas, Constants.rand);
            }
            this.sortAndFilterPacks("");
            this.packList.on();
        }
    }

    private void sortAndFilterPacks(String filter) {
        TreeMap<String, List> categories = new TreeMap<String, List>();
        for (StructurePackMeta structurePackMeta : this.packMetas) {
            if (!StringUtils.isBlank((CharSequence)filter) && !StringUtils.containsIgnoreCase((CharSequence)structurePackMeta.getName(), (CharSequence)filter)) continue;
            categories.compute(structurePackMeta.getOwner(), (k, v) -> v == null ? new ArrayList() : v).add(structurePackMeta);
        }
        this.drawableComponents.clear();
        for (Map.Entry entry : categories.entrySet()) {
            this.drawableComponents.add(new CategoryDrawableComponent((String)entry.getKey()));
            for (List meta : Lists.partition((List)((List)entry.getValue()), (int)2)) {
                if (meta.size() == 2) {
                    this.drawableComponents.add(new PacksDrawableComponent(this.prevWindow, (StructurePackMeta)meta.get(0), (StructurePackMeta)meta.get(1)));
                    continue;
                }
                this.drawableComponents.add(new PacksDrawableComponent(this.prevWindow, (StructurePackMeta)meta.get(0), null));
            }
        }
        this.packList.refreshElementPanes(true);
    }

    private record CategoryDrawableComponent(String category) implements DrawableComponent
    {
        @Override
        public void render(Pane rowPane) {
            ((Box)rowPane.findPaneOfTypeByID("box0", Box.class)).show();
            ((Text)rowPane.findPaneOfTypeByID("category", Text.class)).setText(Component.m_237113_((String)StringUtils.capitalize((String)this.category)));
        }
    }

    private record PacksDrawableComponent(@NotNull Supplier<BOWindow> prevWindow, @NotNull StructurePackMeta first, @Nullable StructurePackMeta second) implements DrawableComponent
    {
        @Override
        public void render(Pane rowPane) {
            ((Box)rowPane.findPaneOfTypeByID("box1", Box.class)).show();
            this.fillForMeta(rowPane, this.first, "1");
            if (this.second != null) {
                ((Box)rowPane.findPaneOfTypeByID("box2", Box.class)).show();
                this.fillForMeta(rowPane, this.second, "2");
            }
        }

        private void fillForMeta(Pane rowPane, StructurePackMeta packMeta, String side) {
            ((Text)rowPane.findPaneOfTypeByID("name" + side, Text.class)).setText(Component.m_237113_((String)packMeta.getName()));
            ((Text)rowPane.findPaneOfTypeByID("desc" + side, Text.class)).setText(Component.m_237113_((String)packMeta.getDesc()));
            ((Text)rowPane.findPaneOfTypeByID("authors" + side, Text.class)).setText(Component.m_237110_((String)"com.ldtteam.structurize.gui.switchpack.authors", (Object[])new Object[]{String.join((CharSequence)", ", packMeta.getAuthors())}));
            if (!packMeta.getIconPath().isEmpty()) {
                ((Image)rowPane.findPaneOfTypeByID("icon" + side, Image.class)).setImage((ResourceLocation)OutOfJarResourceLocation.of((String)"structurize", (Path)packMeta.getPath().resolve(packMeta.getIconPath())), false);
            }
            Button selectButton = (Button)rowPane.findPaneOfTypeByID("select" + side, Button.class);
            selectButton.setEnabled(!packMeta.isDisabled());
            selectButton.setHandler(h -> {
                StructurePacks.switchSelectedPack(packMeta);
                this.prevWindow.get().open();
            });
            if (packMeta.isDisabled()) {
                MutableComponent configOptionComponent = Component.m_237113_((String)"allowPlayerSchematics").m_130940_(ChatFormatting.GOLD);
                ((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().append(Component.m_237110_((String)"com.ldtteam.structurize.gui.switchpack.pack_disabled.hover_text", (Object[])new Object[]{configOptionComponent}))).hoverPane((Pane)selectButton).build();
            }
        }
    }

    private static interface DrawableComponent {
        public void render(Pane var1);
    }
}

