/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.structurize.client.gui.util.ItemPositionsStorage;
import com.ldtteam.structurize.management.Manager;
import com.ldtteam.structurize.network.messages.IMessage;
import com.ldtteam.structurize.operations.RemoveBlockOperation;
import com.ldtteam.structurize.operations.RemoveFilteredOperation;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class RemoveBlockMessage
implements IMessage {
    private List<ItemPositionsStorage> toRemove = new ArrayList<ItemPositionsStorage>();

    public RemoveBlockMessage(FriendlyByteBuf buf) {
        int count = buf.readInt();
        for (int i = 0; i < count; ++i) {
            this.toRemove.add(new ItemPositionsStorage(buf));
        }
    }

    public RemoveBlockMessage(ItemPositionsStorage itemPositionsStorage) {
        this.toRemove = List.of(itemPositionsStorage);
    }

    public RemoveBlockMessage(List<ItemPositionsStorage> itemPositionsStorageList) {
        this.toRemove = itemPositionsStorageList;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.toRemove.size());
        for (ItemPositionsStorage positionsStorage : this.toRemove) {
            positionsStorage.serialize(buf);
        }
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.SERVER;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        if (!ctxIn.getSender().m_7500_()) {
            return;
        }
        if (this.toRemove.size() > 1) {
            Manager.addToQueue(new RemoveFilteredOperation(ctxIn.getSender(), this.toRemove));
            return;
        }
        if (!this.toRemove.isEmpty()) {
            Manager.addToQueue(new RemoveBlockOperation(ctxIn.getSender(), this.toRemove.get(0)));
        }
    }
}

