/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.structurize.client.gui.util.ItemPositionsStorage;
import com.ldtteam.structurize.management.Manager;
import com.ldtteam.structurize.network.messages.IMessage;
import com.ldtteam.structurize.operations.ReplaceBlockOperation;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class ReplaceBlockMessage
implements IMessage {
    private final ItemPositionsStorage toReplace;
    private final ItemStack blockTo;
    private final int pct;

    public ReplaceBlockMessage(FriendlyByteBuf buf) {
        this.blockTo = buf.m_130267_();
        this.pct = buf.readInt();
        this.toReplace = new ItemPositionsStorage(buf);
    }

    public ReplaceBlockMessage(ItemPositionsStorage toReplace, ItemStack blockTo, int pct) {
        this.toReplace = toReplace;
        this.blockTo = blockTo;
        this.pct = pct;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130055_(this.blockTo);
        buf.writeInt(this.pct);
        this.toReplace.serialize(buf);
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.SERVER;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        if (!ctxIn.getSender().m_7500_()) {
            return;
        }
        Manager.addToQueue(new ReplaceBlockOperation((Player)ctxIn.getSender(), this.toReplace, this.blockTo, this.pct));
    }
}

