/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.storage;

import com.ldtteam.structurize.Network;
import com.ldtteam.structurize.api.util.Log;
import com.ldtteam.structurize.network.messages.NotifyClientAboutStructurePacksMessage;
import com.ldtteam.structurize.network.messages.TransferStructurePackToClient;
import com.ldtteam.structurize.storage.StructurePackMeta;
import com.ldtteam.structurize.storage.StructurePacks;
import com.ldtteam.structurize.util.IOPool;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;
import org.jetbrains.annotations.NotNull;

public class ServerStructurePackLoader {
    private static ConcurrentLinkedQueue<PackagedPack> messageSendTasks = new ConcurrentLinkedQueue();
    private static Map<UUID, Map<String, Double>> clientSyncRequests = new HashMap<UUID, Map<String, Double>>();
    public static volatile ServerLoadingState loadingState = ServerLoadingState.UNINITIALIZED;

    public static void onServerStarting() {
        loadingState = ServerLoadingState.LOADING;
        ArrayList<Path> modPaths = new ArrayList<Path>();
        ArrayList<String> modList = new ArrayList<String>();
        for (IModInfo mod : ModList.get().getMods()) {
            modPaths.add(mod.getOwningFile().getFile().findResource(new String[]{"blueprints", mod.getModId()}));
            modList.add(mod.getModId());
        }
        Path gameFolder = new File(".").toPath();
        IOPool.execute(() -> {
            try {
                Stream<Path> paths;
                for (Path modPath : modPaths) {
                    try {
                        Stream<Path> paths2 = Files.list(modPath);
                        try {
                            paths2.forEach(element -> StructurePacks.discoverPackAtPath(element, true, modList, false, modPath.toString().split("/")[1]));
                        }
                        finally {
                            if (paths2 == null) continue;
                            paths2.close();
                        }
                    }
                    catch (IOException e) {
                        Log.getLogger().warn("Failed loading packs from mod path: " + modPath.toString());
                    }
                }
                try {
                    paths = Files.list(gameFolder.resolve("blueprints"));
                    try {
                        paths.forEach(element -> StructurePacks.discoverPackAtPath(element, false, modList, false, "Local"));
                    }
                    finally {
                        if (paths != null) {
                            paths.close();
                        }
                    }
                }
                catch (IOException e) {
                    Log.getLogger().warn("Failed loading packs from main folder path: " + String.valueOf(gameFolder));
                }
                try {
                    paths = Files.list(gameFolder.resolve("blueprints").resolve("clients"));
                    try {
                        paths.forEach(element -> {
                            try (Stream<Path> subPaths = Files.list(element);){
                                subPaths.forEach(subElement -> StructurePacks.discoverPackAtPath(subElement, false, modList, true, "Local"));
                            }
                            catch (IOException e) {
                                Log.getLogger().warn("Failed loading client pack from folder path: " + String.valueOf(element));
                            }
                        });
                    }
                    finally {
                        if (paths != null) {
                            paths.close();
                        }
                    }
                }
                catch (IOException e) {
                    Log.getLogger().warn("Failed loading client packs from main folder path: " + String.valueOf(gameFolder));
                }
                Log.getLogger().warn("Finished discovering Server Structure packs");
                for (StructurePackMeta pack : StructurePacks.getPackMetas()) {
                    if (pack.isImmutable()) continue;
                }
                loadingState = ServerLoadingState.FINISHED_LOADING;
            }
            catch (Throwable t) {
                Log.getLogger().error("schematic loading from disk failed, please report this on the mods issue tracker!", t);
            }
            finally {
                StructurePacks.setFinishedLoading();
            }
        });
    }

    public static void onClientSyncAttempt(Map<String, Double> clientStructurePacks, ServerPlayer player) {
        if (loadingState == ServerLoadingState.UNINITIALIZED) {
            Network.getNetwork().sendToPlayer(new NotifyClientAboutStructurePacksMessage(List.of()), player);
            return;
        }
        if (loadingState == ServerLoadingState.FINISHED_LOADING) {
            ServerStructurePackLoader.handleClientUpdate(clientStructurePacks, player);
        } else {
            clientSyncRequests.put(player.m_20148_(), clientStructurePacks);
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            if (event.getServer().m_129921_() % 20 == 0 && loadingState == ServerLoadingState.FINISHED_LOADING && !clientSyncRequests.isEmpty()) {
                loadingState = ServerLoadingState.FINISHED_SYNCING;
                for (Map.Entry<UUID, Map<String, Double>> entry : clientSyncRequests.entrySet()) {
                    ServerPlayer player = event.getServer().m_6846_().m_11259_(entry.getKey());
                    if (player == null) continue;
                    ServerStructurePackLoader.handleClientUpdate(entry.getValue(), player);
                }
                clientSyncRequests.clear();
            }
            if (!messageSendTasks.isEmpty()) {
                PackagedPack packData = messageSendTasks.poll();
                ServerPlayer player = event.getServer().m_6846_().m_11259_(packData.player);
                if (player != null) {
                    Network.getNetwork().sendToPlayer(new TransferStructurePackToClient(packData.structurePack, packData.buf, packData.eol), player);
                }
            }
        }
    }

    private static void handleClientUpdate(Map<String, Double> clientStructurePacks, ServerPlayer player) {
        Network.getNetwork().sendToPlayer(new NotifyClientAboutStructurePacksMessage(StructurePacks.getPackMetas()), player);
        UUID uuid = player.m_20148_();
        HashMap<String, StructurePackMeta> missingPacks = new HashMap<String, StructurePackMeta>();
        for (StructurePackMeta pack : StructurePacks.getPackMetas()) {
            if (pack.isImmutable() || clientStructurePacks.getOrDefault(pack.getName(), -1.0).doubleValue() == pack.getVersion()) continue;
            missingPacks.put(pack.getName(), pack);
        }
        IOPool.execute(() -> {
            int index = 1;
            for (StructurePackMeta pack : new ArrayList(missingPacks.values())) {
                ByteBuf outputBuf = ServerStructurePackLoader.zipPack(pack.getPath());
                if (outputBuf != null) {
                    messageSendTasks.add(new PackagedPack(pack.getName(), uuid, outputBuf, index == missingPacks.size()));
                }
                ++index;
            }
        });
    }

    private static ByteBuf zipPack(final Path sourcePath) {
        ByteBuf buffer = Unpooled.buffer();
        try (ByteBufOutputStream stream = new ByteBufOutputStream(buffer);){
            final ZipOutputStream zos = new ZipOutputStream((OutputStream)stream);
            Files.walkFileTree(sourcePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                @NotNull
                public FileVisitResult preVisitDirectory(@NotNull Path dir, @NotNull BasicFileAttributes attrs) throws IOException {
                    if (!sourcePath.equals(dir)) {
                        zos.putNextEntry(new ZipEntry(String.valueOf(sourcePath.relativize(dir)) + "/"));
                        zos.closeEntry();
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                @NotNull
                public FileVisitResult visitFile(@NotNull Path file, @NotNull BasicFileAttributes attrs) throws IOException {
                    zos.putNextEntry(new ZipEntry(sourcePath.relativize(file).toString()));
                    Files.copy(file, zos);
                    zos.closeEntry();
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            Log.getLogger().warn("Unable to ZIP up: {}", (Object)sourcePath);
            return null;
        }
        return buffer;
    }

    public static enum ServerLoadingState {
        UNINITIALIZED,
        LOADING,
        FINISHED_LOADING,
        FINISHED_SYNCING;

    }

    private static class PackagedPack {
        private final String structurePack;
        private final UUID player;
        private final ByteBuf buf;
        private final boolean eol;

        public PackagedPack(String structurePack, UUID player, ByteBuf buf, boolean eol) {
            this.structurePack = structurePack;
            this.player = player;
            this.buf = buf;
            this.eol = eol;
        }
    }
}

