/*
 * Decompiled with CFR 0.152.
 */
package org.syncfix;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.syncfix.optimization.OptimizationManager;

@Mod(value="sync_fix")
public class SyncFixMod {
    public static final String MOD_ID = "sync_fix";
    public static final Logger LOGGER = LogManager.getLogger();
    private static volatile OptimizationManager optimizationManager;
    private static final AtomicBoolean initialized;
    private static final ForkJoinPool asyncPool;

    public SyncFixMod() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void setup(FMLCommonSetupEvent event) {
        if (initialized.compareAndSet(false, true)) {
            CompletableFuture.runAsync(() -> {
                try {
                    optimizationManager = new OptimizationManager();
                    optimizationManager.initialize();
                    LOGGER.info("SyncFix revolutionary optimization system initialized with {} threads", (Object)asyncPool.getParallelism());
                }
                catch (Exception e) {
                    LOGGER.error("Failed to initialize optimization system", (Throwable)e);
                    initialized.set(false);
                }
            }, asyncPool);
        }
    }

    public static OptimizationManager getOptimizationManager() {
        return optimizationManager;
    }

    public static ForkJoinPool getAsyncPool() {
        return asyncPool;
    }

    public static boolean isInitialized() {
        return initialized.get() && optimizationManager != null;
    }

    static {
        initialized = new AtomicBoolean(false);
        asyncPool = new ForkJoinPool(Math.max(2, Runtime.getRuntime().availableProcessors() / 4), ForkJoinPool.defaultForkJoinWorkerThreadFactory, null, true);
    }
}

