/*
 * Decompiled with CFR 0.152.
 */
package org.syncfix.optimization;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class EntityData {
    private static final double MOVEMENT_THRESHOLD = 0.0625;
    private static final double ROTATION_THRESHOLD = 2.8125;
    private static final int PREDICTION_WINDOW = 8;
    private static final long STALE_DATA_THRESHOLD = 30000L;
    private final AtomicReference<Vec3> lastPosition = new AtomicReference<Vec3>(Vec3.f_82478_);
    private final AtomicReference<Vec3> velocity = new AtomicReference<Vec3>(Vec3.f_82478_);
    private final AtomicReference<Vec3> acceleration = new AtomicReference<Vec3>(Vec3.f_82478_);
    private final AtomicInteger ticksSinceMovement = new AtomicInteger(0);
    private final AtomicInteger ticksSinceSync = new AtomicInteger(0);
    private final AtomicLong lastUpdateTime = new AtomicLong(0L);
    private final AtomicReference<float[]> rotationHistory = new AtomicReference<float[]>(new float[16]);
    private final AtomicReference<Vec3[]> positionHistory = new AtomicReference<Vec3[]>(new Vec3[8]);
    private final AtomicInteger historyIndex = new AtomicInteger(0);
    private volatile float lastYRot;
    private volatile float lastXRot;
    private volatile double movementVariance = 0.0;
    private volatile boolean isStationary = false;
    private volatile int optimizationLevel = 0;

    public EntityData() {
        Vec3[] positions = new Vec3[8];
        for (int i = 0; i < 8; ++i) {
            positions[i] = Vec3.f_82478_;
        }
        this.positionHistory.set(positions);
    }

    public void update(Entity entity) {
        long currentTime = System.nanoTime();
        Vec3 currentPos = entity.m_20182_();
        Vec3 prevPos = this.lastPosition.get();
        this.updatePositionHistory(currentPos);
        this.updateVelocityAndAcceleration(currentPos, prevPos, currentTime);
        this.updateRotationHistory(entity.m_146908_(), entity.m_146909_());
        boolean hasMoved = this.calculateMovement(currentPos, prevPos);
        if (hasMoved) {
            this.ticksSinceMovement.set(0);
            this.isStationary = false;
            this.optimizationLevel = Math.max(0, this.optimizationLevel - 1);
        } else {
            int stillTicks = this.ticksSinceMovement.incrementAndGet();
            if (stillTicks > 100) {
                this.isStationary = true;
                this.optimizationLevel = Math.min(5, this.optimizationLevel + 1);
            }
        }
        this.ticksSinceSync.incrementAndGet();
        this.lastPosition.set(currentPos);
        this.lastYRot = entity.m_146908_();
        this.lastXRot = entity.m_146909_();
        this.lastUpdateTime.set(currentTime);
        this.calculateMovementVariance();
    }

    private void updatePositionHistory(Vec3 position) {
        Vec3[] history = this.positionHistory.get();
        int index = this.historyIndex.getAndIncrement() % 8;
        history[index] = position;
    }

    private void updateVelocityAndAcceleration(Vec3 currentPos, Vec3 prevPos, long currentTime) {
        if (!prevPos.equals((Object)Vec3.f_82478_)) {
            Vec3 newVelocity = currentPos.m_82546_(prevPos);
            Vec3 oldVelocity = this.velocity.get();
            Vec3 newAcceleration = newVelocity.m_82546_(oldVelocity);
            this.velocity.set(newVelocity);
            this.acceleration.set(newAcceleration);
        }
    }

    private void updateRotationHistory(float yRot, float xRot) {
        float[] rotHistory = this.rotationHistory.get();
        int baseIndex = this.historyIndex.get() % 8 * 2;
        rotHistory[baseIndex] = yRot;
        rotHistory[baseIndex + 1] = xRot;
    }

    private boolean calculateMovement(Vec3 current, Vec3 previous) {
        if (previous.equals((Object)Vec3.f_82478_)) {
            return false;
        }
        double distanceSq = current.m_82557_(previous);
        return distanceSq > 0.00390625;
    }

    private void calculateMovementVariance() {
        Vec3[] history = this.positionHistory.get();
        double totalDistance = 0.0;
        int validSamples = 0;
        for (int i = 1; i < 8; ++i) {
            if (history[i].equals((Object)Vec3.f_82478_) || history[i - 1].equals((Object)Vec3.f_82478_)) continue;
            totalDistance += history[i].m_82554_(history[i - 1]);
            ++validSamples;
        }
        this.movementVariance = validSamples > 0 ? totalDistance / (double)validSamples : 0.0;
    }

    public Vec3 predictNextPosition() {
        Vec3 currentPos = this.lastPosition.get();
        Vec3 currentVel = this.velocity.get();
        Vec3 currentAcc = this.acceleration.get();
        return currentPos.m_82549_(currentVel).m_82549_(currentAcc.m_82490_(0.5));
    }

    public boolean shouldOptimize() {
        return this.isStationary || this.optimizationLevel > 2 || System.nanoTime() - this.lastUpdateTime.get() > 30000000000L;
    }

    public int getOptimizationLevel() {
        return this.optimizationLevel;
    }

    public double getMovementVariance() {
        return this.movementVariance;
    }

    public boolean isStationary() {
        return this.isStationary;
    }

    public int getTicksSinceLastMovement() {
        return this.ticksSinceMovement.get();
    }

    public int getTicksSinceLastSync() {
        return this.ticksSinceSync.get();
    }

    public void resetSyncCounter() {
        this.ticksSinceSync.set(0);
    }

    public Vec3 getVelocity() {
        return this.velocity.get();
    }

    public Vec3 getAcceleration() {
        return this.acceleration.get();
    }

    public boolean isStale() {
        return System.nanoTime() - this.lastUpdateTime.get() > 30000000000L;
    }
}

