/*
 * Decompiled with CFR 0.152.
 */
package org.syncfix.optimization;

import java.util.List;
import java.util.Queue;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.syncfix.SyncFixMod;
import org.syncfix.optimization.EntityData;

public class EntitySynchronizer {
    private static final int SYNC_PREDICTION_DEPTH = 5;
    private static final double BEHAVIORAL_LEARNING_RATE = 0.02;
    private static final int MAX_CONCURRENT_SYNCS = 16;
    private static final double PROXIMITY_INFLUENCE_RADIUS = 256.0;
    private final ConcurrentHashMap<UUID, AdvancedSyncProfile> syncProfiles = new ConcurrentHashMap();
    private final ThreadPoolExecutor syncExecutor = new ThreadPoolExecutor(2, Math.max(4, Runtime.getRuntime().availableProcessors() / 3), 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(500), r -> {
        Thread t = new Thread(r, "SyncFix-Sync-" + System.nanoTime());
        t.setDaemon(true);
        t.setPriority(5);
        return t;
    });
    private final AtomicInteger activeSyncs = new AtomicInteger(0);
    private final AtomicLong totalSyncOperations = new AtomicLong(0L);
    private final AtomicReference<Double> averageSyncTime = new AtomicReference<Double>(0.0);
    private volatile boolean adaptiveMode = true;
    private volatile long lastOptimizationCycle = 0L;

    public void initialize() {
        this.syncExecutor.prestartAllCoreThreads();
        SyncFixMod.LOGGER.info("Advanced Entity Synchronizer initialized with {} sync threads", (Object)this.syncExecutor.getCorePoolSize());
    }

    public CompletableFuture<Void> optimizeEntityBehaviorAsync(Entity entity, EntityData data) {
        if (!(entity instanceof LivingEntity) || entity.m_9236_().f_46443_ || this.activeSyncs.get() > 16) {
            return CompletableFuture.completedFuture(null);
        }
        return CompletableFuture.runAsync(() -> {
            this.activeSyncs.incrementAndGet();
            long startTime = System.nanoTime();
            try {
                this.optimizeEntityBehavior(entity, data);
            }
            finally {
                this.activeSyncs.decrementAndGet();
                long duration = System.nanoTime() - startTime;
                this.updateSyncMetrics(duration);
            }
        }, this.syncExecutor);
    }

    public void optimizeEntityBehavior(Entity entity, EntityData data) {
        if (!(entity instanceof LivingEntity) || entity.m_9236_().f_46443_) {
            return;
        }
        UUID entityId = entity.m_20148_();
        AdvancedSyncProfile profile = this.syncProfiles.computeIfAbsent(entityId, k -> new AdvancedSyncProfile((LivingEntity)entity));
        ServerLevel level = (ServerLevel)entity.m_9236_();
        List<Player> nearbyPlayers = this.findInfluentialPlayers(level, entity.m_20182_());
        SyncDecision decision = profile.calculateOptimalSync((LivingEntity)entity, data, nearbyPlayers);
        this.applySyncDecision((LivingEntity)entity, decision, profile);
        profile.updateLearning(decision, nearbyPlayers.size());
    }

    private List<Player> findInfluentialPlayers(ServerLevel level, Vec3 position) {
        return level.m_6907_().stream().filter(player -> {
            double distance = player.m_20238_(position);
            return distance <= 65536.0;
        }).sorted((p1, p2) -> Double.compare(p1.m_20238_(position), p2.m_20238_(position))).limit(8L).collect(Collectors.toList());
    }

    private void applySyncDecision(LivingEntity entity, SyncDecision decision, AdvancedSyncProfile profile) {
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            this.applyMobOptimizations(mob, decision, profile);
        }
        this.applyMovementOptimizations(entity, decision);
        this.applyBehaviorOptimizations(entity, decision);
    }

    private void applyMobOptimizations(Mob mob, SyncDecision decision, AdvancedSyncProfile profile) {
        Brain brain = mob.m_6274_();
        if (brain == null) {
            return;
        }
        switch (decision.aiOptimizationLevel) {
            case 0: {
                if (mob.m_21525_()) {
                    mob.m_21557_(false);
                }
                profile.restoreFullCapabilities();
                break;
            }
            case 1: {
                profile.reduceAIFrequency(0.8);
                break;
            }
            case 2: {
                profile.reduceAIFrequency(0.5);
                if (!decision.shouldDisablePathfinding) break;
                mob.m_21573_().m_26573_();
                break;
            }
            case 3: {
                profile.reduceAIFrequency(0.2);
                mob.m_21573_().m_26573_();
                if (mob.m_21525_()) break;
                mob.m_21557_(true);
            }
        }
    }

    private void applyMovementOptimizations(LivingEntity entity, SyncDecision decision) {
        if (decision.shouldReduceMovement) {
            Vec3 currentMovement = entity.m_20184_();
            entity.m_20256_(currentMovement.m_82490_(decision.movementReductionFactor));
        }
        if (decision.shouldFreezePosition && entity.f_19797_ % decision.freezeInterval == 0) {
            entity.m_20256_(Vec3.f_82478_);
        }
    }

    private void applyBehaviorOptimizations(LivingEntity entity, SyncDecision decision) {
        if (decision.shouldReduceUpdates && entity.f_19797_ % decision.updateInterval != 0) {
            return;
        }
    }

    private void updateSyncMetrics(long duration) {
        long currentTime;
        long operations = this.totalSyncOperations.incrementAndGet();
        double currentAvg = this.averageSyncTime.get();
        double newAvg = (currentAvg * (double)(operations - 1L) + (double)duration) / (double)operations;
        this.averageSyncTime.set(newAvg);
        if (operations % 1000L == 0L && (currentTime = System.nanoTime()) - this.lastOptimizationCycle > 10000000000L) {
            this.optimizeSyncParameters();
            this.lastOptimizationCycle = currentTime;
        }
    }

    private void optimizeSyncParameters() {
        double avgTime = this.averageSyncTime.get();
        if (avgTime > 1000000.0) {
            this.adaptiveMode = true;
            SyncFixMod.LOGGER.warn("High sync times detected ({}ns), enabling adaptive mode", (Object)Math.round(avgTime));
        } else if (avgTime < 500000.0 && this.adaptiveMode) {
            this.adaptiveMode = false;
            SyncFixMod.LOGGER.info("Sync performance optimal ({}ns), disabling adaptive mode", (Object)Math.round(avgTime));
        }
        this.syncProfiles.entrySet().removeIf(entry -> ((AdvancedSyncProfile)entry.getValue()).isObsolete());
    }

    public void shutdown() {
        this.syncExecutor.shutdown();
        try {
            if (!this.syncExecutor.awaitTermination(3L, TimeUnit.SECONDS)) {
                this.syncExecutor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.syncExecutor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private static class AdvancedSyncProfile {
        private final UUID entityId;
        private final AtomicLong lastUpdate = new AtomicLong(0L);
        private final AtomicInteger learningCycles = new AtomicInteger(0);
        private final AtomicReference<Double> behaviorPredictability = new AtomicReference<Double>(0.5);
        private final AtomicReference<Double> optimizationEffectiveness = new AtomicReference<Double>(0.5);
        private final Queue<SyncDecision> recentDecisions = new ConcurrentLinkedQueue<SyncDecision>();
        private volatile double[] behaviorWeights = new double[8];
        private volatile boolean fullCapabilities = true;
        private volatile int aiFrequencyReduction = 1;

        public AdvancedSyncProfile(LivingEntity entity) {
            this.entityId = entity.m_20148_();
            Random random = new Random(this.entityId.hashCode());
            for (int i = 0; i < this.behaviorWeights.length; ++i) {
                this.behaviorWeights[i] = random.nextGaussian() * 0.1 + 0.5;
            }
        }

        public SyncDecision calculateOptimalSync(LivingEntity entity, EntityData data, List<Player> nearbyPlayers) {
            double[] features = this.extractBehaviorFeatures(entity, data, nearbyPlayers);
            double optimizationScore = this.calculateOptimizationScore(features);
            SyncDecision decision = new SyncDecision();
            decision.optimizationScore = optimizationScore;
            decision.aiOptimizationLevel = (int)Math.min(3.0, optimizationScore * 4.0);
            decision.shouldReduceMovement = optimizationScore > 0.6;
            decision.movementReductionFactor = Math.max(0.1, 1.0 - optimizationScore * 0.8);
            decision.shouldFreezePosition = optimizationScore > 0.8;
            decision.freezeInterval = Math.max(2, (int)(20.0 * (1.0 - optimizationScore)));
            decision.shouldReduceUpdates = optimizationScore > 0.4;
            decision.updateInterval = Math.max(1, (int)(10.0 * optimizationScore));
            decision.shouldDisablePathfinding = optimizationScore > 0.7;
            this.recentDecisions.offer(decision);
            if (this.recentDecisions.size() > 5) {
                this.recentDecisions.poll();
            }
            return decision;
        }

        private double[] extractBehaviorFeatures(LivingEntity entity, EntityData data, List<Player> nearbyPlayers) {
            double[] features = new double[8];
            double d = features[0] = nearbyPlayers.isEmpty() ? 1.0 : Math.min(1.0, 1.0 / (double)nearbyPlayers.size());
            if (!nearbyPlayers.isEmpty()) {
                double minDistance = nearbyPlayers.stream().mapToDouble(p -> p.m_20270_((Entity)entity)).min().orElse(1000.0);
                features[1] = Math.min(1.0, minDistance / 100.0);
            } else {
                features[1] = 1.0;
            }
            if (data != null) {
                features[2] = Math.min(1.0, (double)data.getTicksSinceLastMovement() / 200.0);
                features[3] = data.isStationary() ? 1.0 : 0.0;
                features[4] = Math.min(1.0, data.getMovementVariance());
                features[5] = Math.min(1.0, (double)data.getOptimizationLevel() / 5.0);
            }
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                Brain brain = mob.m_6274_();
                features[6] = brain != null && brain.m_21968_().isPresent() ? 0.0 : 1.0;
                features[7] = mob.m_21525_() ? 1.0 : 0.0;
            }
            return features;
        }

        private double calculateOptimizationScore(double[] features) {
            double score = 0.0;
            for (int i = 0; i < Math.min(features.length, this.behaviorWeights.length); ++i) {
                score += features[i] * this.behaviorWeights[i];
            }
            return Math.max(0.0, Math.min(1.0, score / (double)this.behaviorWeights.length));
        }

        public void updateLearning(SyncDecision decision, int playerCount) {
            this.lastUpdate.set(System.nanoTime());
            int cycles = this.learningCycles.incrementAndGet();
            double effectiveness = this.calculateEffectiveness(decision, playerCount);
            double currentEffectiveness = this.optimizationEffectiveness.get();
            double newEffectiveness = currentEffectiveness + 0.02 * (effectiveness - currentEffectiveness);
            this.optimizationEffectiveness.set(newEffectiveness);
            if (cycles % 50 == 0) {
                this.adaptBehaviorWeights(effectiveness);
            }
        }

        private double calculateEffectiveness(SyncDecision decision, int playerCount) {
            double baseEffectiveness = decision.optimizationScore;
            if (playerCount == 0) {
                baseEffectiveness *= 1.2;
            } else if (playerCount > 3) {
                baseEffectiveness *= 0.8;
            }
            return Math.max(0.0, Math.min(1.0, baseEffectiveness));
        }

        private void adaptBehaviorWeights(double effectiveness) {
            Random random = new Random();
            for (int i = 0; i < this.behaviorWeights.length; ++i) {
                double adjustment = (effectiveness - 0.5) * 0.02;
                this.behaviorWeights[i] = Math.max(0.1, Math.min(1.0, this.behaviorWeights[i] + adjustment + random.nextGaussian() * 0.01));
            }
        }

        public void restoreFullCapabilities() {
            this.fullCapabilities = true;
            this.aiFrequencyReduction = 1;
        }

        public void reduceAIFrequency(double factor) {
            this.fullCapabilities = false;
            this.aiFrequencyReduction = Math.max(1, (int)(1.0 / factor));
        }

        public boolean isObsolete() {
            return System.nanoTime() - this.lastUpdate.get() > 600000000000L;
        }
    }

    private static class SyncDecision {
        double optimizationScore;
        int aiOptimizationLevel;
        boolean shouldReduceMovement;
        double movementReductionFactor;
        boolean shouldFreezePosition;
        int freezeInterval;
        boolean shouldReduceUpdates;
        int updateInterval;
        boolean shouldDisablePathfinding;

        private SyncDecision() {
        }
    }
}

