/*
 * Decompiled with CFR 0.152.
 */
package com.xinian.tickaccelerate.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.xinian.tickaccelerate.config.ConfigOption;
import com.xinian.tickaccelerate.config.TOMLConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public class MainConfig
extends TOMLConfiguration {
    private static final List<ConfigOption<Boolean>> BOOLEAN_OPTIONS = new ArrayList<ConfigOption<Boolean>>();
    private int tickRepeatCap;
    private int dynamicCapMsptThreshold;
    private int extraCompensationMsptThreshold;
    private int extraCompensationAmountMs;
    private Map<String, Number> perBlockCaps = new HashMap<String, Number>();
    private final Map<String, Boolean> valueCache = new HashMap<String, Boolean>();

    public MainConfig() {
        super("config.toml");
        this.setComment("general", "General settings for the mod.");
        this.setComment("acceleration_modules", "Enable or disable specific acceleration features.");
        this.setComment("performance_tuning", "Advanced settings for performance and stability.");
        this.setComment("performance_tuning.dynamic_cap", "Dynamically adjusts the tick cap based on server MSPT.");
        this.setComment("performance_tuning.extra_compensation", "Adds extra ticks to compensate for lag.");
        this.setComment("performance_tuning.block_entity_caps", "Fine-grained control for block entity acceleration.");
        this.setComment("tweaks", "Miscellaneous adjustments.");
        for (ConfigOption<Boolean> option : BOOLEAN_OPTIONS) {
            this.putIfEmpty(option.getKey(), option.getDefaultValue());
            this.setComment(option.getKey(), option.getComment());
        }
        this.putIfEmpty("performance_tuning.tick_repeat_cap", 10);
        this.setComment("performance_tuning.tick_repeat_cap", "The global maximum number of times a tick can be repeated. -1 for no limit.");
        this.putIfEmpty("performance_tuning.dynamic_cap.mspt_threshold", 100);
        this.setComment("performance_tuning.dynamic_cap.mspt_threshold", "If MSPT goes above this value, the tick repeat cap is dynamically set to 0.");
        this.putIfEmpty("performance_tuning.extra_compensation.mspt_threshold", 40);
        this.setComment("performance_tuning.extra_compensation.mspt_threshold", "If MSPT is above this value, extra compensation will be applied.");
        this.putIfEmpty("performance_tuning.extra_compensation.amount_ms", 10);
        this.setComment("performance_tuning.extra_compensation.amount_ms", "The amount of extra compensation to apply in milliseconds.");
        if (!this.getRawConfig().contains("performance_tuning.block_entity_caps")) {
            HashMap<String, Integer> defaultCaps = new HashMap<String, Integer>();
            defaultCaps.put("minecraft:hopper", 2);
            defaultCaps.put("*", -1);
            defaultCaps.forEach((key, value) -> this.config.set("performance_tuning.block_entity_caps." + key, value));
        }
        this.save();
        this.reload();
    }

    @Override
    public void reload() {
        super.reload();
        for (ConfigOption<Boolean> option : BOOLEAN_OPTIONS) {
            this.valueCache.put(option.getKey(), this.getOrDefault(option.getKey(), option.getDefaultValue()));
        }
        this.tickRepeatCap = this.getOrDefault("performance_tuning.tick_repeat_cap", 10);
        this.dynamicCapMsptThreshold = this.getOrDefault("performance_tuning.dynamic_cap.mspt_threshold", 100);
        this.extraCompensationMsptThreshold = this.getOrDefault("performance_tuning.extra_compensation.mspt_threshold", 40);
        this.extraCompensationAmountMs = this.getOrDefault("performance_tuning.extra_compensation.amount_ms", 10);
        this.perBlockCaps.clear();
        Object rawCaps = this.get("performance_tuning.block_entity_caps");
        if (rawCaps instanceof CommentedConfig) {
            ((CommentedConfig)rawCaps).valueMap().forEach((key, value) -> {
                if (value instanceof Number) {
                    this.perBlockCaps.put((String)key, (Number)value);
                }
            });
        }
    }

    public int getCapForBlock(ResourceLocation blockId) {
        if (this.perBlockCaps == null || this.perBlockCaps.isEmpty()) {
            return this.getTickRepeatCap();
        }
        String idString = blockId.toString();
        if (this.perBlockCaps.containsKey(idString)) {
            int cap = this.perBlockCaps.get(idString).intValue();
            return cap == -1 ? this.getTickRepeatCap() : cap;
        }
        String namespaceWildcard = blockId.m_135827_() + ":*";
        if (this.perBlockCaps.containsKey(namespaceWildcard)) {
            int cap = this.perBlockCaps.get(namespaceWildcard).intValue();
            return cap == -1 ? this.getTickRepeatCap() : cap;
        }
        if (this.perBlockCaps.containsKey("*")) {
            int cap = this.perBlockCaps.get("*").intValue();
            return cap == -1 ? this.getTickRepeatCap() : cap;
        }
        return this.getTickRepeatCap();
    }

    public static List<ConfigOption<Boolean>> getBooleanOptions() {
        return BOOLEAN_OPTIONS;
    }

    public void setBoolean(String key, boolean value) {
        this.set(key, value);
        this.valueCache.put(key, value);
    }

    public boolean getBoolean(String key) {
        return this.valueCache.getOrDefault(key, false);
    }

    public int getTickRepeatCap() {
        return this.tickRepeatCap;
    }

    public int getDynamicCapMsptThreshold() {
        return this.dynamicCapMsptThreshold;
    }

    public int getExtraCompensationMsptThreshold() {
        return this.extraCompensationMsptThreshold;
    }

    public int getExtraCompensationAmountMs() {
        return this.extraCompensationAmountMs;
    }

    public boolean enabled() {
        return this.getBoolean("general.enabled");
    }

    public boolean singlePlayerWarning() {
        return this.getBoolean("general.singleplayer-warning");
    }

    public boolean automaticUpdater() {
        return this.getBoolean("general.automatic-updater");
    }

    public boolean blockEntityAcceleration() {
        return this.getBoolean("acceleration_modules.block_entity");
    }

    public boolean blockBreakingAcceleration() {
        return this.getBoolean("acceleration_modules.block_breaking");
    }

    public boolean potionEffectAcceleration() {
        return this.getBoolean("acceleration_modules.potion_effect");
    }

    public boolean fluidAcceleration() {
        return this.getBoolean("acceleration_modules.fluid");
    }

    public boolean pickupAcceleration() {
        return this.getBoolean("acceleration_modules.item_pickup");
    }

    public boolean eatingAcceleration() {
        return this.getBoolean("acceleration_modules.eating");
    }

    public boolean portalAcceleration() {
        return this.getBoolean("acceleration_modules.nether_portal");
    }

    public boolean sleepingAcceleration() {
        return this.getBoolean("acceleration_modules.sleeping");
    }

    public boolean timeAcceleration() {
        return this.getBoolean("acceleration_modules.time");
    }

    public boolean bowAcceleration() {
        return this.getBoolean("acceleration_modules.bow");
    }

    public boolean crossbowAcceleration() {
        return this.getBoolean("acceleration_modules.crossbow");
    }

    public boolean randomTickSpeedAcceleration() {
        return this.getBoolean("acceleration_modules.random_tick_speed");
    }

    public boolean dynamicCapEnabled() {
        return this.getBoolean("performance_tuning.dynamic_cap.enabled");
    }

    public boolean extraCompensationEnabled() {
        return this.getBoolean("performance_tuning.extra_compensation.enabled");
    }

    public boolean disableServerWatchdog() {
        return this.getBoolean("tweaks.disable_server_watchdog");
    }

    static {
        BOOLEAN_OPTIONS.add(new ConfigOption<Boolean>("general.enabled", true, "Enable or disable the mod entirely."));
        BOOLEAN_OPTIONS.add(new ConfigOption<Boolean>("general.singleplayer-warning", true, "Show a warning when using the mod in singleplayer."));
        BOOLEAN_OPTIONS.add(new ConfigOption<Boolean>("general.automatic-updater", true, "Enable automatic update checks."));
        BOOLEAN_OPTIONS.add(new ConfigOption<Boolean>("acceleration_modules.block_entity", false, "Accelerate block entities (e.g., furnaces, hoppers). Can cause issues."));
        BOOLEAN_OPTIONS.add(new ConfigOption<Boolean>("acceleration_modules.block_breaking", true, "Accelerate block breaking."));
        BOOLEAN_OPTIONS.add(new ConfigOption<Boolean>("acceleration_modules.potion_effect", true, "Accelerate potion effect timers."));
        BOOLEAN_OPTIONS.add(new ConfigOption<Boolean>("acceleration_modules.fluid", true, "Accelerate fluid flow."));
        BOOLEAN_OPTIONS.add(new ConfigOption<Boolean>("acceleration_modules.item_pickup", true, "Accelerate item pickup delay."));
        BOOLEAN_OPTIONS.add(new ConfigOption<Boolean>("acceleration_modules.eating", true, "Accelerate eating and drinking animations."));
        BOOLEAN_OPTIONS.add(new ConfigOption<Boolean>("acceleration_modules.nether_portal", true, "Accelerate nether portal teleportation time."));
        BOOLEAN_OPTIONS.add(new ConfigOption<Boolean>("acceleration_modules.sleeping", true, "Accelerate time to pass the night when sleeping."));
        BOOLEAN_OPTIONS.add(new ConfigOption<Boolean>("acceleration_modules.time", true, "Accelerate the day-night cycle."));
        BOOLEAN_OPTIONS.add(new ConfigOption<Boolean>("acceleration_modules.bow", true, "Accelerate bow drawing speed."));
        BOOLEAN_OPTIONS.add(new ConfigOption<Boolean>("acceleration_modules.crossbow", true, "Accelerate crossbow loading speed."));
        BOOLEAN_OPTIONS.add(new ConfigOption<Boolean>("acceleration_modules.random_tick_speed", true, "Accelerate random block ticks (e.g., crop growth)."));
        BOOLEAN_OPTIONS.add(new ConfigOption<Boolean>("performance_tuning.dynamic_cap.enabled", true, "Enable the dynamic tick repeat cap. This helps prevent feedback loops under heavy lag."));
        BOOLEAN_OPTIONS.add(new ConfigOption<Boolean>("performance_tuning.extra_compensation.enabled", true, "Enable extra tick compensation."));
        BOOLEAN_OPTIONS.add(new ConfigOption<Boolean>("tweaks.disable_server_watchdog", true, "Disable the vanilla server watchdog to prevent crashes due to low TPS."));
    }
}

