/*
 * Decompiled with CFR 0.152.
 */
package com.xinian.tickaccelerate.util;

import com.xinian.tickaccelerate.TickAccelerate;
import com.xinian.tickaccelerate.config.TOMLConfiguration;
import com.xinian.tickaccelerate.util.MaskType;
import com.xinian.tickaccelerate.util.RegistryIndex;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;

public class Mask {
    private final TOMLConfiguration file;
    private final MaskType maskType;
    private final IForgeRegistry<?> registry;
    private final RegistryIndex index;
    private final Set<ResourceLocation> entries;

    public Mask(IForgeRegistry<?> registry, TOMLConfiguration file, String maskKey) {
        this.file = file;
        String type = (String)file.get("type");
        if (type == null) {
            TickAccelerate.LOGGER.warn("(TickAccelerate) Mask type is missing in '{}', defaulting to 'whitelist'.", (Object)file.fileName);
            this.maskType = MaskType.WHITELIST;
        } else {
            this.maskType = MaskType.fromString(type);
        }
        this.registry = registry;
        this.index = RegistryIndex.getIndex(this.registry);
        this.entries = new HashSet<ResourceLocation>();
        List maskList = (List)file.get(maskKey);
        if (maskList == null) {
            TickAccelerate.LOGGER.error("(TickAccelerate) Mask entry '{}' is missing or not an array in '{}'.", (Object)maskKey, (Object)file.fileName);
            return;
        }
        for (String element : maskList) {
            this.entries.addAll(this.manageEntry(element));
        }
    }

    public List<ResourceLocation> manageEntry(String entry) {
        String[] split = entry.split(":");
        if (split.length != 2) {
            TickAccelerate.LOGGER.error("(TickAccelerate) '" + entry + "' is not a valid identifier. Correct format is <namespace>:<path>");
            return new ArrayList<ResourceLocation>();
        }
        if (split[0].equals("*") && split[1].equals("*")) {
            return this.index.getIdentifiers();
        }
        if (!split[0].equals("*") && !split[1].equals("*")) {
            return List.of(ResourceLocation.m_214293_((String)split[0], (String)split[1]));
        }
        if (split[0].equals("*") && !split[1].equals("*")) {
            return this.index.getPathIndex().getOrDefault(split[1], new ArrayList());
        }
        if (!split[0].equals("*") && split[1].equals("*")) {
            return this.index.getNamespaceIndex().getOrDefault(split[0], new ArrayList());
        }
        throw new IllegalStateException("Should not reach here: manageEntry did not return a list for entry: " + entry);
    }

    public IForgeRegistry<?> getRegistry() {
        return this.registry;
    }

    public TOMLConfiguration getFile() {
        return this.file;
    }

    public boolean matches(ResourceLocation identifier) {
        return this.entries.contains(identifier);
    }

    public boolean isOkay(ResourceLocation identifier) {
        boolean contains = this.entries.contains(identifier);
        return this.maskType == MaskType.WHITELIST ? contains : !contains;
    }
}

