/*
 * Decompiled with CFR 0.152.
 */
package com.xinian.tickaccelerate.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;

public class RegistryIndex {
    private static final HashMap<IForgeRegistry<?>, RegistryIndex> indexes = new HashMap();
    private final IForgeRegistry<?> registry;
    private final List<ResourceLocation> identifiers;
    private final List<String> namespaces;
    private final List<String> paths;
    private final HashMap<String, List<ResourceLocation>> namespaceIndex;
    private final HashMap<String, List<ResourceLocation>> pathIndex;

    private RegistryIndex(IForgeRegistry<?> registry) {
        this.registry = registry;
        this.identifiers = new ArrayList<ResourceLocation>();
        this.namespaces = new ArrayList<String>();
        this.paths = new ArrayList<String>();
        this.namespaceIndex = new HashMap();
        this.pathIndex = new HashMap();
        for (ResourceLocation key : registry.getKeys()) {
            String namespace = key.m_135827_();
            String path = key.m_135815_();
            if (!this.namespaces.contains(namespace)) {
                this.namespaces.add(namespace);
                this.namespaceIndex.put(namespace, new ArrayList());
            }
            if (!this.paths.contains(path)) {
                this.paths.add(path);
                this.pathIndex.put(path, new ArrayList());
            }
            this.identifiers.add(key);
            this.namespaceIndex.get(namespace).add(key);
            this.pathIndex.get(path).add(key);
        }
    }

    public IForgeRegistry<?> getRegistry() {
        return this.registry;
    }

    public List<ResourceLocation> getIdentifiers() {
        return this.identifiers;
    }

    public HashMap<String, List<ResourceLocation>> getNamespaceIndex() {
        return new HashMap<String, List<ResourceLocation>>(this.namespaceIndex);
    }

    public HashMap<String, List<ResourceLocation>> getPathIndex() {
        return new HashMap<String, List<ResourceLocation>>(this.pathIndex);
    }

    public List<String> getNamespaces() {
        return new ArrayList<String>(this.namespaces);
    }

    public List<String> getPaths() {
        return new ArrayList<String>(this.paths);
    }

    public static RegistryIndex getIndex(IForgeRegistry<?> registry) {
        if (indexes.containsKey(registry)) {
            return indexes.get(registry);
        }
        indexes.put(registry, new RegistryIndex(registry));
        return indexes.get(registry);
    }
}

