/*
 * Decompiled with CFR 0.152.
 */
package banduty.ticktweaks.config;

import java.util.ArrayList;
import java.util.List;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.serializer.PartitioningSerializer;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

@Config(name="ticktweaks")
@Config.Gui.Background(value="minecraft:textures/block/oak_planks.png")
public class ModConfigs
extends PartitioningSerializer.GlobalData {
    @ConfigEntry.Category(value="coreTickSettings")
    @ConfigEntry.Gui.TransitiveObject
    public CoreTickSettings coreTickSettings = new CoreTickSettings();
    @ConfigEntry.Category(value="entityTickSettings")
    @ConfigEntry.Gui.TransitiveObject
    public EntityTickSettings entityTickSettings = new EntityTickSettings();
    @ConfigEntry.Category(value="performanceSettings")
    @ConfigEntry.Gui.TransitiveObject
    public PerformanceSettings performanceSettings = new PerformanceSettings();
    @ConfigEntry.Category(value="emergencySettings")
    @ConfigEntry.Gui.TransitiveObject
    public EmergencySettings emergencySettings = new EmergencySettings();

    @Config(name="ticktweaks-coreTickSettings")
    public static final class CoreTickSettings
    implements ConfigData {
        @ConfigEntry.Gui.Tooltip
        @Comment(value="Base formula for dynamic tick rate calculation.\nUse 'tps' as the TPS variable.")
        public String tickRateFormula = "3 - (tps / 10)";
        @ConfigEntry.Gui.Tooltip(count=0)
        @Comment(value="List of dimensions where custom ticking is enabled\nTo don't break the configs, it is necessary that you put manually the worlds.\nSorry for the inconveniences.\n")
        public List<String> enabledDimensions = new ArrayList<String>();

        public String getTickRateFormula() {
            return this.tickRateFormula;
        }

        public boolean isDimensionEnabled(ResourceKey<Level> dimension) {
            return this.enabledDimensions.contains(dimension.location().toString());
        }
    }

    @Config(name="ticktweaks-entityTickSettings")
    public static final class EntityTickSettings
    implements ConfigData {
        @ConfigEntry.Gui.CollapsibleObject
        public LivingEntitySettings livingEntities = new LivingEntitySettings();
        @ConfigEntry.Gui.CollapsibleObject
        public ItemEntitySettings itemEntities = new ItemEntitySettings();
        @ConfigEntry.Gui.CollapsibleObject
        public BlockEntitySettings blockEntities = new BlockEntitySettings();

        public static class LivingEntitySettings {
            @ConfigEntry.Gui.Tooltip
            @Comment(value="Fixed tick rate for living entities (0 for dynamic TPS-based rate)")
            public int fixedTickRate = 0;
            @ConfigEntry.Gui.Tooltip(count=0)
            @Comment(value="Reduced tick rate when entities are not visible")
            public int nonVisibleTickRate = 5;
            @ConfigEntry.Gui.Tooltip(count=0)
            @Comment(value="List of living entities exempt from tick adjustments")
            public List<String> exemptEntities = new ArrayList<String>();

            public int getFixedTickRate() {
                return Math.max(0, this.fixedTickRate);
            }

            public int getNonVisibleTickRate() {
                return Math.max(0, this.nonVisibleTickRate);
            }

            public List<String> getExemptEntities() {
                return this.exemptEntities;
            }
        }

        public static class ItemEntitySettings {
            @ConfigEntry.Gui.Tooltip
            @Comment(value="Fixed tick rate for item entities (0 for dynamic TPS-based rate)")
            public int fixedTickRate = 0;
            @ConfigEntry.Gui.Tooltip(count=0)
            @Comment(value="Enable Dynamic tick rate for items")
            public boolean enabled = true;

            public int getFixedTickRate() {
                return Math.max(0, this.fixedTickRate);
            }
        }

        public static class BlockEntitySettings {
            @ConfigEntry.Gui.Tooltip
            @Comment(value="Fixed tick rate for block entities (0 for dynamic TPS-based rate)")
            public int fixedTickRate = 0;
            @ConfigEntry.Gui.Tooltip(count=0)
            @Comment(value="Enable Dynamic tick rate for block entities")
            public boolean enabled = false;

            public int getFixedTickRate() {
                return Math.max(0, this.fixedTickRate);
            }
        }
    }

    @Config(name="ticktweaks-performanceSettings")
    public static final class PerformanceSettings
    implements ConfigData {
        @ConfigEntry.Gui.CollapsibleObject
        public ActivationRangeSettings activationRanges = new ActivationRangeSettings();
        @ConfigEntry.Gui.CollapsibleObject
        public MobDespawnSettings mobDespawn = new MobDespawnSettings();
        @ConfigEntry.Gui.Tooltip
        @Comment(value="Duration to Cache Custom Activation Range settings (seconds)")
        public int settingsCacheTime = 300;

        public int getSettingsCacheTime() {
            return Math.max(0, this.settingsCacheTime);
        }

        public static class ActivationRangeSettings {
            @ConfigEntry.Gui.Tooltip(count=0)
            @Comment(value="Enable custom activation ranges")
            public boolean enabled = false;
            @ConfigEntry.Gui.CollapsibleObject
            public DefaultActivationRange defaultRange = new DefaultActivationRange();
            @ConfigEntry.Gui.Tooltip(count=0)
            public List<CustomActivationRange> customRanges = new ArrayList<CustomActivationRange>();

            public boolean isEnabled() {
                return this.enabled;
            }

            public DefaultActivationRange getDefaultRange() {
                return this.defaultRange;
            }

            public List<CustomActivationRange> getCustomRanges() {
                return this.customRanges;
            }
        }

        public static class MobDespawnSettings {
            @ConfigEntry.Gui.Tooltip(count=0)
            @Comment(value="Time in ticks before mobs despawn (600 = 30 seconds)")
            public int despawnTime = 600;
            @ConfigEntry.Gui.Tooltip(count=0)
            @Comment(value="Chance per tick for mobs to despawn")
            public float despawnChance = 0.00125f;

            public int getDespawnTime() {
                return Math.max(0, this.despawnTime);
            }

            public float getDespawnChance() {
                return Math.max(0.0f, this.despawnChance);
            }
        }

        public static class CustomActivationRange {
            public String name = "";
            public int range = 0;
            public int tickInterval = 0;
            public int wakeupInterval = 0;
            @ConfigEntry.Gui.Tooltip
            @Comment(value="Is valid entityId / mod-id / #mod-id:entity_tag")
            public List<String> entities = new ArrayList<String>();

            public CustomActivationRange() {
            }

            public CustomActivationRange(String name, int range, int tickInterval, int wakeupInterval, List<String> entities) {
                this.name = name;
                this.range = range;
                this.tickInterval = tickInterval;
                this.wakeupInterval = wakeupInterval;
                this.entities = new ArrayList<String>(entities);
            }

            public String getName() {
                return this.name;
            }

            public int getRange() {
                return this.range;
            }

            public int getTickInterval() {
                return this.tickInterval;
            }

            public int getWakeupInterval() {
                return this.wakeupInterval;
            }

            public List<String> getEntities() {
                return this.entities;
            }
        }

        public static class DefaultActivationRange {
            public int range = 16;
            public int tickInterval = -1;
            public int wakeupInterval = -1;

            public int getTickInterval() {
                return this.tickInterval;
            }

            public int getRange() {
                return this.range;
            }

            public int getWakeupInterval() {
                return this.wakeupInterval;
            }
        }
    }

    @Config(name="ticktweaks-emergencySettings")
    public static final class EmergencySettings
    implements ConfigData {
        @ConfigEntry.Gui.Tooltip
        @Comment(value="TPS threshold for emergency systems (block entity freeze)")
        public int tpsThreshold = 2;

        public int getTpsThreshold() {
            return Math.max(0, this.tpsThreshold);
        }
    }
}

