/*
 * Decompiled with CFR 0.152.
 */
package banduty.ticktweaks.mixin;

import banduty.ticktweaks.TickTweaks;
import banduty.ticktweaks.util.TickHandlerUtil;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemEntity.class})
public abstract class ItemEntityMixin {
    @Unique
    private static final Map<ItemEntity, Integer> TICK_TIME_MAP = Collections.synchronizedMap(new WeakHashMap());

    @Inject(method={"tick"}, at={@At(value="HEAD")}, cancellable=true)
    private void onTickEntity(CallbackInfo ci) {
        ItemEntity itemEntity = (ItemEntity)this;
        Level world = itemEntity.level();
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            MinecraftServer server = serverLevel.getServer();
            int currentTickTime = TICK_TIME_MAP.getOrDefault(itemEntity, 0);
            if (!TickTweaks.CONFIG.entityTickSettings.itemEntities.enabled || TickHandlerUtil.tickCancellation(server, ci, true, TickTweaks.CONFIG.entityTickSettings.itemEntities.getFixedTickRate(), currentTickTime, 0)) {
                TICK_TIME_MAP.put(itemEntity, 0);
            }
            TICK_TIME_MAP.put(itemEntity, currentTickTime + 1);
        }
    }
}

