/*
 * Decompiled with CFR 0.152.
 */
package banduty.ticktweaks.mixin;

import banduty.ticktweaks.TickTweaks;
import banduty.ticktweaks.config.ModConfigs;
import banduty.ticktweaks.util.TickHandlerUtil;
import banduty.ticktweaks.util.TickRateCalculator;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public class LivingEntityMixin {
    @Unique
    private static final Map<LivingEntity, Integer> TICK_TIME_MAP = Collections.synchronizedMap(new WeakHashMap());
    @Unique
    private final LivingEntity livingEntity = (LivingEntity)this;
    @Unique
    private static final Map<LivingEntity, Integer> WAKEUP_INTERVAL_MAP = Collections.synchronizedMap(new WeakHashMap());
    @Unique
    private ModConfigs.PerformanceSettings.CustomActivationRange customActivationRange;

    @Inject(method={"tick"}, at={@At(value="HEAD")}, cancellable=true)
    private void onTickEntity(CallbackInfo ci) {
        ServerLevel serverLevel;
        Level level;
        block15: {
            block14: {
                level = this.livingEntity.level();
                if (!(level instanceof ServerLevel)) break block14;
                serverLevel = (ServerLevel)level;
                if (!(this.livingEntity instanceof Player) && !TickRateCalculator.shouldSkipTicking(serverLevel) && !(this.livingEntity.getHealth() <= 0.0f)) break block15;
            }
            return;
        }
        ModConfigs.PerformanceSettings.ActivationRangeSettings activationSettings = TickTweaks.CONFIG.performanceSettings.activationRanges;
        int currentTickTime = TICK_TIME_MAP.getOrDefault(this.livingEntity, 0);
        int wakeupInterval = WAKEUP_INTERVAL_MAP.getOrDefault(this.livingEntity, 0);
        if (activationSettings.isEnabled() && this.customActivationRange != null) {
            int wakeupInt = this.customActivationRange.getWakeupInterval();
            if (wakeupInt > 0 && wakeupInterval < wakeupInt) {
                WAKEUP_INTERVAL_MAP.put(this.livingEntity, wakeupInterval + 1);
                int tickInt = this.customActivationRange.getTickInterval();
                if (currentTickTime < tickInt) {
                    TICK_TIME_MAP.put(this.livingEntity, currentTickTime + 1);
                    ci.cancel();
                    return;
                }
            }
        } else {
            ModConfigs.PerformanceSettings.DefaultActivationRange defaultActivationRange = TickTweaks.CONFIG.performanceSettings.activationRanges.getDefaultRange();
            int wakeupInt = defaultActivationRange.getWakeupInterval();
            if (wakeupInt > 0 && wakeupInterval < wakeupInt) {
                WAKEUP_INTERVAL_MAP.put(this.livingEntity, wakeupInterval + 1);
                int tickInt = defaultActivationRange.getTickInterval();
                if (currentTickTime < tickInt) {
                    TICK_TIME_MAP.put(this.livingEntity, currentTickTime + 1);
                    ci.cancel();
                    return;
                }
            }
        }
        WAKEUP_INTERVAL_MAP.put(this.livingEntity, 0);
        if (activationSettings.isEnabled()) {
            this.handleCustomActivationWithCache(serverLevel, ci, currentTickTime);
            if (ci.isCancelled()) {
                return;
            }
        }
        ModConfigs.PerformanceSettings.DefaultActivationRange defaultRange = activationSettings.getDefaultRange();
        int globalDistance = defaultRange.getRange();
        List<String> exemptEntities = TickTweaks.CONFIG.entityTickSettings.livingEntities.getExemptEntities();
        boolean isExempt = TickHandlerUtil.matchesEntity(this.livingEntity, exemptEntities);
        if (globalDistance > 0 && !isExempt) {
            boolean withinRadius = TickHandlerUtil.isEntityWithinRadius((Entity)this.livingEntity, level, globalDistance);
            boolean onScreen = TickHandlerUtil.isOnPlayerScreen((Entity)this.livingEntity, level);
            int tickRate = onScreen ? TickTweaks.CONFIG.entityTickSettings.livingEntities.getFixedTickRate() : TickTweaks.CONFIG.entityTickSettings.livingEntities.getNonVisibleTickRate();
            MinecraftServer server = serverLevel.getServer();
            boolean shouldCancel = TickHandlerUtil.tickCancellation(server, ci, withinRadius, tickRate, currentTickTime, defaultRange.getTickInterval());
            if (shouldCancel) {
                TICK_TIME_MAP.put(this.livingEntity, 0);
                return;
            }
        }
        TICK_TIME_MAP.put(this.livingEntity, currentTickTime + 1);
    }

    @Unique
    private void handleCustomActivationWithCache(ServerLevel world, CallbackInfo ci, int currentTickTime) {
        this.customActivationRange = this.getActivationTypeForEntity();
        boolean withinRadius = TickHandlerUtil.isEntityWithinRadius((Entity)this.livingEntity, (Level)world, this.customActivationRange.getRange());
        int tickInt = this.customActivationRange.getTickInterval();
        if (!(tickInt >= 0 && currentTickTime >= tickInt || withinRadius)) {
            ci.cancel();
            return;
        }
        TICK_TIME_MAP.put(this.livingEntity, 0);
    }

    @Unique
    private ModConfigs.PerformanceSettings.CustomActivationRange getActivationTypeForEntity() {
        EntityType type = this.livingEntity.getType();
        return TickTweaks.ACTIVATION_CACHE.computeIfAbsent(type, t -> {
            ModConfigs.PerformanceSettings.ActivationRangeSettings settings = TickTweaks.CONFIG.performanceSettings.activationRanges;
            List<ModConfigs.PerformanceSettings.CustomActivationRange> customRanges = settings.getCustomRanges();
            for (ModConfigs.PerformanceSettings.CustomActivationRange custom : customRanges) {
                if (!TickHandlerUtil.matchesEntity(this.livingEntity, custom.getEntities())) continue;
                return custom;
            }
            ModConfigs.PerformanceSettings.DefaultActivationRange defaultRange = settings.getDefaultRange();
            return new ModConfigs.PerformanceSettings.CustomActivationRange("default", defaultRange.getRange(), defaultRange.getTickInterval(), defaultRange.getWakeupInterval(), Collections.emptyList());
        });
    }
}

