/*
 * Decompiled with CFR 0.152.
 */
package banduty.ticktweaks.mixin;

import banduty.ticktweaks.TickTweaks;
import banduty.ticktweaks.util.TickHandlerUtil;
import banduty.ticktweaks.util.TickRateCalculator;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Level.class})
public abstract class WorldMixin {
    @Unique
    private int blockEntitiesTickCounter = 0;

    @Inject(method={"tickBlockEntities"}, at={@At(value="HEAD")}, cancellable=true)
    private void onTickBlockEntities(CallbackInfo ci) {
        Level level = (Level)this;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        double tps = Math.min(1000.0 / (double)serverLevel.getServer().getAverageTickTime(), 20.0);
        if (TickRateCalculator.shouldSkipTicking(serverLevel)) {
            return;
        }
        if (!TickTweaks.CONFIG.entityTickSettings.blockEntities.enabled) {
            return;
        }
        if (tps < (double)TickTweaks.CONFIG.emergencySettings.getTpsThreshold()) {
            ci.cancel();
        }
        if (TickHandlerUtil.tickCancellation(serverLevel.getServer(), ci, true, TickTweaks.CONFIG.entityTickSettings.blockEntities.getFixedTickRate(), this.blockEntitiesTickCounter, 0)) {
            this.blockEntitiesTickCounter = 0;
        }
        ++this.blockEntitiesTickCounter;
    }
}

