/*
 * Decompiled with CFR 0.152.
 */
package banduty.ticktweaks.util;

import banduty.ticktweaks.TickTweaks;
import banduty.ticktweaks.util.TickRateCalculator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

public class TickHandlerUtil {
    private static final Set<Entity> GLOBAL_VISIBLE_ENTITIES = ConcurrentHashMap.newKeySet();
    private static long lastCacheUpdate = 0L;

    public static boolean tickCancellation(MinecraftServer server, CallbackInfo ci, boolean isWithinRadius, int specificTickRate, int tickCounter, int tickingTimeOnStop) {
        int tickRate;
        int n = tickRate = isWithinRadius ? TickRateCalculator.getCustomTickRate(server, specificTickRate) : tickingTimeOnStop;
        if (tickRate == 0 || tickCounter + 1 < tickRate) {
            ci.cancel();
            return false;
        }
        return true;
    }

    public static boolean isEntityWithinRadius(Entity entity, Level level, int radiusThreshold) {
        double squaredRadius = (double)radiusThreshold * (double)radiusThreshold;
        for (Player player : level.players()) {
            if (!(player.distanceToSqr(entity) <= squaredRadius)) continue;
            return true;
        }
        return false;
    }

    public static boolean isOnPlayerScreen(Entity entity, Level level) {
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        long currentTime = level.getGameTime();
        if (currentTime - lastCacheUpdate > 30L) {
            TickHandlerUtil.updateVisibleEntitiesCache(serverLevel);
            lastCacheUpdate = currentTime;
        }
        return GLOBAL_VISIBLE_ENTITIES.contains(entity);
    }

    private static void updateVisibleEntitiesCache(ServerLevel serverLevel) {
        GLOBAL_VISIBLE_ENTITIES.clear();
        double maxDistance = 32.0;
        double fovThreshold = 0.33;
        serverLevel.players().parallelStream().forEach(player -> {
            Vec3 eyePos = player.getEyePosition(1.0f);
            Vec3 lookVec = player.getLookAngle();
            serverLevel.getEntities((Entity)player, player.getBoundingBox().inflate(32.0)).forEach(entity -> {
                Vec3 toEntity = entity.position().subtract(eyePos).normalize();
                if (lookVec.dot(toEntity) > 0.33) {
                    GLOBAL_VISIBLE_ENTITIES.add((Entity)entity);
                }
            });
        });
    }

    public static boolean matchesEntity(LivingEntity entity, List<String> matchers) {
        if (matchers.isEmpty() || entity == null) {
            return false;
        }
        EntityType type = entity.getType();
        ResourceLocation entityId = ForgeRegistries.ENTITY_TYPES.getKey((Object)type);
        IForgeRegistry registry = ForgeRegistries.ENTITY_TYPES;
        return matchers.stream().anyMatch(matcher -> TickHandlerUtil.checkMatch(matcher, entityId.toString(), registry, type));
    }

    private static boolean checkMatch(String matcher, String entityId, IForgeRegistry<EntityType<?>> registry, EntityType<?> type) {
        if (matcher == null || entityId == null || registry == null || type == null) {
            return false;
        }
        if (matcher.equals(entityId)) {
            return true;
        }
        if (matcher.startsWith("#")) {
            try {
                String tagString = matcher.substring(1);
                ResourceLocation tagLocation = ResourceLocation.tryParse((String)tagString);
                if (tagLocation == null) {
                    return false;
                }
                TagKey tagKey = TagKey.create((ResourceKey)ForgeRegistries.ENTITY_TYPES.getRegistryKey(), (ResourceLocation)tagLocation);
                return type.is(tagKey);
            }
            catch (Exception e) {
                TickTweaks.LOGGER.error("Error checking entity tag match for {}", (Object)matcher, (Object)e);
                return false;
            }
        }
        try {
            ResourceLocation entityIdentifier = ResourceLocation.tryParse((String)entityId);
            if (entityIdentifier != null && matcher.equals(entityIdentifier.getNamespace())) {
                return true;
            }
        }
        catch (Exception e) {
            TickTweaks.LOGGER.error("Error checking mod ID match for {}", (Object)matcher, (Object)e);
        }
        return false;
    }
}

