/*
 * Decompiled with CFR 0.152.
 */
package banduty.ticktweaks.util;

import banduty.streq.StrEq;
import banduty.ticktweaks.TickTweaks;
import java.util.HashMap;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;

public class TickRateCalculator {
    public static int getCustomTickRate(MinecraftServer server, int specificTickRate) {
        float tickTime = server.getAverageTickTime();
        double tps = Math.min(1000.0 / (double)tickTime, 20.0);
        String formula = TickTweaks.CONFIG.coreTickSettings.getTickRateFormula();
        HashMap<String, Double> variables = new HashMap<String, Double>();
        variables.put("tps", tps);
        variables.put("mspt", Double.valueOf(tickTime));
        int customTickRate = (int)Math.round(Math.min(20.0, StrEq.evaluate((String)formula, variables)));
        return specificTickRate > 0 ? specificTickRate : customTickRate;
    }

    public static boolean shouldSkipTicking(ServerLevel level) {
        return !TickTweaks.CONFIG.coreTickSettings.isDimensionEnabled((ResourceKey<Level>)level.dimension());
    }
}

