/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.impl;

import info.u_team.u_team_core.api.registry.CommonRegister;
import info.u_team.u_team_core.api.registry.RegistryEntry;
import info.u_team.u_team_core.util.registry.BusRegister;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class ForgeCommonRegister<C>
implements CommonRegister<C> {
    private final DeferredRegister<C> register;
    private final String modid;

    ForgeCommonRegister(ResourceKey<? extends Registry<C>> key, String modid) {
        this.register = DeferredRegister.create(key, (String)modid);
        this.modid = modid;
    }

    @Override
    public <E extends C> ForgeRegistryEntry<E> register(String name, Function<ResourceLocation, ? extends E> function) {
        return this.register(name, () -> function.apply(new ResourceLocation(this.modid, name)));
    }

    @Override
    public <E extends C> ForgeRegistryEntry<E> register(String name, Supplier<? extends E> supplier) {
        return new ForgeRegistryEntry(this.register.register(name, supplier));
    }

    @Override
    public void register() {
        BusRegister.registerMod(arg_0 -> this.register.register(arg_0));
    }

    @Override
    public String getModid() {
        return this.modid;
    }

    @Override
    public ResourceKey<? extends Registry<C>> getRegistryKey() {
        return this.register.getRegistryKey();
    }

    @Override
    public Collection<RegistryEntry<C>> getEntries() {
        return Collections.unmodifiableCollection(this.register.getEntries().stream().map(object -> new ForgeRegistryEntry(object)).collect(Collectors.toCollection(LinkedHashSet::new)));
    }

    public DeferredRegister<C> getDeferredRegister() {
        return this.register;
    }

    public static class ForgeRegistryEntry<E>
    implements RegistryEntry<E> {
        private final RegistryObject<E> object;

        ForgeRegistryEntry(RegistryObject<E> object) {
            this.object = object;
        }

        @Override
        public E get() {
            return (E)this.object.get();
        }

        @Override
        public ResourceLocation getId() {
            return this.object.getId();
        }

        @Override
        public ResourceKey<E> getKey() {
            return this.object.getKey();
        }

        @Override
        public Optional<Holder<E>> getHolder() {
            return this.object.getHolder();
        }

        @Override
        public boolean isPresent() {
            return this.object.isPresent();
        }

        public RegistryObject<E> getRegistryObject() {
            return this.object;
        }
    }

    public static class Factory
    implements CommonRegister.Factory {
        @Override
        public <C> CommonRegister<C> create(ResourceKey<? extends Registry<C>> key, String modid) {
            return new ForgeCommonRegister(key, modid);
        }
    }
}

