/*
 * Decompiled with CFR 0.152.
 */
package me.rogue_one.useful_ribbits.goal;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import me.rogue_one.useful_ribbits.init.UsefulRibbitsModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;

public class FarmerRibbitGoal
extends Goal {
    private final Mob mob;
    private final double speed;
    private final int searchRange;
    private FarmState currentState = FarmState.GOING_TO_CHEST;
    private BlockPos targetChest = null;
    private List<BlockPos> farmlands = new ArrayList<BlockPos>();
    private List<BlockPos> plantableSpots = new ArrayList<BlockPos>();
    private List<BlockPos> harvestableSpots = new ArrayList<BlockPos>();
    private BlockPos currentTarget = null;
    private int tickCounter = 0;
    private int waitingTicks = 0;
    private int seedCount = 0;
    private int wheatCount = 0;

    public FarmerRibbitGoal(Mob mob, double speed, int searchRange) {
        this.mob = mob;
        this.speed = speed;
        this.searchRange = searchRange;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (!this.isDaytime()) {
            return false;
        }
        if (this.targetChest == null) {
            this.targetChest = this.findNearestRibbitChestWithSeeds();
            if (this.targetChest != null) {
                this.currentState = FarmState.GOING_TO_CHEST;
                this.analyzeFarmArea();
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    public boolean m_8045_() {
        return this.isDaytime() && this.targetChest != null;
    }

    public void m_8056_() {
        this.tickCounter = 0;
        this.waitingTicks = 0;
        if (this.targetChest != null) {
            this.currentState = FarmState.GOING_TO_CHEST;
            this.analyzeFarmArea();
        }
    }

    public void m_8041_() {
        this.currentState = FarmState.GOING_TO_CHEST;
        this.targetChest = null;
        this.currentTarget = null;
        this.farmlands.clear();
        this.plantableSpots.clear();
        this.harvestableSpots.clear();
        this.mob.m_21573_().m_26573_();
    }

    public void m_8037_() {
        if (!this.isDaytime()) {
            this.m_8041_();
            return;
        }
        ++this.tickCounter;
        switch (this.currentState) {
            case GOING_TO_CHEST: {
                this.handleGoingToChest();
                break;
            }
            case AT_CHEST_TAKING_SEEDS: {
                this.handleTakingSeeds();
                break;
            }
            case GOING_TO_PLANT: {
                this.handleGoingToPlant();
                break;
            }
            case PLANTING: {
                this.handlePlanting();
                break;
            }
            case GOING_TO_HARVEST: {
                this.handleGoingToHarvest();
                break;
            }
            case HARVESTING: {
                this.handleHarvesting();
                break;
            }
            case DEPOSITING: {
                this.handleDepositing();
                break;
            }
            case WAITING_AT_CHEST: {
                this.handleWaitingAtChest();
            }
        }
    }

    private void handleGoingToChest() {
        double distance = this.mob.m_20275_((double)this.targetChest.m_123341_() + 0.5, (double)this.targetChest.m_123342_(), (double)this.targetChest.m_123343_() + 0.5);
        if (distance < 1.5) {
            System.out.println("FarmerRibbitGoal - Arriv\u00e9 au coffre!");
            this.mob.m_21573_().m_26573_();
            this.currentState = FarmState.AT_CHEST_TAKING_SEEDS;
        } else {
            this.mob.m_21573_().m_26519_((double)this.targetChest.m_123341_() + 0.5, (double)this.targetChest.m_123342_(), (double)this.targetChest.m_123343_() + 0.5, this.speed);
        }
    }

    private void handleTakingSeeds() {
        this.updateTaskLists();
        int seedsNeeded = this.plantableSpots.size();
        int seedsToTake = Math.min(seedsNeeded, 64 - this.seedCount);
        if (seedsToTake > 0) {
            this.takeSeeds(seedsToTake);
        }
        if (!this.harvestableSpots.isEmpty()) {
            this.currentTarget = this.harvestableSpots.get(0);
            this.currentState = FarmState.GOING_TO_HARVEST;
        } else if (!this.plantableSpots.isEmpty() && this.seedCount > 0) {
            this.currentTarget = this.getClosestPlantableSpot();
            this.currentState = FarmState.GOING_TO_PLANT;
        } else {
            this.currentState = FarmState.WAITING_AT_CHEST;
            this.waitingTicks = 0;
        }
    }

    private void handleGoingToPlant() {
        if (this.currentTarget == null) {
            this.currentState = FarmState.GOING_TO_CHEST;
            return;
        }
        double targetX = (double)this.currentTarget.m_123341_() + 0.5;
        double targetY = this.currentTarget.m_123342_() + 1;
        double targetZ = (double)this.currentTarget.m_123343_() + 0.5;
        double distance = this.mob.m_20275_(targetX, targetY, targetZ);
        System.out.println("FarmerRibbitGoal - Distance lors de la plantation: " + Math.sqrt(distance));
        System.out.println("FarmerRibbitGoal - Position cible: " + targetX + ":" + targetY + ":" + targetZ);
        System.out.println("FarmerRibbitGoal - Position mob: " + this.mob.m_20185_() + ":" + this.mob.m_20186_() + ":" + this.mob.m_20189_());
        System.out.println("FarmerRibbitGoal - Navigation done: " + this.mob.m_21573_().m_26571_());
        System.out.println("FarmerRibbitGoal - Navigation stuck: " + this.mob.m_21573_().m_26577_());
        if (Math.sqrt(distance) < 1.5) {
            this.currentState = FarmState.PLANTING;
            this.mob.m_21573_().m_26573_();
            System.out.println("FarmerRibbitGoal - Assez proche pour planter!");
        } else if (this.mob.m_21573_().m_26571_() || !this.mob.m_21573_().m_26572_()) {
            System.out.println("FarmerRibbitGoal - Red\u00e9marrage de la navigation...");
            boolean pathSet = this.mob.m_21573_().m_26519_(targetX, targetY, targetZ, this.speed);
            System.out.println("FarmerRibbitGoal - Chemin d\u00e9fini: " + pathSet);
            if (!pathSet) {
                System.out.println("FarmerRibbitGoal - Tentative avec position alternative...");
                for (int dx = -1; dx <= 1; ++dx) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        if (dx == 0 && dz == 0) continue;
                        double altX = (double)this.currentTarget.m_123341_() + 0.5 + (double)dx;
                        double altZ = (double)this.currentTarget.m_123343_() + 0.5 + (double)dz;
                        if (!this.mob.m_21573_().m_26519_(altX, targetY, altZ, this.speed)) continue;
                        System.out.println("FarmerRibbitGoal - Position alternative trouv\u00e9e!");
                        return;
                    }
                }
                System.out.println("FarmerRibbitGoal - Aucun chemin possible, plantation forc\u00e9e!");
                this.currentState = FarmState.PLANTING;
            }
        }
    }

    private void handlePlanting() {
        if (this.currentTarget == null || this.seedCount <= 0) {
            this.currentState = FarmState.GOING_TO_CHEST;
            return;
        }
        BlockPos farmlandPos = this.currentTarget.m_7495_();
        BlockState farmlandState = this.mob.m_9236_().m_8055_(farmlandPos);
        BlockState currentBlockState = this.mob.m_9236_().m_8055_(this.currentTarget);
        System.out.println("FarmerRibbitGoal - Bloc farmland: " + String.valueOf(farmlandState.m_60734_()));
        System.out.println("FarmerRibbitGoal - Bloc cible: " + String.valueOf(currentBlockState.m_60734_()));
        System.out.println("FarmerRibbitGoal - Position mob pour plantation: " + this.mob.m_20185_() + ":" + this.mob.m_20186_() + ":" + this.mob.m_20189_());
        System.out.println("FarmerRibbitGoal - Position cible: " + this.currentTarget.m_123341_() + ":" + this.currentTarget.m_123342_() + ":" + this.currentTarget.m_123343_());
        if (this.plantSeed(this.currentTarget)) {
            --this.seedCount;
            this.plantableSpots.remove(this.currentTarget);
            System.out.println("FarmerRibbitGoal - Graine plant\u00e9e avec succ\u00e8s! Graines restantes: " + this.seedCount);
            if (!this.plantableSpots.isEmpty() && this.seedCount > 0) {
                this.currentTarget = this.getClosestPlantableSpot();
                this.currentState = FarmState.GOING_TO_PLANT;
            } else {
                this.currentTarget = null;
                this.currentState = FarmState.GOING_TO_CHEST;
            }
        } else {
            System.out.println("FarmerRibbitGoal - \u00c9CHEC de plantation!");
            System.out.println("FarmerRibbitGoal - Farmland valide: " + (farmlandState.m_60734_() instanceof FarmBlock));
            System.out.println("FarmerRibbitGoal - Bloc cible vide: " + currentBlockState.m_60795_());
            if (farmlandState.m_60734_() instanceof FarmBlock && currentBlockState.m_60795_()) {
                System.out.println("FarmerRibbitGoal - Tentative de plantation forc\u00e9e...");
                this.mob.m_9236_().m_7731_(this.currentTarget, Blocks.f_50092_.m_49966_(), 3);
                --this.seedCount;
                this.plantableSpots.remove(this.currentTarget);
                System.out.println("FarmerRibbitGoal - Plantation forc\u00e9e r\u00e9ussie!");
                if (!this.plantableSpots.isEmpty() && this.seedCount > 0) {
                    this.currentTarget = this.getClosestPlantableSpot();
                    this.currentState = FarmState.GOING_TO_PLANT;
                } else {
                    this.currentTarget = null;
                    this.currentState = FarmState.GOING_TO_CHEST;
                }
            } else {
                this.currentState = FarmState.GOING_TO_CHEST;
            }
        }
    }

    private void handleGoingToHarvest() {
        if (this.currentTarget == null) {
            this.currentState = FarmState.GOING_TO_CHEST;
            return;
        }
        double targetX = (double)this.currentTarget.m_123341_() + 0.5;
        double targetY = this.currentTarget.m_123342_();
        double targetZ = (double)this.currentTarget.m_123343_() + 0.5;
        double distance = this.mob.m_20275_(targetX, targetY, targetZ);
        System.out.println("FarmerRibbitGoal - Distance \u00e0 la r\u00e9colte: " + Math.sqrt(distance) + " blocks");
        System.out.println(targetX + ":" + targetY + ":" + targetZ);
        if (Math.sqrt(distance) < 0.25) {
            this.currentState = FarmState.HARVESTING;
            this.mob.m_21573_().m_26573_();
            System.out.println("FarmerRibbitGoal - Position atteinte, d\u00e9but r\u00e9colte!");
        } else {
            this.mob.m_21573_().m_26519_(targetX, targetY + 1.0, targetZ, this.speed * 1.2);
            if (this.mob.m_21573_().m_26577_()) {
                this.mob.m_6034_(targetX, targetY, targetZ);
                this.currentState = FarmState.HARVESTING;
                System.out.println("FarmerRibbitGoal - T\u00e9l\u00e9port\u00e9 sur le bloc pour d\u00e9bloquer!");
            }
        }
    }

    private void handleHarvesting() {
        if (this.currentTarget == null) {
            this.currentState = FarmState.GOING_TO_CHEST;
            return;
        }
        double targetX = (double)this.currentTarget.m_123341_() + 0.5;
        double targetY = (double)this.currentTarget.m_123342_() - 0.1;
        double targetZ = (double)this.currentTarget.m_123343_() + 0.5;
        double distance = this.mob.m_20275_(targetX, targetY, targetZ);
        System.out.println("FarmerRibbitGoal - Distance lors de la r\u00e9colte: " + Math.sqrt(distance));
        if (distance > 0.1) {
            System.out.println("FarmerRibbitGoal - Trop loin, repositionnement...");
            this.mob.m_6034_(targetX, targetY, targetZ);
            return;
        }
        if (this.harvestCrop(this.currentTarget)) {
            this.harvestableSpots.remove(this.currentTarget);
            if (this.seedCount > 0 && this.plantSeed(this.currentTarget)) {
                --this.seedCount;
                System.out.println("FarmerRibbitGoal - R\u00e9colt\u00e9 et replant\u00e9!");
            }
            this.currentTarget = null;
            this.currentState = FarmState.DEPOSITING;
        } else {
            System.out.println("FarmerRibbitGoal - \u00c9chec de r\u00e9colte!");
            this.currentState = FarmState.GOING_TO_CHEST;
        }
    }

    private void handleDepositing() {
        double distance = this.mob.m_20275_((double)this.targetChest.m_123341_() + 0.5, (double)this.targetChest.m_123342_(), (double)this.targetChest.m_123343_() + 0.5);
        if (distance < 1.5) {
            this.depositItems();
            this.currentState = FarmState.WAITING_AT_CHEST;
            this.waitingTicks = 0;
        } else {
            this.mob.m_21573_().m_26519_((double)this.targetChest.m_123341_() + 0.5, (double)this.targetChest.m_123342_(), (double)this.targetChest.m_123343_() + 0.5, this.speed);
        }
    }

    private void handleWaitingAtChest() {
        double distance;
        ++this.waitingTicks;
        if (this.waitingTicks >= 40) {
            this.waitingTicks = 0;
            this.updateTaskLists();
            if (!this.harvestableSpots.isEmpty()) {
                this.currentTarget = this.harvestableSpots.get(0);
                this.currentState = FarmState.GOING_TO_HARVEST;
            } else if (!this.plantableSpots.isEmpty() && this.chestHasSeeds(this.targetChest)) {
                this.currentState = FarmState.AT_CHEST_TAKING_SEEDS;
            }
        }
        if ((distance = this.mob.m_20275_((double)this.targetChest.m_123341_() + 0.5, (double)this.targetChest.m_123342_(), (double)this.targetChest.m_123343_() + 0.5)) > 2.0) {
            this.mob.m_21573_().m_26519_((double)this.targetChest.m_123341_() + 0.5, (double)this.targetChest.m_123342_(), (double)this.targetChest.m_123343_() + 0.5, this.speed);
        }
    }

    private BlockPos getClosestPlantableSpot() {
        if (this.plantableSpots.isEmpty()) {
            return null;
        }
        this.plantableSpots.sort((pos1, pos2) -> {
            double dist1 = this.targetChest.m_123331_((Vec3i)pos1);
            double dist2 = this.targetChest.m_123331_((Vec3i)pos2);
            return Double.compare(dist1, dist2);
        });
        return this.plantableSpots.get(0);
    }

    private boolean isDaytime() {
        Level level = this.mob.m_9236_();
        long time = level.m_46468_() % 24000L;
        return time >= 0L && time < 13000L;
    }

    private BlockPos findNearestRibbitChestWithSeeds() {
        BlockPos mobPos = this.mob.m_20183_();
        for (int x = -this.searchRange; x <= this.searchRange; ++x) {
            for (int y = -8; y <= 8; ++y) {
                for (int z = -this.searchRange; z <= this.searchRange; ++z) {
                    BlockPos pos = mobPos.m_7918_(x, y, z);
                    BlockState state = this.mob.m_9236_().m_8055_(pos);
                    if (!state.m_60713_((Block)UsefulRibbitsModBlocks.RIBBIT_CHEST.get()) || !this.chestHasSeeds(pos)) continue;
                    return pos;
                }
            }
        }
        return null;
    }

    private boolean chestHasSeeds(BlockPos pos) {
        BlockEntity blockEntity = this.mob.m_9236_().m_7702_(pos);
        if (blockEntity instanceof ChestBlockEntity) {
            ChestBlockEntity chest = (ChestBlockEntity)blockEntity;
            LazyOptional handlerOptional = chest.getCapability(ForgeCapabilities.ITEM_HANDLER);
            if (handlerOptional.isPresent()) {
                return handlerOptional.map(handler -> {
                    for (int i = 0; i < handler.getSlots(); ++i) {
                        ItemStack stack = handler.getStackInSlot(i);
                        if (!stack.m_150930_(Items.f_42404_)) continue;
                        return true;
                    }
                    return false;
                }).orElse(false);
            }
            try {
                for (int i = 0; i < chest.m_6643_(); ++i) {
                    ItemStack stack = chest.m_8020_(i);
                    if (!stack.m_150930_(Items.f_42404_)) continue;
                    return true;
                }
            }
            catch (Exception exception) {}
        } else if (blockEntity != null) {
            LazyOptional genericHandler = blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER);
            return genericHandler.map(handler -> {
                for (int i = 0; i < handler.getSlots(); ++i) {
                    ItemStack stack = handler.getStackInSlot(i);
                    if (!stack.m_150930_(Items.f_42404_)) continue;
                    return true;
                }
                return false;
            }).orElse(false);
        }
        return false;
    }

    private void analyzeFarmArea() {
        this.farmlands.clear();
        for (int x = -32; x <= 32; ++x) {
            for (int y = -3; y <= 3; ++y) {
                for (int z = -32; z <= 32; ++z) {
                    BlockPos pos = this.targetChest.m_7918_(x, y, z);
                    BlockState state = this.mob.m_9236_().m_8055_(pos);
                    if (!(state.m_60734_() instanceof FarmBlock)) continue;
                    this.farmlands.add(pos);
                }
            }
        }
        System.out.println("FarmerRibbitGoal - Trouv\u00e9 " + this.farmlands.size() + " farmlands");
    }

    private void updateTaskLists() {
        this.plantableSpots.clear();
        this.harvestableSpots.clear();
        for (BlockPos farmPos : this.farmlands) {
            CropBlock cropBlock;
            BlockPos cropPos = farmPos.m_7494_();
            BlockState cropState = this.mob.m_9236_().m_8055_(cropPos);
            if (cropState.m_60795_()) {
                this.plantableSpots.add(cropPos);
                continue;
            }
            Block block = cropState.m_60734_();
            if (!(block instanceof CropBlock) || !(cropBlock = (CropBlock)block).m_52307_(cropState)) continue;
            this.harvestableSpots.add(cropPos);
        }
        System.out.println("FarmerRibbitGoal - " + this.plantableSpots.size() + " spots plantables, " + this.harvestableSpots.size() + " \u00e0 r\u00e9colter");
    }

    private void takeSeeds(int amount) {
        BlockEntity blockEntity = this.mob.m_9236_().m_7702_(this.targetChest);
        if (blockEntity instanceof ChestBlockEntity) {
            ChestBlockEntity chest = (ChestBlockEntity)blockEntity;
            LazyOptional handlerOptional = chest.getCapability(ForgeCapabilities.ITEM_HANDLER);
            if (handlerOptional.isPresent()) {
                handlerOptional.ifPresent(handler -> {
                    int taken = 0;
                    for (int i = 0; i < handler.getSlots() && taken < amount; ++i) {
                        ItemStack stack = handler.getStackInSlot(i);
                        if (!stack.m_150930_(Items.f_42404_)) continue;
                        int toTake = Math.min(stack.m_41613_(), amount - taken);
                        ItemStack extracted = handler.extractItem(i, toTake, false);
                        taken += extracted.m_41613_();
                        this.seedCount += extracted.m_41613_();
                    }
                    System.out.println("FarmerRibbitGoal - Pris " + taken + " graines. Total: " + this.seedCount);
                });
            } else {
                try {
                    int taken = 0;
                    for (int i = 0; i < chest.m_6643_() && taken < amount; ++i) {
                        ItemStack stack = chest.m_8020_(i);
                        if (!stack.m_150930_(Items.f_42404_)) continue;
                        int toTake = Math.min(stack.m_41613_(), amount - taken);
                        ItemStack remaining = stack.m_41777_();
                        remaining.m_41774_(toTake);
                        chest.m_6836_(i, remaining);
                        taken += toTake;
                        this.seedCount += toTake;
                    }
                    System.out.println("FarmerRibbitGoal - Pris " + taken + " graines (direct). Total: " + this.seedCount);
                }
                catch (Exception e) {
                    System.out.println("FarmerRibbitGoal - Erreur: " + e.getMessage());
                }
            }
        } else if (blockEntity != null) {
            LazyOptional genericHandler = blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER);
            genericHandler.ifPresent(handler -> {
                int taken = 0;
                for (int i = 0; i < handler.getSlots() && taken < amount; ++i) {
                    ItemStack stack = handler.getStackInSlot(i);
                    if (!stack.m_150930_(Items.f_42404_)) continue;
                    int toTake = Math.min(stack.m_41613_(), amount - taken);
                    ItemStack extracted = handler.extractItem(i, toTake, false);
                    taken += extracted.m_41613_();
                    this.seedCount += extracted.m_41613_();
                }
                System.out.println("FarmerRibbitGoal - Pris " + taken + " graines (g\u00e9n\u00e9rique). Total: " + this.seedCount);
            });
        }
    }

    private boolean plantSeed(BlockPos pos) {
        BlockState farmland = this.mob.m_9236_().m_8055_(pos.m_7495_());
        if (farmland.m_60734_() instanceof FarmBlock && this.mob.m_9236_().m_8055_(pos).m_60795_()) {
            this.mob.m_9236_().m_7731_(pos, Blocks.f_50092_.m_49966_(), 3);
            return true;
        }
        return false;
    }

    private boolean harvestCrop(BlockPos pos) {
        CropBlock cropBlock;
        BlockState state = this.mob.m_9236_().m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof CropBlock && (cropBlock = (CropBlock)block).m_52307_(state)) {
            int harvestedWheat = 1 + this.mob.m_9236_().f_46441_.m_188503_(3);
            int harvestedSeeds = this.mob.m_9236_().f_46441_.m_188503_(4);
            this.wheatCount += harvestedWheat;
            this.seedCount += harvestedSeeds;
            if (this.seedCount > 64) {
                this.seedCount = 64;
            }
            this.mob.m_9236_().m_46961_(pos, false);
            System.out.println("FarmerRibbitGoal - R\u00e9colt\u00e9 " + harvestedWheat + " bl\u00e9 et " + harvestedSeeds + " graines! Total - Bl\u00e9: " + this.wheatCount + ", Graines: " + this.seedCount);
            return true;
        }
        return false;
    }

    private void depositItems() {
        BlockEntity blockEntity = this.mob.m_9236_().m_7702_(this.targetChest);
        if (blockEntity instanceof ChestBlockEntity) {
            ChestBlockEntity chest = (ChestBlockEntity)blockEntity;
            LazyOptional handlerOptional = chest.getCapability(ForgeCapabilities.ITEM_HANDLER);
            if (handlerOptional.isPresent()) {
                handlerOptional.ifPresent(handler -> {
                    int seedsToDeposit;
                    if (this.wheatCount > 0) {
                        ItemStack wheatStack = new ItemStack((ItemLike)Items.f_42405_, this.wheatCount);
                        for (int i = 0; i < handler.getSlots() && !wheatStack.m_41619_(); ++i) {
                            wheatStack = handler.insertItem(i, wheatStack, false);
                        }
                        this.wheatCount = wheatStack.m_41613_();
                    }
                    if ((seedsToDeposit = Math.max(0, this.seedCount - 16)) > 0) {
                        ItemStack seedStack = new ItemStack((ItemLike)Items.f_42404_, seedsToDeposit);
                        for (int i = 0; i < handler.getSlots() && !seedStack.m_41619_(); ++i) {
                            seedStack = handler.insertItem(i, seedStack, false);
                        }
                        this.seedCount -= seedsToDeposit - seedStack.m_41613_();
                    }
                    System.out.println("FarmerRibbitGoal - Items d\u00e9pos\u00e9s. Bl\u00e9 restant: " + this.wheatCount + ", Graines restantes: " + this.seedCount);
                });
            }
        } else if (blockEntity != null) {
            LazyOptional genericHandler = blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER);
            genericHandler.ifPresent(handler -> {
                int seedsToDeposit;
                if (this.wheatCount > 0) {
                    ItemStack wheatStack = new ItemStack((ItemLike)Items.f_42405_, this.wheatCount);
                    for (int i = 0; i < handler.getSlots() && !wheatStack.m_41619_(); ++i) {
                        wheatStack = handler.insertItem(i, wheatStack, false);
                    }
                    this.wheatCount = wheatStack.m_41613_();
                }
                if ((seedsToDeposit = Math.max(0, this.seedCount - 16)) > 0) {
                    ItemStack seedStack = new ItemStack((ItemLike)Items.f_42404_, seedsToDeposit);
                    for (int i = 0; i < handler.getSlots() && !seedStack.m_41619_(); ++i) {
                        seedStack = handler.insertItem(i, seedStack, false);
                    }
                    this.seedCount -= seedsToDeposit - seedStack.m_41613_();
                }
            });
        }
    }

    private static enum FarmState {
        GOING_TO_CHEST,
        AT_CHEST_TAKING_SEEDS,
        PLANTING,
        GOING_TO_PLANT,
        HARVESTING,
        GOING_TO_HARVEST,
        DEPOSITING,
        WAITING_AT_CHEST;

    }
}

