/*
 * Decompiled with CFR 0.152.
 */
package me.rogue_one.useful_ribbits.goal;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import me.rogue_one.useful_ribbits.init.UsefulRibbitsModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SmokerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class RibbitTransferMeatGoal
extends Goal {
    private final Mob mob;
    private final double speed;
    private final int searchRange;
    private BlockPos smokerPos;
    private BlockPos chestPos;
    private TaskState currentTask = TaskState.SEARCHING;
    private Item currentMeatType;
    private int carriedCookedAmount = 0;
    private int carriedRawAmount = 0;
    private int neededRawAmount = 0;
    private int tickCounter = 0;
    private int checkTimer = 0;
    private boolean hasPlayedOpenSound = false;
    private static final Set<Item> RAW_FOODS = Set.of(Items.f_42579_, Items.f_42485_, Items.f_42581_, Items.f_42697_, Items.f_42658_, Items.f_42526_, Items.f_42527_, Items.f_42528_, Items.f_42529_);
    private static final Map<Item, Item> COOKING_MAP = Map.of(Items.f_42579_, Items.f_42580_, Items.f_42485_, Items.f_42486_, Items.f_42581_, Items.f_42582_, Items.f_42697_, Items.f_42698_, Items.f_42658_, Items.f_42659_, Items.f_42526_, Items.f_42530_, Items.f_42527_, Items.f_42531_);

    public RibbitTransferMeatGoal(Mob mob, double speed, int searchRange) {
        this.mob = mob;
        this.speed = speed;
        this.searchRange = searchRange;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (!this.isDaytime()) {
            return false;
        }
        if (this.currentTask == TaskState.SEARCHING) {
            this.findSmoker();
        }
        return this.smokerPos != null;
    }

    public boolean m_8045_() {
        return this.isDaytime() && this.smokerPos != null;
    }

    public void m_8056_() {
        this.currentTask = TaskState.GOING_TO_SMOKER;
        this.resetVariables();
    }

    public void m_8041_() {
        this.currentTask = TaskState.SEARCHING;
        this.mob.m_21573_().m_26573_();
        this.resetVariables();
    }

    public void m_8037_() {
        ++this.tickCounter;
        ++this.checkTimer;
        switch (this.currentTask) {
            case GOING_TO_SMOKER: {
                this.handleGoingToSmoker();
                break;
            }
            case AT_SMOKER_WAITING: {
                this.handleAtSmokerWaiting();
                break;
            }
            case GOING_TO_CHEST: {
                this.handleGoingToChest();
                break;
            }
            case AT_CHEST_WORKING: {
                this.handleAtChestWorking();
                break;
            }
            case RETURNING_TO_SMOKER: {
                this.handleReturningToSmoker();
                break;
            }
            case RETURNING_EXCESS: {
                this.handleReturningExcess();
                break;
            }
            case WORKING_AT_SMOKER: {
                this.handleWorkingAtSmoker();
            }
        }
    }

    private void resetVariables() {
        this.currentMeatType = null;
        this.carriedCookedAmount = 0;
        this.carriedRawAmount = 0;
        this.neededRawAmount = 0;
        this.checkTimer = 0;
        this.hasPlayedOpenSound = false;
        this.chestPos = null;
    }

    private boolean isDaytime() {
        Level level = this.mob.m_9236_();
        long timeOfDay = level.m_46468_() % 24000L;
        return timeOfDay >= 0L && timeOfDay < 13000L;
    }

    private void findSmoker() {
        BlockPos mobPos = this.mob.m_20183_();
        this.smokerPos = null;
        for (int x = -this.searchRange; x <= this.searchRange; ++x) {
            for (int y = -3; y <= 3; ++y) {
                for (int z = -this.searchRange; z <= this.searchRange; ++z) {
                    BlockPos pos = mobPos.m_7918_(x, y, z);
                    BlockState state = this.mob.m_9236_().m_8055_(pos);
                    if (!state.m_60713_(Blocks.f_50619_)) continue;
                    this.smokerPos = pos;
                    return;
                }
            }
        }
    }

    private BlockPos findNearestChestWithRawFood(BlockPos center) {
        for (int x = -this.searchRange; x <= this.searchRange; ++x) {
            for (int y = -3; y <= 3; ++y) {
                for (int z = -this.searchRange; z <= this.searchRange; ++z) {
                    Container container;
                    BlockEntity blockEntity;
                    BlockPos pos = center.m_7918_(x, y, z);
                    BlockState state = this.mob.m_9236_().m_8055_(pos);
                    if (!state.m_60713_((Block)UsefulRibbitsModBlocks.RIBBIT_CHEST.get()) || !((blockEntity = this.mob.m_9236_().m_7702_(pos)) instanceof Container) || !this.hasRawFoodInContainer(container = (Container)blockEntity)) continue;
                    return pos;
                }
            }
        }
        return null;
    }

    private BlockPos findNearestChest(BlockPos center) {
        for (int x = -this.searchRange; x <= this.searchRange; ++x) {
            for (int y = -3; y <= 3; ++y) {
                for (int z = -this.searchRange; z <= this.searchRange; ++z) {
                    BlockPos pos = center.m_7918_(x, y, z);
                    BlockState state = this.mob.m_9236_().m_8055_(pos);
                    if (!state.m_60713_((Block)UsefulRibbitsModBlocks.RIBBIT_CHEST.get())) continue;
                    return pos;
                }
            }
        }
        return null;
    }

    private boolean hasRawFoodInContainer(Container container) {
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_() || !RAW_FOODS.contains(stack.m_41720_())) continue;
            return true;
        }
        return false;
    }

    private void handleGoingToSmoker() {
        if (this.mob.m_20275_((double)this.smokerPos.m_123341_(), (double)this.smokerPos.m_123342_(), (double)this.smokerPos.m_123343_()) < 2.5) {
            this.currentTask = TaskState.AT_SMOKER_WAITING;
        } else {
            this.navigateTo(this.smokerPos);
        }
    }

    private void handleAtSmokerWaiting() {
        if (this.checkTimer % 20 != 0) {
            return;
        }
        BlockEntity blockEntity = this.mob.m_9236_().m_7702_(this.smokerPos);
        if (blockEntity instanceof SmokerBlockEntity) {
            SmokerBlockEntity smokerEntity = (SmokerBlockEntity)blockEntity;
            ItemStack output = smokerEntity.m_8020_(2);
            if (!output.m_41619_()) {
                this.carriedCookedAmount = output.m_41613_();
                this.currentMeatType = this.getCookedMeatRawType(output.m_41720_());
                smokerEntity.m_6836_(2, ItemStack.f_41583_);
                this.chestPos = this.findNearestChest(this.smokerPos);
                if (this.chestPos != null) {
                    this.currentTask = TaskState.GOING_TO_CHEST;
                }
                return;
            }
            this.chestPos = this.findNearestChestWithRawFood(this.smokerPos);
            if (this.chestPos != null) {
                this.calculateNeeds(smokerEntity);
                if (this.neededRawAmount > 0 || this.carriedCookedAmount > 0) {
                    this.currentTask = TaskState.GOING_TO_CHEST;
                }
            }
        }
    }

    private Item getCookedMeatRawType(Item cookedItem) {
        for (Map.Entry<Item, Item> entry : COOKING_MAP.entrySet()) {
            if (entry.getValue() != cookedItem) continue;
            return entry.getKey();
        }
        return null;
    }

    private void calculateNeeds(SmokerBlockEntity smokerEntity) {
        BlockEntity blockEntity;
        ItemStack currentInput = smokerEntity.m_8020_(0);
        if (this.currentMeatType == null && this.chestPos != null && (blockEntity = this.mob.m_9236_().m_7702_(this.chestPos)) instanceof Container) {
            Container container = (Container)blockEntity;
            this.currentMeatType = this.findFirstRawFoodType(container);
        }
        if (this.currentMeatType == null) {
            this.neededRawAmount = 0;
            return;
        }
        this.neededRawAmount = currentInput.m_41619_() ? 64 : (currentInput.m_41720_() == this.currentMeatType ? 64 - currentInput.m_41613_() : 0);
    }

    private Item findFirstRawFoodType(Container container) {
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_() || !RAW_FOODS.contains(stack.m_41720_())) continue;
            return stack.m_41720_();
        }
        return null;
    }

    private void handleGoingToChest() {
        if (this.mob.m_20275_((double)this.chestPos.m_123341_() + 0.5, (double)this.chestPos.m_123342_(), (double)this.chestPos.m_123343_() + 0.5) < 1.5) {
            this.currentTask = TaskState.AT_CHEST_WORKING;
            if (!this.hasPlayedOpenSound) {
                this.mob.m_9236_().m_5594_(null, this.chestPos, SoundEvents.f_11749_, SoundSource.BLOCKS, 0.5f, this.mob.m_9236_().f_46441_.m_188501_() * 0.1f + 0.9f);
                this.hasPlayedOpenSound = true;
            }
        } else {
            this.navigateTo(this.chestPos);
        }
    }

    private void handleAtChestWorking() {
        BlockEntity blockEntity = this.mob.m_9236_().m_7702_(this.chestPos);
        if (blockEntity instanceof Container) {
            Item cookedItem;
            Container container = (Container)blockEntity;
            if (this.carriedCookedAmount > 0 && (cookedItem = COOKING_MAP.get(this.currentMeatType)) != null) {
                ItemStack toStore = new ItemStack((ItemLike)cookedItem, this.carriedCookedAmount);
                this.storeItemInContainer(container, toStore);
                this.carriedCookedAmount = 0;
            }
            if (this.neededRawAmount > 0) {
                if (this.getTotalItemsInContainer(container, this.currentMeatType) == 0) {
                    this.currentMeatType = this.findFirstRawFoodType(container);
                    if (this.currentMeatType != null) {
                        BlockEntity smokerBlockEntity = this.mob.m_9236_().m_7702_(this.smokerPos);
                        if (smokerBlockEntity instanceof SmokerBlockEntity) {
                            SmokerBlockEntity smokerEntity = (SmokerBlockEntity)smokerBlockEntity;
                            this.calculateNeeds(smokerEntity);
                        }
                    } else {
                        this.neededRawAmount = 0;
                    }
                }
                if (this.neededRawAmount > 0 && this.currentMeatType != null) {
                    int availableInChest = this.getTotalItemsInContainer(container, this.currentMeatType);
                    int toTake = Math.min(this.neededRawAmount, availableInChest);
                    this.carriedRawAmount = this.extractItemsFromContainer(container, this.currentMeatType, toTake);
                }
            }
            this.mob.m_9236_().m_5594_(null, this.chestPos, SoundEvents.f_11747_, SoundSource.BLOCKS, 0.5f, this.mob.m_9236_().f_46441_.m_188501_() * 0.1f + 0.9f);
            this.hasPlayedOpenSound = false;
            if (this.carriedRawAmount > 0) {
                this.currentTask = TaskState.RETURNING_TO_SMOKER;
            } else {
                this.currentTask = TaskState.AT_SMOKER_WAITING;
                this.navigateTo(this.smokerPos);
            }
        }
    }

    private void handleReturningToSmoker() {
        SmokerBlockEntity smokerEntity;
        ItemStack currentInput;
        int currentNeeded;
        BlockEntity blockEntity = this.mob.m_9236_().m_7702_(this.smokerPos);
        if (blockEntity instanceof SmokerBlockEntity && this.carriedRawAmount > (currentNeeded = (currentInput = (smokerEntity = (SmokerBlockEntity)blockEntity).m_8020_(0)).m_41619_() ? 64 : (currentInput.m_41720_() == this.currentMeatType ? 64 - currentInput.m_41613_() : 0))) {
            this.currentTask = TaskState.RETURNING_EXCESS;
            return;
        }
        if (this.mob.m_20275_((double)this.smokerPos.m_123341_(), (double)this.smokerPos.m_123342_(), (double)this.smokerPos.m_123343_()) < 2.5) {
            this.currentTask = TaskState.WORKING_AT_SMOKER;
        } else {
            this.navigateTo(this.smokerPos);
        }
    }

    private void handleReturningExcess() {
        if (this.mob.m_20275_((double)this.chestPos.m_123341_() + 0.5, (double)this.chestPos.m_123342_(), (double)this.chestPos.m_123343_() + 0.5) < 1.5) {
            BlockEntity blockEntity = this.mob.m_9236_().m_7702_(this.chestPos);
            if (blockEntity instanceof Container) {
                SmokerBlockEntity smokerEntity;
                ItemStack currentInput;
                int currentNeeded;
                int toReturn;
                Container container = (Container)blockEntity;
                BlockEntity smokerBlockEntity = this.mob.m_9236_().m_7702_(this.smokerPos);
                if (smokerBlockEntity instanceof SmokerBlockEntity && (toReturn = this.carriedRawAmount - (currentNeeded = (currentInput = (smokerEntity = (SmokerBlockEntity)smokerBlockEntity).m_8020_(0)).m_41619_() ? 64 : (currentInput.m_41720_() == this.currentMeatType ? 64 - currentInput.m_41613_() : 0))) > 0) {
                    ItemStack excessStack = new ItemStack((ItemLike)this.currentMeatType, toReturn);
                    this.storeItemInContainer(container, excessStack);
                    this.carriedRawAmount -= toReturn;
                }
            }
            this.currentTask = TaskState.RETURNING_TO_SMOKER;
        } else {
            this.navigateTo(this.chestPos);
        }
    }

    private void handleWorkingAtSmoker() {
        BlockEntity blockEntity = this.mob.m_9236_().m_7702_(this.smokerPos);
        if (blockEntity instanceof SmokerBlockEntity) {
            SmokerBlockEntity smokerEntity = (SmokerBlockEntity)blockEntity;
            if (this.carriedRawAmount > 0) {
                ItemStack currentInput = smokerEntity.m_8020_(0);
                if (currentInput.m_41619_()) {
                    smokerEntity.m_6836_(0, new ItemStack((ItemLike)this.currentMeatType, this.carriedRawAmount));
                    this.carriedRawAmount = 0;
                } else if (currentInput.m_41720_() == this.currentMeatType) {
                    int canAdd = 64 - currentInput.m_41613_();
                    int toAdd = Math.min(this.carriedRawAmount, canAdd);
                    currentInput.m_41769_(toAdd);
                    smokerEntity.m_6836_(0, currentInput);
                    this.carriedRawAmount -= toAdd;
                }
            }
            ItemStack output = smokerEntity.m_8020_(2);
            ItemStack input = smokerEntity.m_8020_(0);
            if (output.m_41613_() >= 64 || input.m_41619_() && output.m_41613_() > 0) {
                this.carriedCookedAmount = output.m_41613_();
                smokerEntity.m_6836_(2, ItemStack.f_41583_);
                this.chestPos = this.findNearestChest(this.smokerPos);
                if (this.chestPos != null) {
                    this.currentTask = TaskState.GOING_TO_CHEST;
                    this.neededRawAmount = 0;
                } else {
                    this.currentTask = TaskState.AT_SMOKER_WAITING;
                }
            } else if (input.m_41619_() && output.m_41619_()) {
                this.currentTask = TaskState.AT_SMOKER_WAITING;
                this.currentMeatType = null;
            }
        }
    }

    private void navigateTo(BlockPos pos) {
        PathNavigation navigation = this.mob.m_21573_();
        navigation.m_26519_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), this.speed);
    }

    private int getTotalItemsInContainer(Container container, Item item) {
        int total = 0;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41720_() != item) continue;
            total += stack.m_41613_();
        }
        return total;
    }

    private int extractItemsFromContainer(Container container, Item item, int amount) {
        int extracted = 0;
        for (int i = 0; i < container.m_6643_() && extracted < amount; ++i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41720_() != item) continue;
            int toExtract = Math.min(amount - extracted, stack.m_41613_());
            stack.m_41774_(toExtract);
            container.m_6836_(i, stack);
            extracted += toExtract;
        }
        return extracted;
    }

    private void storeItemInContainer(Container container, ItemStack itemStack) {
        int i;
        for (i = 0; i < container.m_6643_() && !itemStack.m_41619_(); ++i) {
            int canAdd;
            ItemStack existingStack = container.m_8020_(i);
            if (existingStack.m_41619_() || existingStack.m_41720_() != itemStack.m_41720_() || (canAdd = existingStack.m_41741_() - existingStack.m_41613_()) <= 0) continue;
            int toAdd = Math.min(canAdd, itemStack.m_41613_());
            existingStack.m_41769_(toAdd);
            itemStack.m_41774_(toAdd);
            container.m_6836_(i, existingStack);
        }
        for (i = 0; i < container.m_6643_() && !itemStack.m_41619_(); ++i) {
            if (!container.m_8020_(i).m_41619_()) continue;
            container.m_6836_(i, itemStack.m_41777_());
            itemStack.m_41764_(0);
            break;
        }
    }

    private static enum TaskState {
        SEARCHING,
        GOING_TO_SMOKER,
        AT_SMOKER_WAITING,
        GOING_TO_CHEST,
        AT_CHEST_WORKING,
        RETURNING_TO_SMOKER,
        RETURNING_EXCESS,
        WORKING_AT_SMOKER;

    }
}

