/*
 * Decompiled with CFR 0.152.
 */
package com.doctor.vampiricageing.actions;

import com.doctor.vampiricageing.capabilities.IAgeingCapability;
import com.doctor.vampiricageing.capabilities.VampiricAgeingCapabilityManager;
import com.doctor.vampiricageing.config.CommonConfig;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.vampire.DefaultVampireAction;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.particle.GenericParticleOptions;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class CelerityAction
extends DefaultVampireAction
implements ILastingAction<IVampirePlayer> {
    public static final UUID CELERITY_UUID = UUID.fromString("31c9aa6e-38e9-40ad-868f-b494981605a8");

    public boolean activate(@NotNull IVampirePlayer vampire, IAction.ActivationContext context) {
        vampire.getRepresentingPlayer().m_21051_(Attributes.f_22279_).m_22125_(new AttributeModifier(CELERITY_UUID, "SPEED_CELERITY_INCREASE", ((Double)CommonConfig.celerityActionMultiplier.get()).doubleValue(), AttributeModifier.Operation.MULTIPLY_TOTAL));
        return true;
    }

    public boolean canBeUsedBy(@NotNull IVampirePlayer vampire) {
        return ((IAgeingCapability)VampiricAgeingCapabilityManager.getAge((LivingEntity)vampire.getRepresentingPlayer()).orElse(null)).getAge() >= (Integer)CommonConfig.celerityActionRank.get();
    }

    public int getCooldown(IVampirePlayer player) {
        return (Integer)CommonConfig.celerityActionCooldown.get() * 20;
    }

    public int getDuration(@NotNull IVampirePlayer player) {
        return 20 * (Integer)CommonConfig.celerityActionDuration.get();
    }

    public boolean isEnabled() {
        return (Boolean)CommonConfig.celerityAction.get();
    }

    public void onActivatedClient(IVampirePlayer vampire) {
    }

    public void onDeactivated(@NotNull IVampirePlayer vampire) {
        VampiricAgeingCapabilityManager.removeModifier(vampire.getRepresentingPlayer().m_21051_(Attributes.f_22279_), CELERITY_UUID);
    }

    public void onReActivated(IVampirePlayer vampire) {
    }

    public boolean onUpdate(IVampirePlayer vampire) {
        if (!vampire.getRepresentingPlayer().m_20193_().f_46443_) {
            Player player = vampire.getRepresentingPlayer();
            ModParticles.spawnParticlesServer((Level)player.m_20193_(), (ParticleOptions)new GenericParticleOptions(new ResourceLocation("minecraft", "generic_4"), 5, 0xD3D3D3, 0.1f), (double)player.m_20185_(), (double)player.m_20186_(), (double)player.m_20189_(), (int)3, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        }
        return false;
    }

    public boolean showHudCooldown(Player player) {
        return true;
    }

    public boolean showHudDuration(Player player) {
        return true;
    }
}

