/*
 * Decompiled with CFR 0.152.
 */
package com.doctor.vampiricageing.actions;

import com.doctor.vampiricageing.capabilities.CapabilityHelper;
import com.doctor.vampiricageing.capabilities.VampiricAgeingCapabilityManager;
import com.doctor.vampiricageing.config.HunterAgeingConfig;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.hunter.DefaultHunterAction;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.entity.player.hunter.HunterPlayer;
import de.teamlapen.vampirism.util.Helper;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import org.jetbrains.annotations.NotNull;

public class LimitedHunterBatModeAction
extends DefaultHunterAction
implements ILastingAction<IHunterPlayer> {
    public static final float BAT_EYE_HEIGHT = 0.51000005f;
    public static final EntityDimensions BAT_SIZE = EntityDimensions.m_20398_((float)0.8f, (float)0.6f);
    private static final float PLAYER_WIDTH = 0.6f;
    private static final float PLAYER_HEIGHT = 1.8f;
    private final UUID armorModifierUUID = UUID.fromString("4392fccb-4bfd-4290-b2e6-5cc91439053c");
    private final UUID armorToughnessModifierUUID = UUID.fromString("6d3df16d-85e4-4b99-b2fc-301818697a6d");

    public boolean activate(IHunterPlayer hunter, IAction.ActivationContext context) {
        Player player = hunter.getRepresentingPlayer();
        this.setModifier(player, true);
        this.updatePlayer((HunterPlayer)hunter, true);
        return true;
    }

    public int getCooldown(IHunterPlayer hunter) {
        return (Integer)HunterAgeingConfig.limitedBatModeCooldown.get() * 20;
    }

    public int getDuration(IHunterPlayer hunter) {
        if (VampiricAgeingCapabilityManager.getAge((LivingEntity)hunter.getRepresentingPlayer()).map(ageCap -> ageCap.isTransformed()).orElse(false).booleanValue()) {
            return Mth.m_14045_((int)((Integer)HunterAgeingConfig.limitedBatModeDurationTransformed.get()), (int)10, (int)0x6666665) * 20;
        }
        return (Integer)HunterAgeingConfig.limitedBatModeDuration.get() * 20;
    }

    public boolean isEnabled() {
        return (Boolean)HunterAgeingConfig.hunterLimitedBatModeAction.get();
    }

    public boolean canBeUsedBy(@NotNull IHunterPlayer hunter) {
        return CapabilityHelper.getCumulativeTaintedAge(hunter.getRepresentingPlayer()) >= (Integer)HunterAgeingConfig.limitedBatModeAge.get() && !hunter.getRepresentingPlayer().m_20069_() && hunter.getRepresentingPlayer().m_20193_().m_46472_() != Level.f_46430_ && !this.shouldSunAffect(hunter.getRepresentingPlayer()) && !((List)VampirismConfig.SERVER.batDimensionBlacklist.get()).contains(hunter.getRepresentingPlayer().m_20193_().m_46472_().m_135782_().toString()) && hunter.getRepresentingEntity().m_20202_() == null;
    }

    public boolean shouldSunAffect(Player player) {
        return Helper.gettingSundamge((LivingEntity)player, (LevelAccessor)player.m_20193_(), (ProfilerFiller)player.m_20193_().m_46473_()) && (Boolean)HunterAgeingConfig.sunAffectLimitedBatMode.get() != false;
    }

    public void onActivatedClient(@NotNull IHunterPlayer hunter) {
        if (!VampiricAgeingCapabilityManager.getAge(hunter.getRepresentingEntity()).map(h -> h.getBatMode()).orElse(false).booleanValue()) {
            this.updatePlayer((HunterPlayer)hunter, true);
        }
    }

    public void onDeactivated(@NotNull IHunterPlayer hunter) {
        Player player = hunter.getRepresentingPlayer();
        this.setModifier(player, false);
        if (!player.m_20096_()) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 20, 100, false, false));
        }
        this.updatePlayer((HunterPlayer)hunter, false);
    }

    public boolean onUpdate(@NotNull IHunterPlayer hunter) {
        if (((List)VampirismConfig.SERVER.batDimensionBlacklist.get()).contains(hunter.getRepresentingPlayer().m_20193_().m_46472_().m_135782_().toString()) && hunter.getRepresentingPlayer().m_20193_().m_46472_() == Level.f_46430_) {
            hunter.getRepresentingPlayer().m_213846_((Component)Component.m_237115_((String)"text.vampirism.cant_fly_dimension"));
            return true;
        }
        if (this.shouldSunAffect(hunter.getRepresentingPlayer()) && !hunter.isRemote()) {
            hunter.getRepresentingPlayer().m_213846_((Component)Component.m_237115_((String)"text.vampirism.cant_fly_day"));
            return true;
        }
        float exhaustion = ((Double)HunterAgeingConfig.limitedBatExhaustion.get()).floatValue();
        if (exhaustion > 0.0f) {
            hunter.getRepresentingPlayer().m_36324_().m_38703_(exhaustion);
        }
        return hunter.getRepresentingPlayer().m_20069_();
    }

    public void onReActivated(@NotNull IHunterPlayer hunter) {
        this.setModifier(hunter.getRepresentingPlayer(), true);
        if (!VampiricAgeingCapabilityManager.getAge(hunter.getRepresentingEntity()).map(h -> h.getBatMode()).orElse(false).booleanValue()) {
            this.updatePlayer((HunterPlayer)hunter, true);
        }
    }

    private void setModifier(Player player, boolean enabled) {
        if (enabled) {
            AttributeInstance armorToughnessAttributeInst;
            AttributeInstance armorAttributeInst = player.m_21051_(Attributes.f_22284_);
            if (armorAttributeInst.m_22111_(this.armorModifierUUID) == null) {
                armorAttributeInst.m_22125_(new AttributeModifier(this.armorModifierUUID, "Bat Armor Disabled", -1.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
            }
            if ((armorToughnessAttributeInst = player.m_21051_(Attributes.f_22285_)).m_22111_(this.armorToughnessModifierUUID) == null) {
                armorToughnessAttributeInst.m_22125_(new AttributeModifier(this.armorToughnessModifierUUID, "Bat Armor Disabled", -1.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
            }
            player.m_150110_().f_35936_ = true;
            player.m_150110_().f_35935_ = true;
            this.setFlightSpeed(player, ((Double)VampirismConfig.BALANCE.vaBatFlightSpeed.get()).floatValue());
        } else {
            AttributeInstance armorToughnessAttributeInst;
            AttributeModifier m2;
            AttributeInstance armorAttributeInst = player.m_21051_(Attributes.f_22284_);
            AttributeModifier m = armorAttributeInst.m_22111_(this.armorModifierUUID);
            if (m != null) {
                armorAttributeInst.m_22130_(m);
            }
            if ((m2 = (armorToughnessAttributeInst = player.m_21051_(Attributes.f_22285_)).m_22111_(this.armorToughnessModifierUUID)) != null) {
                armorToughnessAttributeInst.m_22130_(m2);
            }
            boolean spectator = player.m_5833_();
            boolean creative = player.m_7500_();
            player.m_150110_().f_35936_ = spectator || creative;
            player.m_150110_().f_35935_ = spectator;
            this.setFlightSpeed(player, 0.05f);
        }
        player.m_6885_();
    }

    private void updatePlayer(@NotNull HunterPlayer hunter, boolean bat) {
        Player player = hunter.getRepresentingPlayer();
        VampiricAgeingCapabilityManager.getAge((LivingEntity)player).ifPresent(hntr -> hntr.setBatMode(bat));
        VampiricAgeingCapabilityManager.syncAgeCap(player);
        player.m_6210_();
        player.m_20124_(Pose.CROUCHING);
        player.setForcedPose(bat ? null : Pose.STANDING);
        if (bat) {
            player.m_6034_(player.m_20185_(), player.m_20186_() + (double)(1.8f - LimitedHunterBatModeAction.BAT_SIZE.f_20378_), player.m_20189_());
        }
    }

    private void setFlightSpeed(@NotNull Player player, float speed) {
        player.m_150110_().f_35939_ = speed;
    }

    public boolean showHudDuration(Player player) {
        return true;
    }
}

