/*
 * Decompiled with CFR 0.152.
 */
package com.doctor.vampiricageing.command;

import com.doctor.vampiricageing.capabilities.CapabilityHelper;
import com.doctor.vampiricageing.capabilities.VampiricAgeingCapabilityManager;
import com.doctor.vampiricageing.config.HunterAgeingConfig;
import com.doctor.vampiricageing.config.WerewolvesAgeingConfig;
import com.doctor.vampiricageing.init.ModEffects;
import com.google.common.collect.Lists;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.teamlapen.lib.lib.util.BasicCommand;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.util.Helper;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.NotNull;

public class ChangeAgeCommand
extends BasicCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"age").requires(context -> context.m_6761_(2))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"age", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> ChangeAgeCommand.setAge((CommandContext<CommandSourceStack>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"age"), Lists.newArrayList((Object[])new ServerPlayer[]{((CommandSourceStack)context.getSource()).m_81375_()})))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91460_()).executes(context -> ChangeAgeCommand.setAge((CommandContext<CommandSourceStack>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"age"), EntityArgument.m_91477_((CommandContext)context, (String)"player")))));
    }

    private static int setAge(@NotNull CommandContext<CommandSourceStack> context, int age, @NotNull Collection<ServerPlayer> players) {
        for (ServerPlayer player : players) {
            int level = FactionPlayerHandler.getOpt((Player)player).map(FactionPlayerHandler::getCurrentLevel).orElse(0);
            if (age < 6 && age >= 0 && level > 0) {
                VampiricAgeingCapabilityManager.getAge((LivingEntity)player).ifPresent(ageCap -> ageCap.setAge(age));
                VampiricAgeingCapabilityManager.syncAgeCap((Player)player);
                if (Helper.isHunter((Player)player) && player.m_21023_((MobEffect)ModEffects.TAINTED_BLOOD_EFFECT.get())) {
                    player.m_21195_((MobEffect)ModEffects.TAINTED_BLOOD_EFFECT.get());
                }
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"command.vampiricageing.base.age.success", (Object[])new Object[]{player.m_7755_(), age}), true);
                continue;
            }
            if (age > 5 || age < 0) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)(players.size() > 1 ? Component.m_237110_((String)"command.vampiricageing.failed_to_execute.players.age", (Object[])new Object[]{player.m_5446_()}) : Component.m_237115_((String)"command.vampiricageing.failed_to_execute.age")));
                continue;
            }
            if (Helper.isHunter((Player)player) && !((Boolean)HunterAgeingConfig.hunterAgeing.get()).booleanValue()) {
                if (ModList.get().isLoaded("werewolves") && ((Boolean)WerewolvesAgeingConfig.werewolfAgeing.get()).booleanValue()) {
                    ((CommandSourceStack)context.getSource()).m_81352_((Component)(players.size() > 1 ? Component.m_237110_((String)"command.vampiricageing.failed_to_execute.players.wrong_faction_werewolves_enabled", (Object[])new Object[]{player.m_5446_()}) : Component.m_237115_((String)"command.vampiricageing.failed_to_execute.wrong_faction_werewolves_enabled")));
                    continue;
                }
                ((CommandSourceStack)context.getSource()).m_81352_((Component)(players.size() > 1 ? Component.m_237110_((String)"command.vampiricageing.failed_to_execute.players.wrong_faction", (Object[])new Object[]{player.m_5446_()}) : Component.m_237115_((String)"command.vampiricageing.failed_to_execute.wrong_faction")));
                continue;
            }
            if (CapabilityHelper.isWerewolfCheckMod((Entity)player) && ((Boolean)WerewolvesAgeingConfig.werewolfAgeing.get()).booleanValue()) {
                if (((Boolean)HunterAgeingConfig.hunterAgeing.get()).booleanValue()) {
                    ((CommandSourceStack)context.getSource()).m_81352_((Component)(players.size() > 1 ? Component.m_237110_((String)"command.vampiricageing.failed_to_execute.players.wrong_faction_hunters_enabled", (Object[])new Object[]{player.m_5446_()}) : Component.m_237115_((String)"command.vampiricageing.failed_to_execute.wrong_faction_hunters_enabled")));
                    continue;
                }
                ((CommandSourceStack)context.getSource()).m_81352_((Component)(players.size() > 1 ? Component.m_237110_((String)"command.vampiricageing.failed_to_execute.players.wrong_faction", (Object[])new Object[]{player.m_5446_()}) : Component.m_237115_((String)"command.vampiricageing.failed_to_execute.wrong_faction")));
                continue;
            }
            ((CommandSourceStack)context.getSource()).m_81352_((Component)(players.size() > 1 ? Component.m_237110_((String)"command.vampiricageing.failed_to_execute.players", (Object[])new Object[]{player.m_5446_()}) : Component.m_237115_((String)"command.vampiricageing.failed_to_execute")));
        }
        return 0;
    }
}

