/*
 * Decompiled with CFR 0.152.
 */
package com.doctor.vampiricageing.items;

import com.doctor.vampiricageing.capabilities.VampiricAgeingCapabilityManager;
import com.doctor.vampiricageing.config.HunterAgeingConfig;
import com.doctor.vampiricageing.init.ModEffects;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.api.items.IFactionExclusiveItem;
import de.teamlapen.vampirism.util.Helper;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TaintedBloodBottleItem
extends Item
implements IFactionExclusiveItem {
    public TaintedBloodBottleItem(Item.Properties props) {
        super(props);
    }

    @Nullable
    public IFaction<?> getExclusiveFaction(@NotNull ItemStack itemStack) {
        return VReference.HUNTER_FACTION;
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack stack) {
        return UseAnim.DRINK;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!((Boolean)HunterAgeingConfig.taintedBloodAvailable.get()).booleanValue()) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }
        if (!Helper.isHunter((Player)player)) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }
        int age = VampiricAgeingCapabilityManager.getAge((LivingEntity)player).map(ageCap -> ageCap.getAge()).orElse(0);
        boolean transformed = VampiricAgeingCapabilityManager.getAge((LivingEntity)player).map(ageCap -> ageCap.isTransformed()).orElse(false);
        if (age >= (Integer)HunterAgeingConfig.taintedBloodBottleAge.get() && !transformed) {
            player.m_6672_(hand);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return super.m_7203_(level, player, hand);
    }

    public void m_5929_(@NotNull Level level, @NotNull LivingEntity pLivingEntity, @NotNull ItemStack stack, int count) {
        if (pLivingEntity instanceof IHunterPlayer) {
            return;
        }
        if (!(pLivingEntity instanceof Player && pLivingEntity.m_6084_() && ((Boolean)HunterAgeingConfig.taintedBloodAvailable.get()).booleanValue())) {
            pLivingEntity.m_21253_();
            return;
        }
        Player player = (Player)pLivingEntity;
        int age = VampiricAgeingCapabilityManager.getAge((LivingEntity)player).map(ageCap -> ageCap.getAge()).orElse(0);
        if (age >= (Integer)HunterAgeingConfig.taintedBloodBottleAge.get()) {
            pLivingEntity.m_6672_(pLivingEntity.m_7655_());
        }
    }

    @NotNull
    public ItemStack m_5922_(@NotNull ItemStack stack, @NotNull Level worldIn, @NotNull LivingEntity entityLiving) {
        if (entityLiving instanceof Player && Helper.isHunter((Entity)entityLiving)) {
            int age = stack.m_41773_();
            VampiricAgeingCapabilityManager.getAge(entityLiving).ifPresent(hunter -> {
                hunter.setTemporaryTainedTicks((Integer)HunterAgeingConfig.temporaryTaintedBloodBaseTicks.get() * hunter.getAge());
                hunter.setTemporaryTaintedAgeBonus(age);
                entityLiving.m_7292_(new MobEffectInstance((MobEffect)ModEffects.TAINTED_BLOOD_EFFECT.get(), (Integer)HunterAgeingConfig.temporaryTaintedBloodBaseTicks.get() * hunter.getAge(), 0, false, false));
                VampiricAgeingCapabilityManager.syncAgeCap((Player)entityLiving);
                stack.m_41774_(1);
            });
        }
        return super.m_5922_(stack, worldIn, entityLiving);
    }

    public int m_8105_(@NotNull ItemStack stack) {
        return 45;
    }

    public boolean m_142522_(@NotNull ItemStack stack) {
        return false;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag tf) {
        components.add((Component)Component.m_237110_((String)"text.vampiricageing.tainted_blood_useage", (Object[])new Object[]{HunterAgeingConfig.taintedBloodBottleAge.get()}).m_130940_(ChatFormatting.GRAY));
        components.add((Component)Component.m_237110_((String)"text.vampiricageing.tainted_blood_rank", (Object[])new Object[]{stack.m_41773_()}).m_130940_(ChatFormatting.RED));
        super.m_7373_(stack, level, components, tf);
    }
}

